/*
 * Decompiled with CFR 0.152.
 */
package cn.alini.craftaudit.command;

import cn.alini.craftaudit.AuditModeManager;
import cn.alini.craftaudit.config.Config;
import cn.alini.craftaudit.event.block.BlockInspectListener;
import cn.alini.craftaudit.rollback.RollbackService;
import cn.alini.craftaudit.rollback.UndoManager;
import cn.alini.craftaudit.storage.Database;
import cn.alini.craftaudit.storage.LogEntry;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="craftaudit")
public final class CraftauditCommands {
    private static final int CHECK_PAGE_SIZE = 15;
    private static final boolean CHECK_REPLACE_MODE = true;
    private static final int CHECK_CLEAR_LINES = 40;
    private static final SuggestionProvider<CommandSourceStack> ONLINE_PLAYER_SUGGESTIONS = (ctx, builder) -> {
        List list = ((CommandSourceStack)ctx.getSource()).m_81377_().m_6846_().m_11314_();
        List<String> names = list.stream().map(p -> p.m_36316_().getName()).toList();
        return SharedSuggestionProvider.m_82970_(names, (SuggestionsBuilder)builder);
    };
    private static final Pattern DURATION_PATTERN = Pattern.compile("^(\\d+)([smhdSMHD])$");

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        boolean requirePerm = (Boolean)Config.COMMON.auditRequirePermission.get();
        CommandDispatcher d = event.getDispatcher();
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"craftaudit").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"status").requires(src -> src.m_6761_(2))).executes(ctx -> CraftauditCommands.report((CommandSourceStack)ctx.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"inspect").requires(src -> !requirePerm || src.m_6761_(2))).executes(ctx -> CraftauditCommands.toggleAudit((CommandSourceStack)ctx.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"checkUUID").requires(src -> src.m_6761_(2))).then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.word()).suggests(ONLINE_PLAYER_SUGGESTIONS).executes(ctx -> CraftauditCommands.checkUUID((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"player")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"check").requires(src -> src.m_6761_(2))).then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.word()).suggests(ONLINE_PLAYER_SUGGESTIONS).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"time", (ArgumentType)StringArgumentType.word()).executes(ctx -> CraftauditCommands.checkOps((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"player"), StringArgumentType.getString((CommandContext)ctx, (String)"time"), 1))).then(Commands.m_82129_((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> CraftauditCommands.checkOps((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"player"), StringArgumentType.getString((CommandContext)ctx, (String)"time"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page")))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"log").requires(src -> !requirePerm || src.m_6761_(2))).executes(ctx -> CraftauditCommands.inspectAudit((CommandSourceStack)ctx.getSource(), 1))).then(Commands.m_82129_((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> CraftauditCommands.inspectAudit((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"blocklog").requires(src -> !requirePerm || src.m_6761_(2))).executes(ctx -> CraftauditCommands.inspectBlockAudit((CommandSourceStack)ctx.getSource(), 1))).then(Commands.m_82129_((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).executes(ctx -> CraftauditCommands.inspectBlockAudit((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"near").requires(src -> !requirePerm || src.m_6761_(2))).then(Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)256)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"time", (ArgumentType)StringArgumentType.word()).executes(ctx -> CraftauditCommands.near((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"), StringArgumentType.getString((CommandContext)ctx, (String)"time"), 1))).then(Commands.m_82129_((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> CraftauditCommands.near((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"), StringArgumentType.getString((CommandContext)ctx, (String)"time"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page")))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"rollback").requires(src -> src.m_6761_(2))).then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.word()).suggests(ONLINE_PLAYER_SUGGESTIONS).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"time", (ArgumentType)StringArgumentType.word()).executes(ctx -> CraftauditCommands.rollback((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"player"), StringArgumentType.getString((CommandContext)ctx, (String)"time"), 10))).then(Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)256)).executes(ctx -> CraftauditCommands.rollback((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"player"), StringArgumentType.getString((CommandContext)ctx, (String)"time"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius")))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"restore").requires(src -> src.m_6761_(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"time", (ArgumentType)StringArgumentType.word()).executes(ctx -> CraftauditCommands.restore((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"time"), 10, null))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)256)).executes(ctx -> CraftauditCommands.restore((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"time"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"), null))).then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.word()).executes(ctx -> CraftauditCommands.restore((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"time"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"), StringArgumentType.getString((CommandContext)ctx, (String)"type")))))).then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.word()).executes(ctx -> CraftauditCommands.restore((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"time"), 10, StringArgumentType.getString((CommandContext)ctx, (String)"type"))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"purge").requires(src -> src.m_6761_(2))).then(Commands.m_82129_((String)"time", (ArgumentType)StringArgumentType.word()).executes(ctx -> CraftauditCommands.purge((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"time")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"undo").requires(src -> src.m_6761_(2))).executes(ctx -> CraftauditCommands.undo((CommandSourceStack)ctx.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"help").requires(src -> !requirePerm || src.m_6761_(2))).executes(ctx -> {
            CommandSourceStack src = (CommandSourceStack)ctx.getSource();
            src.m_288197_(() -> Component.m_237113_((String)"\u00a73[CraftAudit] \u6307\u4ee4\u5217\u8868\uff1a\n\u00a7b/craftaudit status \u00a77- \u663e\u793a\u63d2\u4ef6\u72b6\u6001\n\u00a7b/craftaudit inspect \u00a77- \u5207\u6362\u5ba1\u8ba1\u6a21\u5f0f\n\u00a7b/craftaudit check <player> <time> [page] \u00a77- \u67e5\u8be2\u73a9\u5bb6\u5728\u65f6\u95f4\u8303\u56f4\u5185\u7684\u6240\u6709\u64cd\u4f5c\n\u00a7b/craftaudit log [page] \u00a77- \u67e5\u770b\u4ea4\u4e92\u65e5\u5fd7\n\u00a7b/craftaudit blocklog [page] \u00a77- \u67e5\u770b\u65b9\u5757\u65e5\u5fd7\n\u00a7b/craftaudit near <radius> <time> [page] \u00a77- \u67e5\u770b\u9644\u8fd1\u65b9\u5757\u65e5\u5fd7\n\u00a7b/craftaudit rollback <player> <time> [radius] \u00a77- \u56de\u6eda\u73a9\u5bb6\u7834\u574f\u7684\u65b9\u5757\n\u00a7b/craftaudit restore <time> [radius] [type] \u00a77- \u6062\u590d\u7834\u574f/\u51fb\u6740\u8bb0\u5f55\uff08\u652f\u6301 type \u8fc7\u6ee4\uff09\n\u00a7b/craftaudit purge <time> \u00a77- \u6e05\u7406\u65e9\u4e8e\u6307\u5b9a\u65f6\u95f4\u7684\u65e5\u5fd7\uff08\u4e0d\u53ef\u64a4\u9500\uff09\n\u00a7b/craftaudit undo \u00a77- \u64a4\u9500\u4e0a\u6b21\u56de\u6eda/\u6062\u590d\n\n\u00a7b/ca ... \u00a77- /craftaudit \u7684\u7b80\u5199"), false);
            return 1;
        })));
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ca").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"s").requires(src -> src.m_6761_(2))).executes(ctx -> CraftauditCommands.report((CommandSourceStack)ctx.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"i").requires(src -> !requirePerm || src.m_6761_(2))).executes(ctx -> CraftauditCommands.toggleAudit((CommandSourceStack)ctx.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"checkUUID").requires(src -> src.m_6761_(2))).then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.word()).suggests(ONLINE_PLAYER_SUGGESTIONS).executes(ctx -> CraftauditCommands.checkUUID((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"player")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"check").requires(src -> src.m_6761_(2))).then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.word()).suggests(ONLINE_PLAYER_SUGGESTIONS).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"time", (ArgumentType)StringArgumentType.word()).executes(ctx -> CraftauditCommands.checkOps((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"player"), StringArgumentType.getString((CommandContext)ctx, (String)"time"), 1))).then(Commands.m_82129_((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> CraftauditCommands.checkOps((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"player"), StringArgumentType.getString((CommandContext)ctx, (String)"time"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page")))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"log").requires(src -> !requirePerm || src.m_6761_(2))).executes(ctx -> CraftauditCommands.inspectAudit((CommandSourceStack)ctx.getSource(), 1))).then(Commands.m_82129_((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> CraftauditCommands.inspectAudit((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"blocklog").requires(src -> !requirePerm || src.m_6761_(2))).executes(ctx -> CraftauditCommands.inspectBlockAudit((CommandSourceStack)ctx.getSource(), 1))).then(Commands.m_82129_((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> CraftauditCommands.inspectBlockAudit((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"near").requires(src -> !requirePerm || src.m_6761_(2))).then(Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)256)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"time", (ArgumentType)StringArgumentType.word()).executes(ctx -> CraftauditCommands.near((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"), StringArgumentType.getString((CommandContext)ctx, (String)"time"), 1))).then(Commands.m_82129_((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> CraftauditCommands.near((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"), StringArgumentType.getString((CommandContext)ctx, (String)"time"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page")))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"rollback").requires(src -> src.m_6761_(2))).then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.word()).suggests(ONLINE_PLAYER_SUGGESTIONS).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"time", (ArgumentType)StringArgumentType.word()).executes(ctx -> CraftauditCommands.rollback((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"player"), StringArgumentType.getString((CommandContext)ctx, (String)"time"), 10))).then(Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)256)).executes(ctx -> CraftauditCommands.rollback((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"player"), StringArgumentType.getString((CommandContext)ctx, (String)"time"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius")))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"restore").requires(src -> src.m_6761_(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"time", (ArgumentType)StringArgumentType.word()).executes(ctx -> CraftauditCommands.restore((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"time"), 10, null))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)256)).executes(ctx -> CraftauditCommands.restore((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"time"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"), null))).then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.word()).executes(ctx -> CraftauditCommands.restore((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"time"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"), StringArgumentType.getString((CommandContext)ctx, (String)"type")))))).then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.word()).executes(ctx -> CraftauditCommands.restore((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"time"), 10, StringArgumentType.getString((CommandContext)ctx, (String)"type"))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"purge").requires(src -> src.m_6761_(2))).then(Commands.m_82129_((String)"time", (ArgumentType)StringArgumentType.word()).executes(ctx -> CraftauditCommands.purge((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"time")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"undo").requires(src -> src.m_6761_(2))).executes(ctx -> CraftauditCommands.undo((CommandSourceStack)ctx.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"help").requires(src -> !requirePerm || src.m_6761_(2))).executes(ctx -> {
            CommandSourceStack src = (CommandSourceStack)ctx.getSource();
            src.m_288197_(() -> Component.m_237113_((String)"\u00a73[CraftAudit] \u6307\u4ee4\u5217\u8868\uff1a\n\u00a7b/ca s \u00a77- \u663e\u793a\u63d2\u4ef6\u72b6\u6001\n\u00a7b/ca i \u00a77- \u5207\u6362\u5ba1\u8ba1\u6a21\u5f0f\n\u00a7b/ca check <player> <time> [page] \u00a77- \u67e5\u8be2\u73a9\u5bb6\u5728\u65f6\u95f4\u8303\u56f4\u5185\u7684\u6240\u6709\u64cd\u4f5c\uff08\u5e26\u5206\u9875\uff09\n\u00a7b/ca log [page] \u00a77- \u67e5\u770b\u4ea4\u4e92\u65e5\u5fd7\n\u00a7b/ca blocklog [page] \u00a77- \u67e5\u770b\u65b9\u5757\u65e5\u5fd7\n\u00a7b/ca near <radius> <time> [page] \u00a77- \u67e5\u770b\u9644\u8fd1\u65b9\u5757\u65e5\u5fd7\n\u00a7b/ca rollback <player> <time> [radius] \u00a77- \u56de\u6eda\u73a9\u5bb6\u7834\u574f\u7684\u65b9\u5757\n\u00a7b/ca restore <time> [radius] [type] \u00a77- \u6062\u590d\u7834\u574f/\u51fb\u6740\u8bb0\u5f55\n\u00a7b/ca purge <time> \u00a77- \u6e05\u7406\u65e7\u65e5\u5fd7\n\u00a7b/ca undo \u00a77- \u64a4\u9500\u4e0a\u6b21\u56de\u6eda/\u6062\u590d\n\n\u00a7b/craftaudit ... \u00a77- /ca \u7684\u5168\u79f0"), false);
            return 1;
        })));
    }

    private static int checkOps(CommandSourceStack src, String playerArg, String timeStr, int page) {
        if (!Database.isConnected()) {
            src.m_81352_((Component)Component.m_237113_((String)"\u00a7c\u6570\u636e\u5e93\u672a\u8fde\u63a5\u3002"));
            return 0;
        }
        long durMs = CraftauditCommands.parseDurationMillis(timeStr);
        if (durMs <= 0L) {
            src.m_81352_((Component)Component.m_237113_((String)"\u00a7c\u65f6\u95f4\u683c\u5f0f\u65e0\u6548\uff01\u793a\u4f8b\uff1a5d\u300112h\u300130m\u300145s"));
            return 0;
        }
        long sinceMs = System.currentTimeMillis() - durMs;
        ServerPlayer online = src.m_81377_().m_6846_().m_11255_(playerArg);
        String playerName = playerArg;
        String playerUuid = null;
        if (online != null) {
            playerName = online.m_7755_().getString();
            playerUuid = online.m_20148_().toString();
        } else if (CraftauditCommands.looksLikeUuid(playerArg)) {
            playerUuid = playerArg;
        }
        int total = Database.get().countLogsByActorSince(playerName, playerUuid, sinceMs);
        int totalPages = Math.max((total + 15 - 1) / 15, 1);
        if (page < 1) {
            page = 1;
        }
        if (page > totalPages) {
            page = totalPages;
        }
        List<LogEntry> logs = Database.get().queryLogsByActorSince(playerName, playerUuid, sinceMs, page, 15);
        ServerPlayer viewer = src.m_230896_();
        if (viewer != null) {
            for (int i = 0; i < 40; ++i) {
                viewer.m_213846_((Component)Component.m_237113_((String)""));
            }
        }
        String title = String.format("\u00a77-----\u00a73\u73a9\u5bb6\u64cd\u4f5c\u8bb0\u5f55\u00a77----- (%s | %s\u5185 | \u7b2c %d/%d \u9875)", playerUuid != null ? playerName + " \u00a78(" + playerUuid + "\u00a78)" : playerName, timeStr, page, totalPages);
        src.m_288197_(() -> Component.m_237113_((String)title), false);
        if (logs.isEmpty()) {
            src.m_288197_(() -> Component.m_237113_((String)"\u00a77\u65e0\u8bb0\u5f55\u3002"), false);
        } else {
            for (LogEntry log : logs) {
                src.m_288197_(() -> BlockInspectListener.renderLogLine(log), false);
            }
        }
        if (viewer != null) {
            MutableComponent pageLine = Component.m_237113_((String)String.format("\u7b2c %d/%d \u9875 ", page, totalPages)).m_130940_(ChatFormatting.GRAY);
            String cmdPrefix = "/ca check " + playerArg + " " + timeStr + " ";
            if (page > 1) {
                int finalPage = page;
                pageLine.m_7220_((Component)Component.m_237113_((String)"\u25c0 ").m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, cmdPrefix + (finalPage - 1))).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"\u4e0a\u4e00\u9875"))).m_131140_(ChatFormatting.AQUA)));
            }
            pageLine.m_7220_((Component)Component.m_237113_((String)"("));
            for (int i = 1; i <= totalPages; ++i) {
                if (i == page) {
                    pageLine.m_7220_((Component)Component.m_237113_((String)("" + i)).m_130940_(ChatFormatting.YELLOW));
                } else {
                    int finalI = i;
                    pageLine.m_7220_((Component)Component.m_237113_((String)("" + finalI)).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, cmdPrefix + finalI)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)("\u8df3\u8f6c\u5230\u7b2c " + finalI + " \u9875")))).m_131140_(ChatFormatting.AQUA)));
                }
                if (i >= totalPages) continue;
                pageLine.m_7220_((Component)Component.m_237113_((String)"|").m_130940_(ChatFormatting.GRAY));
            }
            pageLine.m_7220_((Component)Component.m_237113_((String)") "));
            if (page < totalPages) {
                int finalPage1 = page;
                pageLine.m_7220_((Component)Component.m_237113_((String)"\u25b6").m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, cmdPrefix + (finalPage1 + 1))).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"\u4e0b\u4e00\u9875"))).m_131140_(ChatFormatting.AQUA)));
            }
            viewer.m_213846_((Component)pageLine);
        }
        src.m_288197_(() -> Component.m_237113_((String)"\u00a77-----"), false);
        return 1;
    }

    private static boolean looksLikeUuid(String s) {
        return s != null && s.matches("^[0-9a-fA-F\\-]{32,36}$");
    }

    private static int checkUUID(CommandSourceStack src, String playerName) {
        ServerPlayer online = src.m_81377_().m_6846_().m_11255_(playerName);
        String uuid = null;
        if (online != null) {
            uuid = online.m_20148_().toString();
        } else {
            String string = uuid = Database.isConnected() ? Database.get().findLastUuidByPlayerName(playerName) : null;
        }
        if (uuid != null && !uuid.isBlank()) {
            String finalUuid = uuid;
            MutableComponent msg = Component.m_237113_((String)("\u00a73[CraftAudit] \u73a9\u5bb6 \u00a7e" + playerName + "\u00a73 \u7684 UUID: ")).m_7220_((Component)Component.m_237113_((String)uuid).m_130938_(style -> style.m_131140_(ChatFormatting.AQUA).m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, finalUuid)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"\u70b9\u51fb\u590d\u5236 UUID")))));
            src.m_288197_(() -> msg, false);
            return 1;
        }
        src.m_81352_((Component)Component.m_237113_((String)"\u00a7c\u672a\u627e\u5230\u8be5\u73a9\u5bb6\u7684 UUID\uff08\u4e0d\u5728\u7ebf\u4e14\u65e0\u5386\u53f2\u8bb0\u5f55\uff09\u3002"));
        return 0;
    }

    private static int report(CommandSourceStack src) {
        boolean connected = Database.isConnected();
        boolean ok = connected && Database.get().ping();
        String mode = Config.isSqlite() ? "SQLITE" : "MYSQL";
        src.m_288197_(() -> Component.m_237113_((String)("\u00a73[CraftAudit] \u6a21\u5f0f\uff1a" + mode + " | \u72b6\u6001\uff1a" + ok)), false);
        return ok ? 1 : 0;
    }

    private static int toggleAudit(CommandSourceStack src) {
        ServerPlayer player = src.m_230896_();
        if (player == null) {
            src.m_81352_((Component)Component.m_237113_((String)"\u00a7c[CraftAudit] \u53ea\u80fd\u7531\u73a9\u5bb6\u4f7f\u7528\u8be5\u547d\u4ee4\uff01"));
            return 0;
        }
        UUID uuid = player.m_20148_();
        if (AuditModeManager.isAuditing(uuid)) {
            AuditModeManager.exit(uuid);
            src.m_288197_(() -> Component.m_237113_((String)"\u00a73[CraftAudit] \u5df2\u9000\u51fa\u5ba1\u8ba1\u6a21\u5f0f\u3002"), false);
        } else {
            AuditModeManager.enter(uuid);
            src.m_288197_(() -> Component.m_237113_((String)"\u00a73[CraftAudit] \u5df2\u8fdb\u5165\u5ba1\u8ba1\u6a21\u5f0f\u3002"), false);
        }
        return 1;
    }

    private static int inspectAudit(CommandSourceStack src, int page) {
        ServerPlayer player = src.m_230896_();
        if (player == null) {
            src.m_81352_((Component)Component.m_237113_((String)"\u00a7c[CraftAudit] \u53ea\u80fd\u7531\u73a9\u5bb6\u4f7f\u7528\u8be5\u547d\u4ee4\uff01"));
            return 0;
        }
        UUID uuid = player.m_20148_();
        if (!AuditModeManager.isAuditing(uuid)) {
            AuditModeManager.enter(uuid);
            src.m_288197_(() -> Component.m_237113_((String)"\u00a73[CraftAudit] \u5df2\u8fdb\u5165\u5ba1\u8ba1\u6a21\u5f0f\u3002"), false);
        }
        BlockInspectListener.queryInteractLogPage(player, page);
        return 1;
    }

    private static int inspectBlockAudit(CommandSourceStack src, int page) {
        ServerPlayer player = src.m_230896_();
        if (player == null) {
            src.m_81352_((Component)Component.m_237113_((String)"\u00a7c[CraftAudit] \u53ea\u80fd\u7531\u73a9\u5bb6\u4f7f\u7528\u8be5\u547d\u4ee4\uff01"));
            return 0;
        }
        UUID uuid = player.m_20148_();
        if (!AuditModeManager.isAuditing(uuid)) {
            AuditModeManager.enter(uuid);
            src.m_288197_(() -> Component.m_237113_((String)"\u00a73[CraftAudit] \u5df2\u8fdb\u5165\u5ba1\u8ba1\u6a21\u5f0f\u3002"), false);
        }
        BlockInspectListener.queryBlockLogPage(player, page);
        return 1;
    }

    private static int near(CommandSourceStack src, int radius, String timeStr, int page) {
        ServerPlayer player = src.m_230896_();
        if (player == null) {
            src.m_81352_((Component)Component.m_237113_((String)"\u00a7c[CraftAudit] \u53ea\u80fd\u7531\u73a9\u5bb6\u4f7f\u7528\u8be5\u547d\u4ee4\uff01"));
            return 0;
        }
        long durMs = CraftauditCommands.parseDurationMillis(timeStr);
        if (durMs <= 0L) {
            src.m_81352_((Component)Component.m_237113_((String)"\u00a7c\u65f6\u95f4\u683c\u5f0f\u65e0\u6548\uff01\u793a\u4f8b\uff1a5d\u300112h\u300130m\u300145s"));
            return 0;
        }
        long sinceMs = System.currentTimeMillis() - durMs;
        BlockInspectListener.showNearbyLogsPaged(player, radius, sinceMs, page, timeStr);
        return 1;
    }

    private static int rollback(CommandSourceStack src, String playerName, String timeStr, int radius) {
        ServerPlayer executor = src.m_230896_();
        if (executor == null) {
            src.m_81352_((Component)Component.m_237113_((String)"\u00a7c[CraftAudit] \u53ea\u80fd\u7531\u73a9\u5bb6\u4f7f\u7528\u8be5\u547d\u4ee4\uff01"));
            return 0;
        }
        long durMs = CraftauditCommands.parseDurationMillis(timeStr);
        if (durMs <= 0L) {
            src.m_81352_((Component)Component.m_237113_((String)"\u00a7c\u65f6\u95f4\u683c\u5f0f\u65e0\u6548\uff01\u793a\u4f8b\uff1a5d\u300112h\u300130m\u300145s"));
            return 0;
        }
        long sinceMs = System.currentTimeMillis() - durMs;
        ServerLevel level = executor.m_284548_();
        String dim = level.m_46472_().m_135782_().toString();
        BlockPos center = executor.m_20183_();
        int changed = RollbackService.rollback(level, dim, center, radius, sinceMs, playerName, executor.m_20148_());
        src.m_288197_(() -> Component.m_237113_((String)String.format("\u00a73[CraftAudit] \u56de\u6eda\u5b8c\u6210\uff1a%d \u4e2a\u65b9\u5757\u3002\u8f93\u5165 /ca undo \u64a4\u9500\u672c\u6b21\u56de\u6eda\u3002", changed)), true);
        return changed > 0 ? 1 : 0;
    }

    private static int restore(CommandSourceStack src, String timeStr, int radius, String typeOpt) {
        String t;
        ServerPlayer executor = src.m_230896_();
        if (executor == null) {
            src.m_81352_((Component)Component.m_237113_((String)"\u00a7c[CraftAudit] \u53ea\u80fd\u7531\u73a9\u5bb6\u4f7f\u7528\u8be5\u547d\u4ee4\uff01"));
            return 0;
        }
        long durMs = CraftauditCommands.parseDurationMillis(timeStr);
        if (durMs <= 0L) {
            src.m_81352_((Component)Component.m_237113_((String)"\u00a7c\u65f6\u95f4\u683c\u5f0f\u65e0\u6548\uff01\u793a\u4f8b\uff1a5d\u300112h\u300130m\u300145s"));
            return 0;
        }
        long sinceMs = System.currentTimeMillis() - durMs;
        ServerLevel level = executor.m_284548_();
        String dim = level.m_46472_().m_135782_().toString();
        BlockPos center = executor.m_20183_();
        if (typeOpt == null) {
            int changed = RollbackService.restoreBreaks(level, dim, center, radius, sinceMs, List.of("break", "natural_break"), null, executor.m_20148_());
            src.m_288197_(() -> Component.m_237113_((String)String.format("\u00a73[CraftAudit] \u6062\u590d\u5b8c\u6210\uff08\u6240\u6709\u7834\u574f\uff09\uff1a%d \u4e2a\u65b9\u5757\u3002/ca undo \u53ef\u64a4\u9500\u3002", changed)), true);
            return changed > 0 ? 1 : 0;
        }
        switch (t = typeOpt.toLowerCase()) {
            case "break": {
                int changed = RollbackService.restoreBreaks(level, dim, center, radius, sinceMs, List.of("break"), null, executor.m_20148_());
                src.m_288197_(() -> Component.m_237113_((String)String.format("\u00a73[CraftAudit] \u6062\u590d\u5b8c\u6210\uff08\u73a9\u5bb6\u7834\u574f\uff09\uff1a%d \u4e2a\u65b9\u5757\u3002/ca undo \u53ef\u64a4\u9500\u3002", changed)), true);
                return changed > 0 ? 1 : 0;
            }
            case "natural": 
            case "natural_break": {
                int changed = RollbackService.restoreBreaks(level, dim, center, radius, sinceMs, List.of("natural_break"), null, executor.m_20148_());
                src.m_288197_(() -> Component.m_237113_((String)String.format("\u00a73[CraftAudit] \u6062\u590d\u5b8c\u6210\uff08\u73af\u5883\u7834\u574f\uff09\uff1a%d \u4e2a\u65b9\u5757\u3002/ca undo \u53ef\u64a4\u9500\u3002", changed)), true);
                return changed > 0 ? 1 : 0;
            }
            case "explosion": 
            case "fluid": 
            case "gravity": {
                int changed = RollbackService.restoreBreaks(level, dim, center, radius, sinceMs, List.of("natural_break"), t, executor.m_20148_());
                src.m_288197_(() -> Component.m_237113_((String)String.format("\u00a73[CraftAudit] \u6062\u590d\u5b8c\u6210\uff08\u73af\u5883\u7834\u574f: %s\uff09\uff1a%d \u4e2a\u65b9\u5757\u3002/ca undo \u53ef\u64a4\u9500\u3002", t, changed)), true);
                return changed > 0 ? 1 : 0;
            }
        }
        if (t.equals("kill") || t.startsWith("kill:")) {
            String entityFilter = null;
            if (t.startsWith("kill:") && (entityFilter = t.substring("kill:".length())).isBlank()) {
                entityFilter = null;
            }
            int spawned = RollbackService.restoreKills(level, dim, center, radius, sinceMs, entityFilter, executor.m_20148_());
            Object scope = entityFilter == null ? "\u6240\u6709\u51fb\u6740" : "\u51fb\u6740: " + entityFilter;
            src.m_288197_(() -> CraftauditCommands.lambda$restore$87((String)scope, spawned), true);
            return spawned > 0 ? 1 : 0;
        }
        src.m_81352_((Component)Component.m_237113_((String)"\u00a7c\u672a\u77e5\u7684 type\uff01\u53ef\u9009\uff1abreak | natural | explosion | fluid | gravity | kill | kill:<entity_id>"));
        return 0;
    }

    private static int purge(CommandSourceStack src, String timeStr) {
        long durMs = CraftauditCommands.parseDurationMillis(timeStr);
        if (durMs <= 0L) {
            src.m_81352_((Component)Component.m_237113_((String)"\u00a7c\u65f6\u95f4\u683c\u5f0f\u65e0\u6548\uff01\u793a\u4f8b\uff1a30d\u300112h\u300190m\u3001300s"));
            return 0;
        }
        long beforeMs = System.currentTimeMillis() - durMs;
        if (!Database.isConnected()) {
            src.m_81352_((Component)Component.m_237113_((String)"\u00a7c\u6570\u636e\u5e93\u672a\u8fde\u63a5\uff0c\u65e0\u6cd5\u6e05\u7406\u3002"));
            return 0;
        }
        int deleted = Database.get().deleteLogsBefore(beforeMs);
        if (deleted < 0) {
            src.m_81352_((Component)Component.m_237113_((String)"\u00a7c\u6e05\u7406\u65e5\u5fd7\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u63a7\u5236\u53f0\u3002"));
            return 0;
        }
        src.m_288197_(() -> Component.m_237113_((String)("\u00a73[CraftAudit] \u5df2\u6e05\u7406 " + deleted + " \u6761\u65e9\u4e8e " + timeStr + " \u7684\u65e5\u5fd7\u8bb0\u5f55\u3002")), true);
        return 1;
    }

    private static int undo(CommandSourceStack src) {
        ServerPlayer executor = src.m_230896_();
        if (executor == null) {
            src.m_81352_((Component)Component.m_237113_((String)"\u00a7c[CraftAudit] \u53ea\u80fd\u7531\u73a9\u5bb6\u4f7f\u7528\u8be5\u547d\u4ee4\uff01"));
            return 0;
        }
        if (!UndoManager.hasUndo(executor.m_20148_())) {
            src.m_81352_((Component)Component.m_237113_((String)"\u00a7c\u6ca1\u6709\u53ef\u64a4\u9500\u7684\u56de\u6eda/\u6062\u590d\u8bb0\u5f55\u3002"));
            return 0;
        }
        int changed = UndoManager.applyUndo(executor);
        src.m_288197_(() -> Component.m_237113_((String)String.format("\u00a73[CraftAudit] \u64a4\u9500\u5b8c\u6210\uff1a%d \u9879\u66f4\u6539\u5df2\u6062\u590d\u3002", changed)), true);
        return changed > 0 ? 1 : 0;
    }

    private static long parseDurationMillis(String s) {
        if (s == null) {
            return -1L;
        }
        Matcher m = DURATION_PATTERN.matcher(s.trim());
        if (!m.matches()) {
            return -1L;
        }
        long val = Long.parseLong(m.group(1));
        char unit = Character.toLowerCase(m.group(2).charAt(0));
        return switch (unit) {
            case 's' -> val * 1000L;
            case 'm' -> val * 60000L;
            case 'h' -> val * 3600000L;
            case 'd' -> val * 86400000L;
            default -> -1L;
        };
    }

    private static /* synthetic */ Component lambda$restore$87(String scope, int spawned) {
        return Component.m_237113_((String)String.format("\u00a73[CraftAudit] \u6062\u590d\u5b8c\u6210\uff08%s\uff09\uff1a\u751f\u6210 %d \u4e2a\u5b9e\u4f53\u3002/ca undo \u53ef\u64a4\u9500\u3002", scope, spawned));
    }
}

