/*
 * Decompiled with CFR 0.152.
 */
package cn.alini.craftaudit.event.entity;

import cn.alini.craftaudit.AuditModeManager;
import cn.alini.craftaudit.storage.Database;
import cn.alini.craftaudit.storage.LogEntry;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="craftaudit")
public class EntityDeathListener {
    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        ItemStack main;
        Object target;
        String actorName;
        LivingEntity victim = event.getEntity();
        if (victim.m_9236_().m_5776_()) {
            return;
        }
        DamageSource source = event.getSource();
        Entity trueSrc = source.m_7639_();
        if (!(trueSrc instanceof ServerPlayer) && trueSrc == null) {
            return;
        }
        Entity directSrc = source.m_7640_();
        String dim = victim.m_9236_().m_46472_().m_135782_().toString();
        BlockPos pos = victim.m_20183_();
        String actorUuid = null;
        ServerPlayer killerPlayer = null;
        if (trueSrc instanceof ServerPlayer) {
            ServerPlayer sp;
            killerPlayer = sp = (ServerPlayer)trueSrc;
            if (AuditModeManager.isAuditing(sp.m_20148_())) {
                return;
            }
            actorName = sp.m_7755_().getString();
            actorUuid = sp.m_20148_().toString();
        } else {
            actorName = trueSrc != null ? ForgeRegistries.ENTITY_TYPES.getKey((Object)trueSrc.m_6095_()).toString() : "(\u73af\u5883)";
        }
        if (victim instanceof ServerPlayer) {
            ServerPlayer vp = (ServerPlayer)victim;
            target = "player:" + vp.m_7755_().getString();
        } else {
            target = ForgeRegistries.ENTITY_TYPES.getKey((Object)victim.m_6095_()).toString();
        }
        String causeId = EntityDeathListener.getCauseId(source);
        String projectileId = directSrc != null && directSrc != trueSrc ? ForgeRegistries.ENTITY_TYPES.getKey((Object)directSrc.m_6095_()).toString() : null;
        String weaponId = null;
        if (killerPlayer != null && !(main = killerPlayer.m_21205_()).m_41619_() && ForgeRegistries.ITEMS.getKey((Object)main.m_41720_()) != null) {
            weaponId = ForgeRegistries.ITEMS.getKey((Object)main.m_41720_()).toString();
        }
        Double distance = killerPlayer != null ? Double.valueOf((double)Math.round((double)killerPlayer.m_20270_((Entity)victim) * 10.0) / 10.0) : null;
        String dataJson = EntityDeathListener.buildKillDataJson(causeId, projectileId, weaponId, distance);
        Database.get().insertAsync(new LogEntry(System.currentTimeMillis(), dim, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), actorName, actorUuid, "kill", (String)target, dataJson));
    }

    private static String getCauseId(DamageSource src) {
        try {
            return src.m_19385_();
        }
        catch (Throwable ignore) {
            return "unknown";
        }
    }

    private static String buildKillDataJson(String cause, String projectile, String weapon, Double distance) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        boolean first = true;
        if (cause != null) {
            sb.append("\"cause\":\"").append(EntityDeathListener.escape(cause)).append("\"");
            first = false;
        }
        if (projectile != null) {
            if (!first) {
                sb.append(",");
            }
            sb.append("\"projectile\":\"").append(EntityDeathListener.escape(projectile)).append("\"");
            first = false;
        }
        if (weapon != null) {
            if (!first) {
                sb.append(",");
            }
            sb.append("\"weapon\":\"").append(EntityDeathListener.escape(weapon)).append("\"");
            first = false;
        }
        if (distance != null) {
            if (!first) {
                sb.append(",");
            }
            sb.append("\"distance\":").append(distance);
        }
        sb.append("}");
        return sb.toString();
    }

    private static String escape(String s) {
        return s.replace("\\", "\\\\").replace("\"", "\\\"");
    }
}

