/*
 * Decompiled with CFR 0.152.
 */
package cn.alini.craftaudit.event.block;

import cn.alini.craftaudit.AuditModeManager;
import cn.alini.craftaudit.storage.Database;
import cn.alini.craftaudit.storage.LogEntry;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="craftaudit")
public class BlockLogListener {
    @SubscribeEvent
    public static void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        if (AuditModeManager.isAuditing(player.m_20148_())) {
            return;
        }
        BlockState placed = event.getPlacedBlock();
        BlockPos pos = event.getPos();
        String targetId = ForgeRegistries.BLOCKS.getKey((Object)placed.m_60734_()).toString();
        Database.get().insertAsync(new LogEntry(System.currentTimeMillis(), player.m_9236_().m_46472_().m_135782_().toString(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), player.m_7755_().getString(), player.m_20148_().toString(), "place", targetId, ""));
    }

    @SubscribeEvent
    public static void onSignEdit(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        if (player == null || player.m_9236_().m_5776_()) {
            return;
        }
        if (AuditModeManager.isAuditing(player.m_20148_())) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockEntity be = player.m_9236_().m_7702_(pos);
        if (be instanceof SignBlockEntity) {
            SignBlockEntity sign = (SignBlockEntity)be;
            List<Component> frontLines = List.of(sign.m_277142_().m_276945_(sign.m_277118_()));
            List<Component> backLines = List.of(sign.m_277159_().m_276945_(sign.m_277118_()));
            String front = frontLines.stream().map(Component::getString).collect(Collectors.joining(" | "));
            String back = backLines.stream().map(Component::getString).collect(Collectors.joining(" | "));
            String data = "Front: " + front + "; Back: " + back;
            Database.get().insertAsync(new LogEntry(System.currentTimeMillis(), player.m_9236_().m_46472_().m_135782_().toString(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), player.m_7755_().getString(), player.m_20148_().toString(), "sign_edit", ForgeRegistries.BLOCKS.getKey((Object)player.m_9236_().m_8055_(pos).m_60734_()).toString(), data));
        }
    }

    @SubscribeEvent
    public static void onUseFlintAndSteel(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        if (player == null || player.m_9236_().m_5776_()) {
            return;
        }
        if (AuditModeManager.isAuditing(player.m_20148_())) {
            return;
        }
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        ItemStack held = event.getItemStack();
        if (held.m_41619_() || !(held.m_41720_() instanceof FlintAndSteelItem)) {
            return;
        }
        Level level = player.m_9236_();
        BlockPos pos = event.getPos();
        Block block = level.m_8055_(pos).m_60734_();
        String action = "ignite";
        String targetId = null;
        if (block instanceof CampfireBlock) {
            targetId = ForgeRegistries.BLOCKS.getKey((Object)block).toString();
        } else if (block instanceof CandleBlock || block instanceof CandleCakeBlock) {
            targetId = ForgeRegistries.BLOCKS.getKey((Object)block).toString();
        } else if (block instanceof TntBlock) {
            targetId = ForgeRegistries.BLOCKS.getKey((Object)block).toString();
        }
        if (targetId != null) {
            Database.get().insertAsync(new LogEntry(System.currentTimeMillis(), level.m_46472_().m_135782_().toString(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), player.m_7755_().getString(), player.m_20148_().toString(), action, targetId, ""));
        }
    }

    @SubscribeEvent
    public static void onFirePlaced(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        if (AuditModeManager.isAuditing(player.m_20148_())) {
            return;
        }
        BlockState placed = event.getPlacedBlock();
        Block block = placed.m_60734_();
        if (!(block instanceof BaseFireBlock)) {
            return;
        }
        BlockPos pos = event.getPos();
        Database.get().insertAsync(new LogEntry(System.currentTimeMillis(), player.m_9236_().m_46472_().m_135782_().toString(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), player.m_7755_().getString(), player.m_20148_().toString(), "ignite", ForgeRegistries.BLOCKS.getKey((Object)block).toString(), ""));
    }

    @SubscribeEvent
    public static void onSpecialBlockUse(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        if (player == null || player.m_9236_().m_5776_()) {
            return;
        }
        if (AuditModeManager.isAuditing(player.m_20148_())) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState state = player.m_9236_().m_8055_(pos);
        Block block = state.m_60734_();
        String action = null;
        if (block.m_7705_().contains("button")) {
            action = "button_press";
        } else if (block.m_7705_().contains("lever")) {
            action = "lever_pull";
        } else if (block.m_7705_().contains("door")) {
            action = "door_use";
        }
        if (action != null) {
            Database.get().insertAsync(new LogEntry(System.currentTimeMillis(), player.m_9236_().m_46472_().m_135782_().toString(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), player.m_7755_().getString(), player.m_20148_().toString(), action, ForgeRegistries.BLOCKS.getKey((Object)block).toString(), ""));
        }
    }
}

