/*
 * Decompiled with CFR 0.152.
 */
package cn.alini.craftaudit.event.container;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public final class ContainerSessionTracker {
    private static final long PENDING_TIMEOUT_MS = 2000L;
    private static final Map<UUID, Pending> pendingByPlayer = new ConcurrentHashMap<UUID, Pending>();
    private static final Map<AbstractContainerMenu, Session> sessionsByMenu = Collections.synchronizedMap(new WeakHashMap());

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (player2.m_9236_().m_5776_()) {
            return;
        }
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        BlockPos pos = event.getPos();
        String dim = player2.m_9236_().m_46472_().m_135782_().toString();
        pendingByPlayer.put(player2.m_20148_(), new Pending(pos, dim, System.currentTimeMillis()));
    }

    @SubscribeEvent
    public static void onContainerOpen(PlayerContainerEvent.Open event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (player2.m_9236_().m_5776_()) {
            return;
        }
        AbstractContainerMenu menu = event.getContainer();
        UUID uuid = player2.m_20148_();
        Pending pend = pendingByPlayer.remove(uuid);
        long now = System.currentTimeMillis();
        if (pend == null || now - pend.atMs > 2000L) {
            return;
        }
        BlockPos pos = pend.pos;
        String dim = pend.dimension;
        List<ItemStack> openSnapshot = ContainerSessionTracker.snapshotContainerSlots(menu);
        Session session = new Session(uuid, pos, dim, openSnapshot, menu.getClass().getName());
        sessionsByMenu.put(menu, session);
    }

    public static Session takeSession(AbstractContainerMenu menu) {
        return sessionsByMenu.remove(menu);
    }

    public static List<ItemStack> snapshotContainerSlots(AbstractContainerMenu menu) {
        String menuName = menu.getClass().getName();
        if (menuName.equals("top.theillusivec4.curios.common.inventory.container.CuriosContainerV2")) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (Slot slot : menu.f_38839_) {
            ItemStack stack;
            String name;
            if (slot.f_40218_ instanceof Inventory || (name = slot.f_40218_.getClass().getName().toLowerCase()).contains("curio") || name.contains("trinket") || name.contains("bauble") || name.contains("enderchest") || name.contains("lightmanscurrency") || (stack = slot.m_7993_()).m_41619_()) continue;
            items.add(stack.m_41777_());
        }
        return items;
    }

    public static Map<String, Integer> compare(List<ItemStack> before, List<ItemStack> after) {
        String name;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (before != null) {
            for (ItemStack stack : before) {
                name = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString();
                map.put(name, map.getOrDefault(name, 0) - stack.m_41613_());
            }
        }
        if (after != null) {
            for (ItemStack stack : after) {
                name = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString();
                map.put(name, map.getOrDefault(name, 0) + stack.m_41613_());
            }
        }
        map.entrySet().removeIf(e -> (Integer)e.getValue() == 0);
        return map;
    }

    private record Pending(BlockPos pos, String dimension, long atMs) {
    }

    public static final class Session {
        public final UUID playerId;
        public final BlockPos pos;
        public final String dimension;
        public final List<ItemStack> openSnapshot;
        public final String menuClassName;

        Session(UUID playerId, BlockPos pos, String dimension, List<ItemStack> openSnapshot, String menuClassName) {
            this.playerId = playerId;
            this.pos = pos;
            this.dimension = dimension;
            this.openSnapshot = openSnapshot != null ? openSnapshot : Collections.emptyList();
            this.menuClassName = menuClassName;
        }
    }
}

