/*
 * Decompiled with CFR 0.152.
 */
package cn.alini.craftaudit.mixin;

import cn.alini.craftaudit.AuditModeManager;
import cn.alini.craftaudit.mixin.ServerPlayerGameModeAccessor;
import cn.alini.craftaudit.storage.Database;
import cn.alini.craftaudit.storage.LogEntry;
import cn.alini.craftaudit.util.NbtCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayerGameMode.class})
public class ServerPlayerGameModeMixin {
    @Inject(method={"destroyBlock"}, at={@At(value="HEAD")})
    private void craftaudit$onBlockBreak(BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        ServerPlayer player = ((ServerPlayerGameModeAccessor)((Object)this)).craftaudit$getPlayer();
        if (AuditModeManager.isAuditing(player.m_20148_())) {
            return;
        }
        Level world = player.m_9236_();
        BlockState state = world.m_8055_(pos);
        Database db = Database.get();
        if (db != null) {
            String blockId = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_()).toString();
            String stateStr = NbtCodec.stateToString(state);
            String nbtB64 = NbtCodec.tryDumpBeNbtBase64(world, pos);
            String dataJson = NbtCodec.buildDataJson(stateStr, nbtB64);
            db.insertAsync(new LogEntry(System.currentTimeMillis(), world.m_46472_().m_135782_().toString(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), player.m_7755_().getString(), player.m_20148_().toString(), "break", blockId, dataJson));
        }
    }
}

