/*
 * Decompiled with CFR 0.152.
 */
package cn.alini.craftaudit.rollback;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.slf4j.Logger;

public final class UndoManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<UUID, UndoBundle> LAST_BUNDLE = new ConcurrentHashMap<UUID, UndoBundle>();

    private UndoManager() {
    }

    public static void saveLast(UUID playerId, UndoBundle bundle) {
        LAST_BUNDLE.put(playerId, bundle);
    }

    public static boolean hasUndo(UUID playerId) {
        return LAST_BUNDLE.containsKey(playerId);
    }

    public static int applyUndo(ServerPlayer executor) {
        UndoBundle bundle = LAST_BUNDLE.remove(executor.m_20148_());
        if (bundle == null) {
            return 0;
        }
        ServerLevel level = UndoManager.resolveLevel(executor.m_20194_(), bundle.dimensionId);
        if (level == null) {
            LOGGER.warn("[craftaudit] \u672a\u627e\u5230\u7ef4\u5ea6: {}", (Object)bundle.dimensionId);
            return 0;
        }
        int changed = 0;
        for (UndoEntry e : bundle.entries) {
            try {
                BlockEntity be;
                boolean ok = level.m_46597_(e.pos, e.beforeState);
                if (e.beforeBeNbt != null && (be = level.m_7702_(e.pos)) != null) {
                    e.beforeBeNbt.m_128405_("x", e.pos.m_123341_());
                    e.beforeBeNbt.m_128405_("y", e.pos.m_123342_());
                    e.beforeBeNbt.m_128405_("z", e.pos.m_123343_());
                    be.m_142466_(e.beforeBeNbt);
                    be.m_6596_();
                    ok = true;
                }
                if (!ok) continue;
                ++changed;
            }
            catch (Exception ex) {
                LOGGER.warn("[craftaudit] \u64a4\u9500\u5931\u8d25 @ {}: {}", (Object)e.pos, (Object)ex.toString());
            }
        }
        for (UUID id : bundle.spawnedEntities) {
            try {
                Entity ent = level.m_8791_(id);
                if (ent == null) continue;
                ent.m_146870_();
                ++changed;
            }
            catch (Exception ex) {
                LOGGER.warn("[craftaudit] \u64a4\u9500\u79fb\u9664\u5b9e\u4f53\u5931\u8d25 {}: {}", (Object)id, (Object)ex.toString());
            }
        }
        return changed;
    }

    private static ServerLevel resolveLevel(MinecraftServer server, String dimensionId) {
        try {
            for (ServerLevel lvl : server.m_129785_()) {
                String id = lvl.m_46472_().m_135782_().toString();
                if (!dimensionId.equals(id)) continue;
                return lvl;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static final class UndoBundle {
        public final String dimensionId;
        public final List<UndoEntry> entries = new ArrayList<UndoEntry>();
        public final List<UUID> spawnedEntities = new ArrayList<UUID>();

        public UndoBundle(String dimensionId) {
            this.dimensionId = dimensionId;
        }
    }

    public static final class UndoEntry {
        public final BlockPos pos;
        public final BlockState beforeState;
        public final CompoundTag beforeBeNbt;

        public UndoEntry(BlockPos pos, BlockState beforeState, CompoundTag beforeBeNbt) {
            this.pos = pos;
            this.beforeState = beforeState;
            this.beforeBeNbt = beforeBeNbt;
        }
    }
}

