/*
 * Decompiled with CFR 0.152.
 */
package cn.alini.craftaudit.storage;

import cn.alini.craftaudit.config.Config;
import cn.alini.craftaudit.storage.LogEntry;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;

public final class Database {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static Database INSTANCE;
    private final Connection conn;
    private final Dialect dialect;
    private final ExecutorService writer = Executors.newSingleThreadExecutor(r -> {
        Thread t = new Thread(r, "craftaudit-sql-writer");
        t.setDaemon(true);
        return t;
    });

    private Database(Connection conn, Dialect dialect) throws SQLException {
        this.conn = conn;
        this.dialect = dialect;
        this.ensureSchema();
    }

    public static synchronized void init(Path sqliteDefaultPath) throws SQLException {
        if (INSTANCE != null) {
            return;
        }
        if (Config.isSqlite()) {
            Path dbPath = Config.sqliteDbPath() != null ? Config.sqliteDbPath() : sqliteDefaultPath;
            try {
                Files.createDirectories(dbPath.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.error("\u521b\u5efa\u6570\u636e\u5e93\u76ee\u5f55\u5931\u8d25", (Throwable)e);
            }
            String url = "jdbc:sqlite:" + dbPath;
            LOGGER.info("[craftaudit] \u4f7f\u7528 SQLite: {}", (Object)dbPath);
            Connection c = DriverManager.getConnection(url);
            INSTANCE = new Database(c, Dialect.SQLITE);
        } else {
            String url = Config.mysqlJdbcUrl();
            String user = Config.mysqlUser();
            String pass = Config.mysqlPassword();
            LOGGER.info("[craftaudit] \u4f7f\u7528 MySQL: {}", (Object)url);
            Connection c = DriverManager.getConnection(url, user, pass);
            INSTANCE = new Database(c, Dialect.MYSQL);
        }
    }

    public static Database get() {
        return INSTANCE;
    }

    public static boolean isConnected() {
        return INSTANCE != null;
    }

    public boolean ping() {
        boolean bl;
        block8: {
            Statement st = this.conn.createStatement();
            try {
                st.execute("SELECT 1");
                bl = true;
                if (st == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    LOGGER.warn("[craftaudit] \u6570\u636e\u5e93 ping \u5931\u8d25", (Throwable)e);
                    return false;
                }
            }
            st.close();
        }
        return bl;
    }

    private void ensureSchema() throws SQLException {
        try (Statement st = this.conn.createStatement();){
            if (this.dialect == Dialect.SQLITE) {
                st.execute("    CREATE TABLE IF NOT EXISTS logs(\n      id INTEGER PRIMARY KEY AUTOINCREMENT,\n      time_ms INTEGER NOT NULL,\n      dimension TEXT NOT NULL,\n      x INTEGER NOT NULL, y INTEGER NOT NULL, z INTEGER NOT NULL,\n      player TEXT,\n      uuid TEXT,\n      action TEXT NOT NULL,\n      target TEXT,\n      data TEXT\n    )\n");
                st.execute("CREATE INDEX IF NOT EXISTS idx_logs_pos ON logs(dimension, x, y, z)");
                st.execute("CREATE INDEX IF NOT EXISTS idx_logs_time ON logs(time_ms)");
                Database.tryExec(st, "ALTER TABLE logs ADD COLUMN uuid TEXT");
            } else {
                st.execute("    CREATE TABLE IF NOT EXISTS logs(\n      id BIGINT NOT NULL AUTO_INCREMENT PRIMARY KEY,\n      time_ms BIGINT NOT NULL,\n      dimension VARCHAR(128) NOT NULL,\n      x INT NOT NULL, y INT NOT NULL, z INT NOT NULL,\n      player VARCHAR(64),\n      uuid VARCHAR(36),\n      action VARCHAR(32) NOT NULL,\n      target VARCHAR(191),\n      data TEXT\n    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4\n");
                Database.tryExec(st, "CREATE INDEX idx_logs_pos ON logs(dimension, x, y, z)");
                Database.tryExec(st, "CREATE INDEX idx_logs_time ON logs(time_ms)");
                Database.tryExec(st, "ALTER TABLE logs ADD COLUMN uuid VARCHAR(36) NULL");
            }
        }
    }

    private static void tryExec(Statement st, String sql) {
        try {
            st.execute(sql);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void insertAsync(LogEntry e) {
        this.writer.execute(() -> {
            try (PreparedStatement ps = this.conn.prepareStatement("INSERT INTO logs(time_ms, dimension, x, y, z, player, uuid, action, target, data) VALUES (?,?,?,?,?,?,?,?,?,?)");){
                ps.setLong(1, e.timeMillis());
                ps.setString(2, e.dimension());
                ps.setInt(3, e.x());
                ps.setInt(4, e.y());
                ps.setInt(5, e.z());
                ps.setString(6, e.player());
                ps.setString(7, e.playerUuid());
                ps.setString(8, e.action());
                ps.setString(9, e.target());
                ps.setString(10, e.data());
                ps.executeUpdate();
            }
            catch (SQLException ex) {
                LOGGER.error("\u5199\u5165\u65e5\u5fd7\u5931\u8d25", (Throwable)ex);
            }
        });
    }

    public List<LogEntry> queryLogsAtPaged(String dimension, int x, int y, int z, String actionPattern, int page, int pageSize) {
        ArrayList<LogEntry> result = new ArrayList<LogEntry>();
        int offset = (page - 1) * pageSize;
        String[] actions = actionPattern.split("\\|");
        StringBuilder actionsPlaceholder = new StringBuilder();
        for (int i = 0; i < actions.length; ++i) {
            if (i > 0) {
                actionsPlaceholder.append(",");
            }
            actionsPlaceholder.append("?");
        }
        String sql = "SELECT time_ms, dimension, x, y, z, player, uuid, action, target, data FROM logs WHERE dimension=? AND x=? AND y=? AND z=? AND action IN (" + actionsPlaceholder + ") ORDER BY time_ms DESC LIMIT ? OFFSET ?";
        try (PreparedStatement ps = this.conn.prepareStatement(sql);){
            ps.setString(1, dimension);
            ps.setInt(2, x);
            ps.setInt(3, y);
            ps.setInt(4, z);
            for (int i = 0; i < actions.length; ++i) {
                ps.setString(5 + i, actions[i]);
            }
            ps.setInt(5 + actions.length, pageSize);
            ps.setInt(6 + actions.length, offset);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(new LogEntry(rs.getLong("time_ms"), rs.getString("dimension"), rs.getInt("x"), rs.getInt("y"), rs.getInt("z"), rs.getString("player"), rs.getString("uuid"), rs.getString("action"), rs.getString("target"), rs.getString("data")));
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("\u67e5\u8be2\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int countLogsAt(String dimension, int x, int y, int z, String actionPattern) {
        String[] actions = actionPattern.split("\\|");
        StringBuilder actionsPlaceholder = new StringBuilder();
        for (int i = 0; i < actions.length; ++i) {
            if (i > 0) {
                actionsPlaceholder.append(",");
            }
            actionsPlaceholder.append("?");
        }
        String sql = "SELECT COUNT(*) FROM logs WHERE dimension=? AND x=? AND y=? AND z=? AND action IN (" + actionsPlaceholder + ")";
        try (PreparedStatement ps = this.conn.prepareStatement(sql);){
            ps.setString(1, dimension);
            ps.setInt(2, x);
            ps.setInt(3, y);
            ps.setInt(4, z);
            for (int i = 0; i < actions.length; ++i) {
                ps.setString(5 + i, actions[i]);
            }
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return 0;
                int n = rs.getInt(1);
                return n;
            }
        }
        catch (SQLException e) {
            LOGGER.error("\u7edf\u8ba1\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
        }
        return 0;
    }

    public List<LogEntry> queryLogsNearPaged(String dimension, int cx, int cy, int cz, int radius, long sinceMs, int page, int pageSize) {
        ArrayList<LogEntry> result = new ArrayList<LogEntry>();
        int offset = (page - 1) * pageSize;
        int minX = cx - radius;
        int maxX = cx + radius;
        int minY = cy - radius;
        int maxY = cy + radius;
        int minZ = cz - radius;
        int maxZ = cz + radius;
        String sql = "SELECT time_ms, dimension, x, y, z, player, uuid, action, target, data FROM logs WHERE dimension=? AND time_ms>=? AND x BETWEEN ? AND ? AND y BETWEEN ? AND ? AND z BETWEEN ? AND ? ORDER BY time_ms DESC LIMIT ? OFFSET ?";
        try (PreparedStatement ps = this.conn.prepareStatement(sql);){
            ps.setString(1, dimension);
            ps.setLong(2, sinceMs);
            ps.setInt(3, minX);
            ps.setInt(4, maxX);
            ps.setInt(5, minY);
            ps.setInt(6, maxY);
            ps.setInt(7, minZ);
            ps.setInt(8, maxZ);
            ps.setInt(9, pageSize);
            ps.setInt(10, offset);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(new LogEntry(rs.getLong("time_ms"), rs.getString("dimension"), rs.getInt("x"), rs.getInt("y"), rs.getInt("z"), rs.getString("player"), rs.getString("uuid"), rs.getString("action"), rs.getString("target"), rs.getString("data")));
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("\u534a\u5f84\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int countLogsNear(String dimension, int cx, int cy, int cz, int radius, long sinceMs) {
        int minX = cx - radius;
        int maxX = cx + radius;
        int minY = cy - radius;
        int maxY = cy + radius;
        int minZ = cz - radius;
        int maxZ = cz + radius;
        String sql = "SELECT COUNT(*) FROM logs WHERE dimension=? AND time_ms>=? AND x BETWEEN ? AND ? AND y BETWEEN ? AND ? AND z BETWEEN ? AND ?";
        try (PreparedStatement ps = this.conn.prepareStatement(sql);){
            ps.setString(1, dimension);
            ps.setLong(2, sinceMs);
            ps.setInt(3, minX);
            ps.setInt(4, maxX);
            ps.setInt(5, minY);
            ps.setInt(6, maxY);
            ps.setInt(7, minZ);
            ps.setInt(8, maxZ);
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return 0;
                int n = rs.getInt(1);
                return n;
            }
        }
        catch (SQLException e) {
            LOGGER.error("\u7edf\u8ba1\u534a\u5f84\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
        return 0;
    }

    public List<LogEntry> queryLogsRegionSince(String dimension, int minX, int maxX, int minY, int maxY, int minZ, int maxZ, long sinceMs, List<String> actions, String player) {
        ArrayList<LogEntry> result = new ArrayList<LogEntry>();
        if (actions == null || actions.isEmpty()) {
            return result;
        }
        StringBuilder in = new StringBuilder();
        for (int i = 0; i < actions.size(); ++i) {
            if (i > 0) {
                in.append(",");
            }
            in.append("?");
        }
        String sql = "SELECT time_ms, dimension, x, y, z, player, uuid, action, target, data FROM logs WHERE dimension=? AND time_ms>=? AND x BETWEEN ? AND ? AND y BETWEEN ? AND ? AND z BETWEEN ? AND ? AND action IN (" + in + ") ";
        if (player != null) {
            sql = sql + "AND player=? ";
        }
        sql = sql + "ORDER BY time_ms DESC";
        try (PreparedStatement ps = this.conn.prepareStatement(sql);){
            int idx = 1;
            ps.setString(idx++, dimension);
            ps.setLong(idx++, sinceMs);
            ps.setInt(idx++, minX);
            ps.setInt(idx++, maxX);
            ps.setInt(idx++, minY);
            ps.setInt(idx++, maxY);
            ps.setInt(idx++, minZ);
            ps.setInt(idx++, maxZ);
            for (String a : actions) {
                ps.setString(idx++, a);
            }
            if (player != null) {
                ps.setString(idx++, player);
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(new LogEntry(rs.getLong("time_ms"), rs.getString("dimension"), rs.getInt("x"), rs.getInt("y"), rs.getInt("z"), rs.getString("player"), rs.getString("uuid"), rs.getString("action"), rs.getString("target"), rs.getString("data")));
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("\u533a\u57df\u65f6\u95f4\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
        return result;
    }

    public List<LogEntry> queryLogsByActorSince(String playerNameOrNull, String uuidOrNull, long sinceMs, int page, int pageSize) {
        ArrayList<LogEntry> result = new ArrayList<LogEntry>();
        if ((playerNameOrNull == null || playerNameOrNull.isBlank()) && (uuidOrNull == null || uuidOrNull.isBlank())) {
            return result;
        }
        int offset = (page - 1) * pageSize;
        StringBuilder sql = new StringBuilder("SELECT time_ms, dimension, x, y, z, player, uuid, action, target, data FROM logs WHERE time_ms>=?");
        if (playerNameOrNull != null && !playerNameOrNull.isBlank() && uuidOrNull != null && !uuidOrNull.isBlank()) {
            sql.append(" AND (player=? OR uuid=?)");
        } else if (playerNameOrNull != null && !playerNameOrNull.isBlank()) {
            sql.append(" AND player=?");
        } else {
            sql.append(" AND uuid=?");
        }
        sql.append(" ORDER BY time_ms DESC LIMIT ? OFFSET ?");
        try (PreparedStatement ps = this.conn.prepareStatement(sql.toString());){
            int idx = 1;
            ps.setLong(idx++, sinceMs);
            if (playerNameOrNull != null && !playerNameOrNull.isBlank() && uuidOrNull != null && !uuidOrNull.isBlank()) {
                ps.setString(idx++, playerNameOrNull);
                ps.setString(idx++, uuidOrNull);
            } else if (playerNameOrNull != null && !playerNameOrNull.isBlank()) {
                ps.setString(idx++, playerNameOrNull);
            } else {
                ps.setString(idx++, uuidOrNull);
            }
            ps.setInt(idx++, pageSize);
            ps.setInt(idx, offset);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(new LogEntry(rs.getLong("time_ms"), rs.getString("dimension"), rs.getInt("x"), rs.getInt("y"), rs.getInt("z"), rs.getString("player"), rs.getString("uuid"), rs.getString("action"), rs.getString("target"), rs.getString("data")));
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("\u6309\u73a9\u5bb6\u67e5\u8be2\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int countLogsByActorSince(String playerNameOrNull, String uuidOrNull, long sinceMs) {
        if (playerNameOrNull == null || playerNameOrNull.isBlank()) {
            if (uuidOrNull == null) return 0;
            if (uuidOrNull.isBlank()) {
                return 0;
            }
        }
        StringBuilder sql = new StringBuilder("SELECT COUNT(*) FROM logs WHERE time_ms>=?");
        if (playerNameOrNull != null && !playerNameOrNull.isBlank() && uuidOrNull != null && !uuidOrNull.isBlank()) {
            sql.append(" AND (player=? OR uuid=?)");
        } else if (playerNameOrNull != null && !playerNameOrNull.isBlank()) {
            sql.append(" AND player=?");
        } else {
            sql.append(" AND uuid=?");
        }
        try (PreparedStatement ps = this.conn.prepareStatement(sql.toString());){
            int idx = 1;
            ps.setLong(idx++, sinceMs);
            if (playerNameOrNull != null && !playerNameOrNull.isBlank() && uuidOrNull != null && !uuidOrNull.isBlank()) {
                ps.setString(idx++, playerNameOrNull);
                ps.setString(idx, uuidOrNull);
            } else if (playerNameOrNull != null && !playerNameOrNull.isBlank()) {
                ps.setString(idx, playerNameOrNull);
            } else {
                ps.setString(idx, uuidOrNull);
            }
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return 0;
                int n = rs.getInt(1);
                return n;
            }
        }
        catch (SQLException e) {
            LOGGER.error("\u7edf\u8ba1\u6309\u73a9\u5bb6\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
        }
        return 0;
    }

    public int deleteLogsBefore(long beforeMs) {
        int n;
        block18: {
            String sql = "DELETE FROM logs WHERE time_ms < ?";
            PreparedStatement ps = this.conn.prepareStatement(sql);
            try {
                ps.setLong(1, beforeMs);
                int affected = ps.executeUpdate();
                if (affected > 0 && this.dialect == Dialect.SQLITE) {
                    try (Statement st = this.conn.createStatement();){
                        st.execute("VACUUM");
                    }
                    catch (SQLException e) {
                        LOGGER.warn("SQLite VACUUM \u5931\u8d25\uff1a{}", (Object)e.toString());
                    }
                }
                n = affected;
                if (ps == null) break block18;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    LOGGER.error("\u6e05\u7406\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
                    return -1;
                }
            }
            ps.close();
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String findLastUuidByPlayerName(String playerName) {
        String sql = "SELECT uuid FROM logs WHERE player=? AND uuid IS NOT NULL ORDER BY time_ms DESC LIMIT 1";
        try (PreparedStatement ps = this.conn.prepareStatement(sql);){
            ps.setString(1, playerName);
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return null;
                String string = rs.getString(1);
                return string;
            }
        }
        catch (SQLException e) {
            LOGGER.error("\u6309\u73a9\u5bb6\u540d\u67e5\u8be2\u6700\u8fd1UUID\u5931\u8d25", (Throwable)e);
        }
        return null;
    }

    public void close() {
        this.writer.shutdown();
        try {
            this.conn.close();
            LOGGER.info("\u6570\u636e\u5e93\u8fde\u63a5\u5df2\u5173\u95ed");
        }
        catch (SQLException e) {
            LOGGER.error("\u5173\u95ed\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25", (Throwable)e);
        }
    }

    private static enum Dialect {
        SQLITE,
        MYSQL;

    }
}

