/*
 * Decompiled with CFR 0.152.
 */
package cn.alini.craftaudit.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class NameLocalization {
    private static final Map<String, String> ITEM_MAP = new HashMap<String, String>();
    private static final Map<String, String> BLOCK_MAP = new HashMap<String, String>();

    public static void scanRegistries() {
        String name;
        String id;
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            id = ForgeRegistries.ITEMS.getKey((Object)item).toString();
            name = item.m_7626_(ItemStack.f_41583_).getString();
            ITEM_MAP.put(id, name);
        }
        for (Block block : ForgeRegistries.BLOCKS.getValues()) {
            id = ForgeRegistries.BLOCKS.getKey((Object)block).toString();
            name = block.m_49954_().getString();
            BLOCK_MAP.put(id, name);
        }
    }

    public static String itemName(String id) {
        return ITEM_MAP.getOrDefault(id, id);
    }

    public static String blockName(String id) {
        return BLOCK_MAP.getOrDefault(id, id);
    }

    public static String localize(String id) {
        String v = ITEM_MAP.get(id);
        if (v != null) {
            return v;
        }
        v = BLOCK_MAP.get(id);
        if (v != null) {
            return v;
        }
        return id;
    }
}

