/*
 * Decompiled with CFR 0.152.
 */
package cn.alini.craftaudit.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.lang3.tuple.Pair;

public final class Config {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    public static boolean isSqlite() {
        return Config.COMMON.dbMode.get() == DbMode.SQLITE;
    }

    public static boolean isMySql() {
        return Config.COMMON.dbMode.get() == DbMode.MYSQL;
    }

    public static Path sqliteDbPath() {
        Path baseDir = FMLPaths.GAMEDIR.get();
        Path modDir = baseDir.resolve("craftaudit");
        try {
            Files.createDirectories(modDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return modDir.resolve((String)Config.COMMON.sqlitePath.get());
    }

    public static String mysqlJdbcUrl() {
        String host = (String)Config.COMMON.mysqlHost.get();
        int port = (Integer)Config.COMMON.mysqlPort.get();
        String db = (String)Config.COMMON.mysqlDatabase.get();
        boolean ssl = (Boolean)Config.COMMON.mysqlUseSSL.get();
        String params = (String)Config.COMMON.mysqlParams.get();
        String base = "jdbc:mysql://" + host + ":" + port + "/" + db + "?useSSL=" + ssl + "&characterEncoding=utf8&serverTimezone=UTC&rewriteBatchedStatements=true";
        if (params != null && !params.isBlank()) {
            return base + "&" + params;
        }
        return base;
    }

    public static String mysqlUser() {
        return (String)Config.COMMON.mysqlUser.get();
    }

    public static String mysqlPassword() {
        return (String)Config.COMMON.mysqlPassword.get();
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON = (Common)pair.getLeft();
        COMMON_SPEC = (ForgeConfigSpec)pair.getRight();
    }

    public static final class Common {
        public final ForgeConfigSpec.EnumValue<DbMode> dbMode;
        public final ForgeConfigSpec.ConfigValue<String> sqlitePath;
        public final ForgeConfigSpec.ConfigValue<String> mysqlHost;
        public final ForgeConfigSpec.IntValue mysqlPort;
        public final ForgeConfigSpec.ConfigValue<String> mysqlDatabase;
        public final ForgeConfigSpec.ConfigValue<String> mysqlUser;
        public final ForgeConfigSpec.ConfigValue<String> mysqlPassword;
        public final ForgeConfigSpec.BooleanValue mysqlUseSSL;
        public final ForgeConfigSpec.ConfigValue<String> mysqlParams;

        private Common(ForgeConfigSpec.Builder builder) {
            builder.push("database");
            this.dbMode = builder.comment("\u6570\u636e\u5e93\u6a21\u5f0f: SQLITE \u6216 MYSQL").defineEnum("mode", (Enum)DbMode.SQLITE);
            builder.push("sqlite");
            this.sqlitePath = builder.comment("SQLite \u6587\u4ef6\u540d\uff08\u5b58\u4e8e\u6e38\u620f\u6839\u76ee\u5f55\u4e0b\u7684craftaudit\u6587\u4ef6\u5939\uff09").define("path", (Object)"craftaudit.db");
            builder.pop();
            builder.push("mysql");
            this.mysqlHost = builder.define("host", (Object)"127.0.0.1");
            this.mysqlPort = builder.defineInRange("port", 3306, 1, 65535);
            this.mysqlDatabase = builder.define("database", (Object)"craftaudit");
            this.mysqlUser = builder.define("user", (Object)"root");
            this.mysqlPassword = builder.comment("\u6ce8\u610f: \u660e\u6587\u5b58\u50a8\uff0c\u8bf7\u8c28\u614e\u4f7f\u7528\u516c\u5171\u73af\u5883").define("password", (Object)"");
            this.mysqlUseSSL = builder.define("useSSL", false);
            this.mysqlParams = builder.comment("\u9644\u52a0 JDBC \u53c2\u6570\uff0c\u5f62\u5982 `allowPublicKeyRetrieval=true`").define("params", (Object)"");
            builder.pop();
            builder.pop();
        }
    }

    public static enum DbMode {
        SQLITE,
        MYSQL;

    }
}

