/*
 * Decompiled with CFR 0.152.
 */
package cn.alini.craftaudit.rollback;

import cn.alini.craftaudit.rollback.UndoManager;
import cn.alini.craftaudit.storage.Database;
import cn.alini.craftaudit.storage.LogEntry;
import com.mojang.logging.LogUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Base64;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

public final class RollbackService {
    private static final Logger LOGGER = LogUtils.getLogger();

    private RollbackService() {
    }

    public static int restoreBreaks(ServerLevel level, String dimension, BlockPos center, int radius, long sinceMs, List<String> actions, String naturalCauseFilterOrNull, UUID executorId) {
        List<LogEntry> logs = Database.get().queryLogsRegionSince(dimension, center.m_123341_() - radius, center.m_123341_() + radius, center.m_123342_() - radius, center.m_123342_() + radius, center.m_123343_() - radius, center.m_123343_() + radius, sinceMs, actions, null);
        logs.sort(Comparator.comparingLong(LogEntry::timeMillis).reversed());
        UndoManager.UndoBundle undo = executorId != null ? new UndoManager.UndoBundle(dimension) : null;
        int changed = 0;
        for (LogEntry e : logs) {
            BlockPos pos;
            String cause;
            String action = e.action();
            if (naturalCauseFilterOrNull != null && (!"natural_break".equals(action) || !naturalCauseFilterOrNull.equalsIgnoreCase(cause = RollbackService.extractJsonStringField(e.data(), "cause"))) || !"break".equals(action) && !"natural_break".equals(action) || !level.m_46749_(pos = new BlockPos(e.x(), e.y(), e.z()))) continue;
            try {
                String nbtB64;
                Block block;
                if (undo != null) {
                    BlockState before = level.m_8055_(pos);
                    CompoundTag beTag = null;
                    BlockEntity be = level.m_7702_(pos);
                    if (be != null) {
                        try {
                            beTag = be.m_187480_();
                            beTag.m_128405_("x", pos.m_123341_());
                            beTag.m_128405_("y", pos.m_123342_());
                            beTag.m_128405_("z", pos.m_123343_());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    undo.entries.add(new UndoManager.UndoEntry(pos, before, beTag));
                }
                if ((block = RollbackService.resolveBlock(e.target())) == null) continue;
                boolean ok = level.m_46597_(pos, block.m_49966_());
                if ("break".equals(action) && (nbtB64 = RollbackService.extractJsonStringField(e.data(), "nbt")) != null && !nbtB64.isEmpty()) {
                    try {
                        byte[] bytes = Base64.getDecoder().decode(nbtB64);
                        CompoundTag tag = NbtIo.m_128939_((InputStream)new ByteArrayInputStream(bytes));
                        tag.m_128405_("x", pos.m_123341_());
                        tag.m_128405_("y", pos.m_123342_());
                        tag.m_128405_("z", pos.m_123343_());
                        BlockEntity be2 = level.m_7702_(pos);
                        if (be2 != null) {
                            be2.m_142466_(tag);
                            be2.m_6596_();
                            ok = true;
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.warn("[craftaudit] \u6062\u590d NBT \u5931\u8d25 @ {}: {}", (Object)pos, (Object)ex.toString());
                    }
                }
                if (!ok) continue;
                ++changed;
            }
            catch (Exception ex) {
                LOGGER.warn("[craftaudit] \u6062\u590d\u7834\u574f\u5931\u8d25 @ {} {} -> {}: {}", new Object[]{e.x() + "/" + e.y() + "/" + e.z(), e.action(), e.target(), ex.toString()});
            }
        }
        if (executorId != null && undo != null && !undo.entries.isEmpty()) {
            UndoManager.saveLast(executorId, undo);
        }
        return changed;
    }

    public static int restoreKills(ServerLevel level, String dimension, BlockPos center, int radius, long sinceMs, String entityFilterOrNull, UUID executorId) {
        List<LogEntry> logs = Database.get().queryLogsRegionSince(dimension, center.m_123341_() - radius, center.m_123341_() + radius, center.m_123342_() - radius, center.m_123342_() + radius, center.m_123343_() - radius, center.m_123343_() + radius, sinceMs, List.of("kill"), null);
        logs.sort(Comparator.comparingLong(LogEntry::timeMillis).reversed());
        UndoManager.UndoBundle undo = executorId != null ? new UndoManager.UndoBundle(dimension) : null;
        int spawned = 0;
        for (LogEntry e : logs) {
            BlockPos pos;
            String target = e.target();
            if (target == null || target.startsWith("player:") || entityFilterOrNull != null && !entityFilterOrNull.equalsIgnoreCase(target) || !level.m_46749_(pos = new BlockPos(e.x(), e.y(), e.z()))) continue;
            try {
                Entity ent;
                EntityType<?> type = RollbackService.resolveEntityType(target);
                if (type == null || (ent = type.m_20615_((Level)level)) == null) continue;
                ent.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, level.f_46441_.m_188501_() * 360.0f, 0.0f);
                boolean ok = level.m_7967_(ent);
                if (!ok) continue;
                ++spawned;
                if (undo == null) continue;
                undo.spawnedEntities.add(ent.m_20148_());
            }
            catch (Exception ex) {
                LOGGER.warn("[craftaudit] \u6062\u590d\u51fb\u6740\u5931\u8d25 @ {} -> {}: {}", new Object[]{e.x() + "/" + e.y() + "/" + e.z(), target, ex.toString()});
            }
        }
        if (!(executorId == null || undo == null || undo.spawnedEntities.isEmpty() && undo.entries.isEmpty())) {
            UndoManager.saveLast(executorId, undo);
        }
        return spawned;
    }

    public static int restore(ServerLevel level, String dimension, BlockPos center, int radius, long sinceMs) {
        return RollbackService.rollback(level, dimension, center, radius, sinceMs, null);
    }

    public static int restore(ServerLevel level, String dimension, BlockPos center, int radius, long sinceMs, UUID executorId) {
        return RollbackService.rollback(level, dimension, center, radius, sinceMs, null, executorId);
    }

    public static int rollback(ServerLevel level, String dimension, BlockPos center, int radius, long sinceMs, String playerFilterOrNull) {
        return RollbackService.rollback(level, dimension, center, radius, sinceMs, playerFilterOrNull, null);
    }

    public static int rollback(ServerLevel level, String dimension, BlockPos center, int radius, long sinceMs, String playerFilterOrNull, UUID executorId) {
        List<LogEntry> logs = Database.get().queryLogsRegionSince(dimension, center.m_123341_() - radius, center.m_123341_() + radius, center.m_123342_() - radius, center.m_123342_() + radius, center.m_123343_() - radius, center.m_123343_() + radius, sinceMs, List.of("break", "place"), playerFilterOrNull);
        logs.sort(Comparator.comparingLong(LogEntry::timeMillis).reversed());
        UndoManager.UndoBundle undo = executorId != null ? new UndoManager.UndoBundle(dimension) : null;
        int changed = 0;
        for (LogEntry e : logs) {
            BlockPos pos = new BlockPos(e.x(), e.y(), e.z());
            if (!level.m_46749_(pos)) continue;
            try {
                Block block;
                if (undo != null) {
                    BlockState before = level.m_8055_(pos);
                    CompoundTag beTag = null;
                    BlockEntity be = level.m_7702_(pos);
                    if (be != null) {
                        try {
                            beTag = be.m_187480_();
                            beTag.m_128405_("x", pos.m_123341_());
                            beTag.m_128405_("y", pos.m_123342_());
                            beTag.m_128405_("z", pos.m_123343_());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    undo.entries.add(new UndoManager.UndoEntry(pos, before, beTag));
                }
                if (Objects.equals(e.action(), "place")) {
                    if (!level.m_46597_(pos, Blocks.f_50016_.m_49966_())) continue;
                    ++changed;
                    continue;
                }
                if (!Objects.equals(e.action(), "break") || (block = RollbackService.resolveBlock(e.target())) == null) continue;
                boolean ok = level.m_46597_(pos, block.m_49966_());
                String nbtB64 = RollbackService.extractJsonStringField(e.data(), "nbt");
                if (nbtB64 != null && !nbtB64.isEmpty()) {
                    try {
                        byte[] bytes = Base64.getDecoder().decode(nbtB64);
                        CompoundTag tag = NbtIo.m_128939_((InputStream)new ByteArrayInputStream(bytes));
                        tag.m_128405_("x", pos.m_123341_());
                        tag.m_128405_("y", pos.m_123342_());
                        tag.m_128405_("z", pos.m_123343_());
                        BlockEntity be2 = level.m_7702_(pos);
                        if (be2 != null) {
                            be2.m_142466_(tag);
                            be2.m_6596_();
                            ok = true;
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.warn("[craftaudit] \u56de\u6863 NBT \u5931\u8d25 @ {}: {}", (Object)pos, (Object)ex.toString());
                    }
                }
                if (!ok) continue;
                ++changed;
            }
            catch (Exception ex) {
                LOGGER.warn("[craftaudit] \u56de\u6863\u5931\u8d25 @ {} {} -> {}: {}", new Object[]{pos, e.action(), e.target(), ex.toString()});
            }
        }
        if (!(executorId == null || undo == null || undo.entries.isEmpty() && undo.spawnedEntities.isEmpty())) {
            UndoManager.saveLast(executorId, undo);
        }
        return changed;
    }

    private static Block resolveBlock(String id) {
        try {
            return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(id));
        }
        catch (Exception ignore) {
            return null;
        }
    }

    private static EntityType<?> resolveEntityType(String id) {
        try {
            return (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(id));
        }
        catch (Exception ignore) {
            return null;
        }
    }

    private static String extractJsonStringField(String json, String field) {
        if (json == null) {
            return null;
        }
        String key = "\"" + field + "\":\"";
        int i = json.indexOf(key);
        if (i < 0) {
            return null;
        }
        int start = i + key.length();
        int end = json.indexOf("\"", start);
        if (end < 0) {
            return null;
        }
        return json.substring(start, end);
    }
}

