/*
 * Decompiled with CFR 0.152.
 */
package nazario.nicosgraves.entity.custom;

import java.util.ArrayList;
import java.util.UUID;
import nazario.nicosgraves.NicosGraves;
import nazario.nicosgraves.api.SoulboundItem;
import nazario.nicosgraves.util.ModGamerules;
import nazario.nicosgraves.util.ModTags;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityType;
import net.minecraft.class_124;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1787;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1819;
import net.minecraft.class_1835;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.minecraft.class_4844;
import net.minecraft.class_5134;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7265;
import org.jetbrains.annotations.Nullable;

public class PlayerGraveEntity
extends class_1309
implements class_7265 {
    private static final int MAX_SIZE = 54;
    private class_2371<class_1799> inventory;
    private UUID owner;

    public PlayerGraveEntity(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5684(true);
        this.inventory = class_2371.method_10213((int)54, (Object)class_1799.field_8037);
    }

    public static FabricEntityType.Builder.Living<PlayerGraveEntity> createAttributes(FabricEntityType.Builder.Living<PlayerGraveEntity> builder) {
        return builder.defaultAttributes(() -> class_1309.method_26827().method_26868(class_5134.field_23719, 0.0).method_26868(class_5134.field_23718, 100.0).method_26868(class_5134.field_23717, 0.0));
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        nbt.method_10562("inventory").ifPresentOrElse(this::setInventoryFromNbt, () -> NicosGraves.LOGGER.warn("No inventory found in grave."));
        nbt.method_67491("owner", class_4844.field_40825).ifPresentOrElse(this::setOwnerUUID, () -> NicosGraves.LOGGER.warn("Owner UUID not found in grave."));
    }

    public void setInventoryFromNbt(class_2487 inventoryNbt) {
        class_1262.method_5429((class_2487)inventoryNbt, this.method_42278(), (class_7225.class_7874)this.method_37908().method_30349());
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        class_2487 inventoryNbt = new class_2487();
        class_1262.method_5426((class_2487)inventoryNbt, this.method_42278(), (class_7225.class_7874)this.method_37908().method_30349());
        nbt.method_67494("inventory", class_2487.field_25128, (Object)inventoryNbt);
        nbt.method_67494("owner", class_4844.field_40825, (Object)this.owner);
    }

    private void setOwnerUUID(UUID uuid) {
        this.owner = uuid;
    }

    public void setOwner(class_1657 player) {
        this.owner = player.method_5667();
    }

    public UUID getOwnerUUID() {
        return this.owner;
    }

    private void applyWaterBuoyancy() {
        class_243 vec3d = this.method_18798();
        this.method_18800(vec3d.field_1352 * 0.99, vec3d.field_1351 + (vec3d.field_1351 < 0.05 ? 0.02 : 0.0), vec3d.field_1350 * 0.99);
    }

    private void applyLavaBuoyancy() {
        class_243 vec3d = this.method_18798();
        this.method_18800(vec3d.field_1352 * 0.99, vec3d.field_1351 + (vec3d.field_1351 < 0.1 ? 0.04 : 0.0), vec3d.field_1350 * 0.99);
    }

    public void method_5773() {
        super.method_5773();
        float f = this.method_5751();
        if (this.method_5799() && this.method_5861(class_3486.field_15517) > (double)f) {
            this.applyWaterBuoyancy();
            this.field_6007 = true;
            this.field_6037 = true;
        } else if (this.method_5771() && this.method_5861(class_3486.field_15518) > (double)f) {
            this.applyLavaBuoyancy();
            this.field_6007 = true;
            this.field_6037 = true;
        }
    }

    public void method_5768(class_3218 world) {
        this.kill();
    }

    public void kill() {
        this.dropInventory();
        this.method_31472();
    }

    public boolean method_64397(class_3218 world, class_1282 source, float amount) {
        return this.damage(source, amount);
    }

    public boolean damage(class_1282 source, float amount) {
        class_1937 world = this.method_37908();
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                if (serverWorld.method_64395().method_8355(ModGamerules.ONLY_OWNER_ACCESS) && !this.getOwnerUUID().equals(player.method_5667())) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.nicos_graves.not_owner").method_27692(class_124.field_1061), true);
                    return false;
                }
                if (player.method_5715()) {
                    this.dropInventory();
                    this.method_31472();
                    return true;
                }
            }
        }
        return false;
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        class_3218 serverWorld;
        class_1937 world = player.method_37908();
        if (player.method_5998(class_1268.field_5808).method_7909() instanceof class_1753 || player.method_5998(class_1268.field_5808).method_7909() instanceof class_1819 || player.method_5998(class_1268.field_5808).method_7909() instanceof class_1835 || player.method_5998(class_1268.field_5808).method_7909() instanceof class_1787 || player.method_5998(class_1268.field_5808).method_7909() instanceof class_1764) {
            return class_1269.field_5811;
        }
        if (world.method_8608()) {
            return class_1269.field_5811;
        }
        if (world instanceof class_3218 && (serverWorld = (class_3218)world).method_64395().method_8355(ModGamerules.ONLY_OWNER_ACCESS) && this.owner != null && !player.method_5667().equals(this.owner)) {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.nicos_graves.not_owner").method_27692(class_124.field_1061), true);
            return class_1269.field_5811;
        }
        this.method_42284(player);
        return class_1269.field_5812;
    }

    protected void method_16078(class_3218 world) {
        this.dropInventory();
    }

    protected void dropInventory() {
        class_1937 world = this.method_37908();
        for (int i = 0; i < this.inventory.size(); ++i) {
            class_1542 itemEntity = new class_1542(class_1299.field_6052, world);
            itemEntity.method_6979((class_1799)this.inventory.get(i));
            itemEntity.method_33574(this.method_19538());
            world.method_8649((class_1297)itemEntity);
        }
        this.method_42293();
    }

    public void addInventoryStackCheckSoulbound(class_1799 stack, class_1657 victimPlayer) {
        SoulboundItem soulboundItem;
        class_1792 class_17922;
        class_1937 world = victimPlayer.method_37908();
        if (stack.method_7909().method_40131().method_40220(ModTags.ItemTags.SOULBOUND_ITEMS) || (class_17922 = stack.method_7909()) instanceof SoulboundItem && (soulboundItem = (SoulboundItem)class_17922).isRetained(stack, victimPlayer, world)) {
            return;
        }
        this.addInventoryStack(stack);
    }

    public void addInventoryStack(class_1799 stack) {
        if (stack == null) {
            return;
        }
        if (stack.method_7960()) {
            return;
        }
        if (stack.method_7909().equals(class_1802.field_8162)) {
            return;
        }
        for (int i = 0; i < 54; ++i) {
            if (!((class_1799)this.inventory.get(i)).method_7909().equals(class_1802.field_8162)) continue;
            this.method_42287(i, stack);
            break;
        }
    }

    public class_2371<class_1799> method_42278() {
        return this.inventory;
    }

    public void method_42273() {
        this.inventory = class_2371.method_10213((int)54, (Object)class_1799.field_8037);
    }

    public int method_5439() {
        return 54;
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.inventory.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        class_1799 currentStack = (class_1799)this.inventory.get(slot);
        if (currentStack.method_7960()) {
            return class_1799.field_8037;
        }
        class_1799 removedStack = currentStack.method_7971(amount);
        if (currentStack.method_7960()) {
            this.inventory.set(slot, (Object)class_1799.field_8037);
        }
        return removedStack;
    }

    public class_1799 method_5441(int slot) {
        return (class_1799)this.inventory.set(slot, (Object)class_1799.field_8037);
    }

    public void method_5447(int slot, class_1799 stack) {
        this.inventory.set(slot, (Object)stack);
    }

    public void method_5431() {
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return class_1707.method_19247((int)syncId, (class_1661)inv, (class_1263)this);
    }

    public void method_5448() {
        this.inventory.clear();
    }

    public Iterable<class_1799> getArmorItems() {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        stacks.forEach(stack -> new class_1799((class_1935)class_1802.field_8162));
        return stacks;
    }

    public class_1799 method_6118(class_1304 slot) {
        return new class_1799((class_1935)class_1802.field_8162);
    }

    public void method_5673(class_1304 slot, class_1799 stack) {
    }

    public class_1306 method_6068() {
        return class_1306.field_6183;
    }

    public boolean method_5810() {
        return false;
    }

    public boolean method_5675() {
        return false;
    }

    public void method_42275(@Nullable class_5321<class_52> lootTable) {
    }

    public void method_42274(long lootTableSeed) {
    }

    @Nullable
    public class_5321<class_52> method_42276() {
        return null;
    }
}

