package nazario.nicosgraves.entity.custom;

import nazario.nicosgraves.api.SoulboundItem;
import nazario.nicosgraves.util.ModGamerules;
import nazario.nicosgraves.util.ModTags;
import net.minecraft.class_124;
import net.minecraft.class_1262;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1787;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1819;
import net.minecraft.class_1835;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3486;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_7265;
import net.minecraft.item.*;
import net.minecraft.util.*;
import org.jetbrains.annotations.Nullable;
import java.util.ArrayList;
import java.util.UUID;

public class PlayerGraveEntity extends class_1309 implements class_7265 {

    private static final int MAX_SIZE = 27*2; // Maximum inventory size
    private class_2371<class_1799> inventory;
    private UUID owner;

    public PlayerGraveEntity(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5684(true);
        this.inventory = class_2371.method_10213(MAX_SIZE, class_1799.field_8037);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1309.method_26827()
                .method_26868(class_5134.field_23719, 0f)
                .method_26868(class_5134.field_23718, 100f)
                .method_26868(class_5134.field_23717, 0f);
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);

        class_1262.method_5429(nbt.method_10562("inventory"), this.method_42278());
        this.owner = nbt.method_25926("owner");
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);

        class_2487 inventoryNbt = new class_2487();
        class_1262.method_5426(inventoryNbt, this.method_42278());

        nbt.method_10566("inventory", inventoryNbt);
        nbt.method_25927("owner", this.owner);
    }

    public void setOwner(class_1657 player) {
        this.owner = player.method_5667();
    }

    public UUID getOwnerUUID() {
        return this.owner;
    }

    private void applyWaterBuoyancy() {
        class_243 vec3d = this.method_18798();
        this.method_18800(vec3d.field_1352 * 0.99, vec3d.field_1351 + (vec3d.field_1351 < 0.05 ? 0.02 : 0.0), vec3d.field_1350 * 0.99);
    }

    private void applyLavaBuoyancy() {
        class_243 vec3d = this.method_18798();
        this.method_18800(vec3d.field_1352 * 0.99, vec3d.field_1351 + (vec3d.field_1351 < 0.10 ? 0.04 : 0.0), vec3d.field_1350 * 0.99);
    }

    @Override
    public void method_5773() {
        super.method_5773();

        float f = this.method_5751();
        if (this.method_5799() && this.method_5861(class_3486.field_15517) > (double)f) {
            this.applyWaterBuoyancy();
            this.field_6007 = true;
            this.field_6037 = true;
        } else if (this.method_5771() && this.method_5861(class_3486.field_15518) > (double)f) {
            this.applyLavaBuoyancy();
            this.field_6007 = true;
            this.field_6037 = true;
        }
    }


    public void method_5768() {
        this.method_16078();
        this.method_31472();
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        if(source.method_5529() instanceof class_1657 player) {
            if(method_37908().method_8450().method_8355(ModGamerules.ONLY_OWNER_ACCESS) && !this.getOwnerUUID().equals(player.method_5667())) {
                player.method_7353(class_2561.method_43471("message.nicos_graves.not_owner").method_27692(class_124.field_1061), true);
                return false;
            }

            if(player.method_5715()) {
                if(method_37908().field_9236) return true;

                this.method_16078();
                this.method_31472();
                return true;
            }
        }
        return false;
    }

    @Override
    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if(player.method_5998(class_1268.field_5808).method_7909() instanceof class_1753 ||
                player.method_5998(class_1268.field_5808).method_7909() instanceof class_1819 ||
                player.method_5998(class_1268.field_5808).method_7909() instanceof class_1835 ||
                player.method_5998(class_1268.field_5808).method_7909() instanceof class_1787 ||
                player.method_5998(class_1268.field_5808).method_7909() instanceof class_1764
        ) return class_1269.field_5811;

        if (player.method_37908().field_9236) {
            return class_1269.field_5811;
        }

        if (method_5770().method_8450().method_8355(ModGamerules.ONLY_OWNER_ACCESS) && this.owner != null && !player.method_5667().equals(this.owner)) {
            player.method_7353(class_2561.method_43471("message.nicos_graves.not_owner").method_27692(class_124.field_1061), true);
            return class_1269.field_5811;
        }

        //? >=1.19.4 {
        this.method_42284(player);
        //?} else {
        /*this.open(this::emitGameEvent, player);
        *///?}
        return class_1269.field_5812; // Prevents further interaction processing
    }

    @Override
    protected void method_16078() {
        for(int i = 0;i<inventory.size();i++) {
            class_1542 itemEntity = new class_1542(class_1299.field_6052, method_37908());

            itemEntity.method_6979(inventory.get(i));
            itemEntity.method_33574(this.method_19538());

            method_37908().method_8649(itemEntity);
        }
        this.method_42293();
    }

    public void addInventoryStackCheckSoulbound(class_1799 stack, class_1657 victimPlayer) {
        if(stack.method_7909().method_40131().method_40220(ModTags.ItemTags.SOULBOUND_ITEMS) || (stack.method_7909() instanceof SoulboundItem soulboundItem && soulboundItem.isRetained(stack, victimPlayer, victimPlayer.method_37908()))) return;
        this.addInventoryStack(stack);
    }

    public void addInventoryStack(class_1799 stack) {
        if(stack == null) return;
        if(stack.method_7960()) return;
        if(stack.method_7909().equals(class_1802.field_8162)) return;
        for(int i = 0;i<MAX_SIZE;i++) {
            if(inventory.get(i).method_7909().equals(class_1802.field_8162)) {
                method_42287(i, stack);
                break;
            }
        }
    }

    @Override
    public class_2371<class_1799> method_42278() {
        return inventory;
    }

    @Override
    public void method_42273() {
        this.inventory = class_2371.method_10213(MAX_SIZE, class_1799.field_8037);
    }

    @Override
    public int method_5439() {
        return MAX_SIZE;
    }

    @Override
    public class_1799 method_5438(int slot) {
        return inventory.get(slot);
    }

    @Override
    public class_1799 method_5434(int slot, int amount) {
        class_1799 currentStack = inventory.get(slot);
        if (currentStack.method_7960()) {
            return class_1799.field_8037;
        }

        // Split the stack
        class_1799 removedStack = currentStack.method_7971(amount);

        // If the current stack is now empty, set the slot to EMPTY
        if (currentStack.method_7960()) {
            inventory.set(slot, class_1799.field_8037);
        }

        return removedStack;
    }

    @Override
    public class_1799 method_5441(int slot) {
        return inventory.set(slot, class_1799.field_8037);
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        inventory.set(slot, stack);
    }

    @Override
    public void method_5431() {

    }

    @Override
    public boolean method_5443(class_1657 player) {
        return true;
    }

    @Override
    public @Nullable class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return class_1707.method_19247(syncId, inv, this);
    }

    @Override
    public void method_5448() {
        inventory.clear();
    }

    @Override
    public Iterable<class_1799> method_5661() {
        Iterable<class_1799> stacks = new ArrayList<class_1799>();
        stacks.forEach(stack -> new class_1799(class_1802.field_8162));
        return stacks;
    }

    @Override
    public class_1799 method_6118(class_1304 slot) {
        return new class_1799(class_1802.field_8162);
    }

    @Override
    public void method_5673(class_1304 slot, class_1799 stack) {

    }

    @Override
    public class_1306 method_6068() {
        return class_1306.field_6183;
    }

    @Override
    public boolean method_5810() {
        return false;
    }

    @Override
    public boolean method_5675() {
        return false;
    }

    //region// No clue //
    @Override
    public long method_42277() {
        return 0;
    }
    @Override
    public @Nullable class_2960 method_42276() {
        return null;
    }

    @Override
    public void method_42275(@Nullable class_2960 lootTableId) {

    }

    @Override
    public void method_42274(long lootTableSeed) {

    }
    //endregion
}
