package nazario.nicosgraves.mixin;

import nazario.nicosgraves.util.ModGamerules;
import nazario.nicosgraves.util.ModTags;
import nazario.nicosgraves.util.comp.TrinketsHelper;
import nazario.nicosgraves.util.comp.YYZsBackpackHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1928;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value = class_1657.class, priority = 1500)
public abstract class PlayerEntityMixin {
    @Inject(method = "dropInventory", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/player/PlayerEntity;vanishCursedItems()V"), cancellable = true)
    private void grimoire$preDropInventory(CallbackInfo ci) {
        class_1657 player = (class_1657)(Object)this;

        if(player.method_37908().method_8450().method_8355(class_1928.field_19389)) return;

        if (FabricLoader.getInstance().isModLoaded("yyzsbackpack") && player instanceof class_3222 serverPlayer) {
            try {
                class_1799 backpackStack = YYZsBackpackHelper.save(serverPlayer);
                grimoire$dropAndDecrement(backpackStack, player);
            } catch (Exception ignored) {}
        }

        if (FabricLoader.getInstance().isModLoaded("trinkets")) {
            try {
                TrinketsHelper.findAllEquippedBy(player).forEach(stack -> grimoire$dropAndDecrement(stack, player));
            } catch (Exception ignored) {}
        }

        player.method_31548().field_7547.forEach(stack -> grimoire$dropAndDecrement(stack, player));
        player.method_31548().field_7544.forEach(stack -> grimoire$dropAndDecrement(stack, player));
        player.method_31548().field_7548.forEach(stack -> grimoire$dropAndDecrement(stack, player));

        ci.cancel();
    }

    @Unique
    private void grimoire$dropAndDecrement(class_1799 stack, class_1657 player) {
        if(player.method_37908().field_9236) return;

        if(!(stack.method_7909().method_40131().method_40220(ModTags.ItemTags.SOULBOUND_ITEMS))) {
            if(!player.method_37908().method_8450().method_8355(ModGamerules.SPAWN_PLAYER_GRAVES) && !class_1890.method_8221(stack)) player.method_5775(stack.method_7972());
            stack.method_7939(0);
        }
    }
}
@Mixin(class_3222.class)
abstract class ServerPlayerEntityMixin {
    @Inject(method = "copyFrom", at = @At(value = "TAIL"))
    private void grimoire$copyFrom(class_3222 oldPlayer, boolean alive, CallbackInfo ci) {
        class_3222 player = (class_3222)(Object)this;
        if(player.method_14220().method_8450().method_8355(class_1928.field_19389)) return;
        player.method_31548().method_7377(oldPlayer.method_31548());
    }
}