package nazario.nicosgraves.entity.custom.client;

import nazario.nicosgraves.entity.custom.PlayerGraveEntity;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.render.VertexConsumerProvider;
import net.minecraft.client.render.entity.EntityRendererFactory;
import net.minecraft.client.render.entity.LivingEntityRenderer;
import net.minecraft.client.render.item.ItemRenderer;
import net.minecraft.client.render.model.json.ModelTransformationMode;
import net.minecraft.client.util.math.MatrixStack;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.nbt.NbtHelper;
import net.minecraft.util.Identifier;
import net.minecraft.util.math.RotationAxis;

public class PlayerGraveRenderer extends LivingEntityRenderer<PlayerGraveEntity, PlayerGraveEntityModel<PlayerGraveEntity>> {

    public PlayerGraveRenderer(EntityRendererFactory.Context ctx) {
        super(ctx, new PlayerGraveEntityModel<>(), 0.3f);
    }

    @Override
    public void render(PlayerGraveEntity entity, float yaw, float tickDelta, MatrixStack matrixStack, VertexConsumerProvider vertexConsumers, int light) {
        ItemRenderer itemRenderer = MinecraftClient.getInstance().getItemRenderer();

        ItemStack stack = new ItemStack(Items.SKELETON_SKULL);

        if(entity.getGameProfile() != null) {
            NbtCompound skullOwnerNbt = new NbtCompound();
            NbtHelper.writeGameProfile(skullOwnerNbt, entity.getGameProfile());

            stack = new ItemStack(Items.PLAYER_HEAD);
            stack.getOrCreateNbt().put("SkullOwner", skullOwnerNbt);
        }

        matrixStack.push();

        matrixStack.scale(1.5f, 1.5f, 1.5f);
        matrixStack.translate(0, 0.25, 0);

        matrixStack.translate(0, Math.sin((entity.getWorld().getTime() + tickDelta)*0.1f)*0.1f, 0);

        matrixStack.multiply(RotationAxis.POSITIVE_Y.rotationDegrees((entity.getWorld().getTime() + tickDelta) * 2.5f));

        itemRenderer.renderItem(stack, ModelTransformationMode.GROUND, false, matrixStack, vertexConsumers, light, 0, itemRenderer.getModel(stack, entity.getWorld(), null, 0));

        matrixStack.pop();

        if(entity.getCustomName() != null) {
            this.renderLabelIfPresent(entity, entity.getCustomName(), matrixStack, vertexConsumers, light);
        }
    }
    @Override
    public Identifier getTexture(PlayerGraveEntity entity) {
        return null;
    }
}
