/*
 * Decompiled with CFR 0.152.
 */
package com.developerkry.discordwhitelist;

import java.io.File;
import java.lang.reflect.Method;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.essentialsx.api.v2.services.discord.DiscordService;
import net.essentialsx.api.v2.services.discordlink.DiscordLinkService;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin
implements Listener {
    private String requiredRoleId;
    private String requiredRoleName;
    private String kickNotLinked;
    private String kickNoRole;
    private String kickError;
    private String kickNotConfigured;
    private String bypassPermission;
    private String logPrefix;
    private DiscordLinkService discordLinkService;
    private DiscordService discordService;

    public void onEnable() {
        File configFile;
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        if (!(configFile = new File(this.getDataFolder(), "config.yml")).exists()) {
            this.saveDefaultConfig();
        }
        try {
            this.reloadConfig();
            this.requiredRoleId = this.getConfig().getString("required-discord-role-id");
            this.getLogger().info("[DiscordWhitelist] requiredRoleId from config: " + this.requiredRoleId);
        }
        catch (Exception e) {
            this.requiredRoleId = null;
        }
        this.requiredRoleName = this.getConfig().getString("required-discord-role-name", null);
        this.kickNotLinked = this.getConfig().getString("kick-not-linked", "You must link your Discord account and have the required role to join this server.");
        this.kickNoRole = this.getConfig().getString("kick-no-role", "You are linked to a Discord account, but you do not have the required role to join this server.");
        this.kickError = this.getConfig().getString("kick-error", "Could not verify your Discord role. Try again later or contact staff.");
        this.kickNotConfigured = this.getConfig().getString("kick-not-configured", "Plugin not configured correctly. Contact server staff.");
        this.bypassPermission = this.getConfig().getString("bypass-permission", "discordwhitelist.bypass");
        this.logPrefix = this.getConfig().getString("log-prefix", "[DiscordWhitelist] ");
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.discordLinkService = (DiscordLinkService)Bukkit.getServicesManager().load(DiscordLinkService.class);
        this.discordService = (DiscordService)Bukkit.getServicesManager().load(DiscordService.class);
        if (this.discordLinkService != null && this.discordService != null) {
            this.getLogger().info("EssentialsX Discord services found and enabled.");
        } else {
            if (this.discordLinkService == null) {
                this.getLogger().severe("EssentialsXDiscordLink service is null!");
            }
            if (this.discordService == null) {
                this.getLogger().severe("EssentialsXDiscord service is null!");
            }
            this.getLogger().severe("EssentialsX Discord Link not found. Disabling plugin.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    @EventHandler
    public void onPlayerPreLogin(AsyncPlayerPreLoginEvent event) {
        block13: {
            if (this.discordLinkService == null || this.discordService == null || this.requiredRoleId == null) {
                event.setKickMessage(this.kickNotConfigured);
                event.setLoginResult(AsyncPlayerPreLoginEvent.Result.KICK_OTHER);
                return;
            }
            UUID playerUUID = event.getUniqueId();
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)playerUUID);
            if (offlinePlayer.isOnline() && offlinePlayer.getPlayer().hasPermission(this.bypassPermission)) {
                this.getLogger().info(this.logPrefix + "Player " + offlinePlayer.getName() + " bypassed Discord whitelist check.");
                return;
            }
            String discordId = this.discordLinkService.getDiscordId(playerUUID);
            if (discordId != null) {
                try {
                    Object memberFuture = this.discordService.getClass().getMethod("getMemberById", String.class).invoke((Object)this.discordService, discordId);
                    CompletableFuture future = (CompletableFuture)memberFuture;
                    Object member = future.join();
                    this.getLogger().info(this.logPrefix + "Discord member object: " + (member != null ? member.getClass().getName() : "null"));
                    if (member != null) {
                        Method hasRoleMethod;
                        boolean hasRole = false;
                        try {
                            hasRoleMethod = member.getClass().getMethod("hasRole", String.class);
                            hasRole = (Boolean)hasRoleMethod.invoke(member, this.requiredRoleId);
                            this.getLogger().info(this.logPrefix + "hasRole(" + this.requiredRoleId + ") returned: " + hasRole);
                        }
                        catch (Exception e) {
                            this.getLogger().warning(this.logPrefix + "Error calling hasRole: " + e.getMessage());
                        }
                        if (!hasRole && this.requiredRoleName != null && !this.requiredRoleName.isEmpty()) {
                            try {
                                hasRoleMethod = member.getClass().getMethod("hasRole", String.class);
                                hasRole = (Boolean)hasRoleMethod.invoke(member, this.requiredRoleName);
                                this.getLogger().info(this.logPrefix + "hasRole(" + this.requiredRoleName + ") returned: " + hasRole);
                            }
                            catch (Exception e) {
                                this.getLogger().warning(this.logPrefix + "Error calling hasRole with role name: " + e.getMessage());
                            }
                        }
                        if (hasRole) {
                            this.getLogger().info(this.logPrefix + "Player has required Discord role.");
                            return;
                        }
                        this.getLogger().warning(this.logPrefix + "Player does NOT have required Discord role. Required: " + (this.requiredRoleName != null ? this.requiredRoleName : this.requiredRoleId));
                        event.setKickMessage(this.kickNoRole);
                        event.setLoginResult(AsyncPlayerPreLoginEvent.Result.KICK_OTHER);
                        break block13;
                    }
                    event.setKickMessage(this.kickError);
                    event.setLoginResult(AsyncPlayerPreLoginEvent.Result.KICK_OTHER);
                }
                catch (Exception ex) {
                    this.getLogger().warning(this.logPrefix + "Error fetching Discord member for player " + event.getName() + ": " + ex.getMessage());
                    event.setKickMessage(this.kickError);
                    event.setLoginResult(AsyncPlayerPreLoginEvent.Result.KICK_OTHER);
                }
            } else {
                event.setKickMessage(this.kickNotLinked);
                event.setLoginResult(AsyncPlayerPreLoginEvent.Result.KICK_OTHER);
            }
        }
    }
}

