/*
 * Decompiled with CFR 0.152.
 */
package net.zjjohn121110.aethersdelight.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.zjjohn121110.aethersdelight.registry.AethersDelightItems;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class RoastMoaBlock
extends HorizontalDirectionalBlock {
    public static final MapCodec<RoastMoaBlock> CODEC = RoastMoaBlock.simpleCodec(RoastMoaBlock::new);
    public static final EnumProperty<BedPart> PART = BlockStateProperties.BED_PART;
    public static final IntegerProperty SERVINGS = IntegerProperty.create((String)"servings", (int)0, (int)6);
    protected static final VoxelShape[] SHAPES_NORTH_HEAD = new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)2.0, (double)0.0, (double)0.0, (double)12.0, (double)0.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)2.0, (double)0.0, (double)0.0, (double)12.0, (double)0.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)2.0, (double)0.0, (double)0.0, (double)12.0, (double)0.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)12.0, (double)2.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)12.0, (double)4.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)12.0, (double)7.0))};
    protected static final VoxelShape[] SHAPES_NORTH_FOOT = new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)2.0, (double)2.0, (double)9.0, (double)14.0, (double)12.0, (double)12.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)2.0, (double)2.0, (double)9.0, (double)14.0, (double)12.0, (double)14.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)2.0, (double)2.0, (double)9.0, (double)14.0, (double)12.0, (double)16.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)2.0, (double)2.0, (double)9.0, (double)14.0, (double)12.0, (double)16.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)2.0, (double)2.0, (double)9.0, (double)14.0, (double)12.0, (double)16.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)2.0, (double)2.0, (double)9.0, (double)14.0, (double)12.0, (double)16.0))};
    protected static final VoxelShape[] SHAPES_SOUTH_HEAD = new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)2.0, (double)0.0, (double)0.0, (double)12.0, (double)0.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)2.0, (double)0.0, (double)0.0, (double)12.0, (double)0.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)2.0, (double)0.0, (double)0.0, (double)12.0, (double)0.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)12.0, (double)16.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)2.0, (double)2.0, (double)12.0, (double)14.0, (double)12.0, (double)16.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)2.0, (double)2.0, (double)9.0, (double)14.0, (double)12.0, (double)16.0))};
    protected static final VoxelShape[] SHAPES_SOUTH_FOOT = new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)2.0, (double)2.0, (double)4.0, (double)14.0, (double)12.0, (double)7.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)12.0, (double)7.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)12.0, (double)7.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)12.0, (double)7.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)12.0, (double)7.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)12.0, (double)7.0))};
    protected static final VoxelShape[] SHAPES_WEST_HEAD = new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)2.0, (double)0.0, (double)0.0, (double)12.0, (double)0.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)2.0, (double)0.0, (double)0.0, (double)12.0, (double)0.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)2.0, (double)0.0, (double)0.0, (double)12.0, (double)0.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)2.0, (double)2.0, (double)2.0, (double)12.0, (double)14.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)2.0, (double)2.0, (double)4.0, (double)12.0, (double)14.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)2.0, (double)2.0, (double)7.0, (double)12.0, (double)14.0))};
    protected static final VoxelShape[] SHAPES_WEST_FOOT = new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)9.0, (double)2.0, (double)2.0, (double)12.0, (double)12.0, (double)14.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)9.0, (double)2.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)9.0, (double)2.0, (double)2.0, (double)16.0, (double)12.0, (double)14.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)9.0, (double)2.0, (double)2.0, (double)16.0, (double)12.0, (double)14.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)9.0, (double)2.0, (double)2.0, (double)16.0, (double)12.0, (double)14.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)9.0, (double)2.0, (double)2.0, (double)16.0, (double)12.0, (double)14.0))};
    protected static final VoxelShape[] SHAPES_EAST_HEAD = new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)2.0, (double)0.0, (double)0.0, (double)12.0, (double)0.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)2.0, (double)0.0, (double)0.0, (double)12.0, (double)0.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)2.0, (double)0.0, (double)0.0, (double)12.0, (double)0.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)14.0, (double)2.0, (double)2.0, (double)16.0, (double)12.0, (double)14.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)12.0, (double)2.0, (double)2.0, (double)16.0, (double)12.0, (double)14.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)9.0, (double)2.0, (double)2.0, (double)16.0, (double)12.0, (double)14.0))};
    protected static final VoxelShape[] SHAPES_EAST_FOOT = new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)4.0, (double)2.0, (double)2.0, (double)7.0, (double)12.0, (double)14.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)2.0, (double)2.0, (double)2.0, (double)7.0, (double)12.0, (double)14.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)2.0, (double)2.0, (double)7.0, (double)12.0, (double)14.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)2.0, (double)2.0, (double)7.0, (double)12.0, (double)14.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)2.0, (double)2.0, (double)7.0, (double)12.0, (double)14.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)2.0, (double)2.0, (double)7.0, (double)12.0, (double)14.0))};

    public RoastMoaBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)SERVINGS, (Comparable)Integer.valueOf(6))).setValue(PART, (Comparable)BedPart.HEAD));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (state.getValue(PART) == BedPart.HEAD) {
            switch ((Direction)state.getValue((Property)FACING)) {
                case NORTH: {
                    return SHAPES_NORTH_HEAD[(Integer)state.getValue((Property)SERVINGS)];
                }
                case SOUTH: {
                    return SHAPES_SOUTH_HEAD[(Integer)state.getValue((Property)SERVINGS)];
                }
                case WEST: {
                    return SHAPES_WEST_HEAD[(Integer)state.getValue((Property)SERVINGS)];
                }
                case EAST: {
                    return SHAPES_EAST_HEAD[(Integer)state.getValue((Property)SERVINGS)];
                }
            }
        }
        if (state.getValue(PART) == BedPart.FOOT) {
            switch ((Direction)state.getValue((Property)FACING)) {
                case NORTH: {
                    return SHAPES_NORTH_FOOT[(Integer)state.getValue((Property)SERVINGS)];
                }
                case SOUTH: {
                    return SHAPES_SOUTH_FOOT[(Integer)state.getValue((Property)SERVINGS)];
                }
                case WEST: {
                    return SHAPES_WEST_FOOT[(Integer)state.getValue((Property)SERVINGS)];
                }
                case EAST: {
                    return SHAPES_EAST_FOOT[(Integer)state.getValue((Property)SERVINGS)];
                }
            }
        }
        return SHAPES_NORTH_HEAD[(Integer)state.getValue((Property)SERVINGS)];
    }

    private static Direction getDirectionToOther(BedPart part, Direction direction) {
        return part == BedPart.HEAD ? direction : direction.getOpposite();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, SERVINGS, PART});
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing != RoastMoaBlock.getDirectionToOther((BedPart)stateIn.getValue(PART), (Direction)stateIn.getValue((Property)FACING))) {
            return !stateIn.canSurvive((LevelReader)worldIn, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        }
        return stateIn.canSurvive((LevelReader)worldIn, currentPos) && facingState.is((Block)this) && facingState.getValue(PART) != stateIn.getValue(PART) ? stateIn : Blocks.AIR.defaultBlockState();
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos blockpos;
        BlockState blockstate;
        BedPart bedpart;
        if (!level.isClientSide && player.isCreative() && (bedpart = (BedPart)state.getValue(PART)) == BedPart.FOOT && (blockstate = level.getBlockState(blockpos = pos.relative(RoastMoaBlock.getDirectionToOther(bedpart, (Direction)state.getValue((Property)FACING))))).is((Block)this) && blockstate.getValue(PART) == BedPart.HEAD) {
            level.setBlock(blockpos, Blocks.AIR.defaultBlockState(), 35);
            level.levelEvent(player, 2001, blockpos, Block.getId((BlockState)blockstate));
        }
        super.playerWillDestroy(level, pos, state, player);
        return state;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_49479_) {
        Direction direction = p_49479_.getHorizontalDirection();
        BlockPos blockpos = p_49479_.getClickedPos();
        BlockPos blockpos1 = blockpos.relative(direction);
        Level level = p_49479_.getLevel();
        return level.getBlockState(blockpos1).canBeReplaced(p_49479_) && level.getWorldBorder().isWithinBounds(blockpos1) ? (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction) : null;
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(worldIn, pos, state, placer, stack);
        if (!worldIn.isClientSide) {
            BlockPos facingPos = pos.relative((Direction)state.getValue((Property)FACING));
            worldIn.setBlock(facingPos, (BlockState)state.setValue(PART, (Comparable)BedPart.FOOT), 3);
            worldIn.blockUpdated(pos, Blocks.AIR);
            state.updateNeighbourShapes((LevelAccessor)worldIn, pos, 3);
        }
    }

    public static DoubleBlockCombiner.BlockType getBlockType(BlockState state) {
        BedPart bedpart = (BedPart)state.getValue(PART);
        return bedpart == BedPart.FOOT ? DoubleBlockCombiner.BlockType.FIRST : DoubleBlockCombiner.BlockType.SECOND;
    }

    public ItemInteractionResult useItemOn(ItemStack heldStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        int servings = (Integer)state.getValue((Property)SERVINGS);
        if (heldStack.is(Items.BOWL) && servings > 0) {
            return this.takeServing(level, pos, state, player, hand, (Item)AethersDelightItems.ROAST_MOA.get());
        }
        if (servings == 0) {
            level.playSound(null, pos, SoundEvents.WOOD_BREAK, SoundSource.PLAYERS, 1.0f, 1.0f);
            level.destroyBlock(pos, true);
        } else {
            player.displayClientMessage((Component)TextUtils.getTranslation((String)"block.feast.use_container", (Object[])new Object[]{new ItemStack((ItemLike)Items.BOWL).getHoverName()}), true);
        }
        return ItemInteractionResult.SUCCESS;
    }

    protected ItemInteractionResult takeServing(Level level, BlockPos pos, BlockState state, Player player, InteractionHand handIn, Item serving) {
        int servings = (Integer)state.getValue((Property)SERVINGS);
        BedPart part = (BedPart)state.getValue(PART);
        BlockPos pairPos = pos.relative(RoastMoaBlock.getDirectionToOther(part, (Direction)state.getValue((Property)FACING)));
        BlockState pairState = level.getBlockState(pairPos);
        ItemStack heldItem = player.getItemInHand(handIn);
        level.setBlock(pairPos, (BlockState)pairState.setValue((Property)SERVINGS, (Comparable)Integer.valueOf(servings - 1)), 3);
        level.setBlock(pos, (BlockState)state.setValue((Property)SERVINGS, (Comparable)Integer.valueOf(servings - 1)), 3);
        if (!player.isCreative()) {
            heldItem.shrink(1);
        }
        if (!player.getInventory().add(new ItemStack((ItemLike)serving))) {
            player.drop(new ItemStack((ItemLike)serving), false);
        }
        level.playSound(null, pos, (SoundEvent)SoundEvents.ARMOR_EQUIP_GENERIC.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
        return ItemInteractionResult.SUCCESS;
    }
}

