/*
 * Decompiled with CFR 0.152.
 */
package net.zjjohn121110.aethersdelight.datagen;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.zjjohn121110.aethersdelight.datagen.generators.ADBlockTagGenerator;
import net.zjjohn121110.aethersdelight.datagen.generators.ADDatapackGenerator;
import net.zjjohn121110.aethersdelight.datagen.generators.ADItemTagGenerator;
import net.zjjohn121110.aethersdelight.datagen.generators.ADRecipeGenerator;
import net.zjjohn121110.aethersdelight.datagen.providers.ADBlockStateProvider;
import net.zjjohn121110.aethersdelight.datagen.providers.ADItemModelProvider;
import net.zjjohn121110.aethersdelight.datagen.providers.loot.ADBlockLoot;

@EventBusSubscriber(modid="aethersdelight", bus=EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new ADRecipeGenerator(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(ADBlockLoot::new, LootContextParamSets.BLOCK)), lookupProvider));
        generator.addProvider(event.includeClient(), (DataProvider)new ADBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ADItemModelProvider(packOutput, existingFileHelper));
        ADBlockTagGenerator blockTagsProvider = new ADBlockTagGenerator(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new ADItemTagGenerator(packOutput, lookupProvider, blockTagsProvider.contentsGetter(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ADDatapackGenerator(packOutput, lookupProvider));
    }
}

