/*
 * Decompiled with CFR 0.152.
 */
package net.zjjohn121110.aethersdelight.datagen.providers;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.zjjohn121110.aethersdelight.registry.AethersDelightBlocks;
import vectorwing.farmersdelight.common.block.CabinetBlock;

public class ADBlockStateProvider
extends BlockStateProvider {
    public ADBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "aethersdelight", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.blockWithItem(AethersDelightBlocks.ARKENIUM_BLOCK);
        this.blockWithItem(AethersDelightBlocks.RAW_ARKENIUM_BLOCK);
        this.blockWithItem(AethersDelightBlocks.ARKENIUM_ORE);
        this.wildCropBlock((Block)AethersDelightBlocks.WILD_GINGER.get());
        this.wildCropBlock((Block)AethersDelightBlocks.WILD_PARSNIP.get());
        this.wildCropBlock((Block)AethersDelightBlocks.WILD_LEEK.get());
        this.cabinetBlock((Block)AethersDelightBlocks.SKYROOT_CABINET.get(), "skyroot");
    }

    private String blockName(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
    }

    public ResourceLocation resourceBlock(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"aethersdelight", (String)("block/" + path));
    }

    public void cabinetBlock(Block block, String woodType) {
        this.horizontalBlock(block, state -> {
            String suffix = (Boolean)state.getValue((Property)CabinetBlock.OPEN) != false ? "_open" : "";
            return this.models().orientable(this.blockName(block) + suffix, this.resourceBlock(woodType + "_cabinet_side"), this.resourceBlock(woodType + "_cabinet_front" + suffix), this.resourceBlock(woodType + "_cabinet_top"));
        });
    }

    public void wildCropBlock(Block block) {
        this.wildCropBlock(block, false);
    }

    public void wildCropBlock(Block block, boolean isBushCrop) {
        if (isBushCrop) {
            this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().singleTexture(this.blockName(block), this.resourceBlock("bush_crop"), "crop", this.resourceBlock(this.blockName(block)))).renderType("cutout"));
        } else {
            this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().cross(this.blockName(block), this.resourceBlock(this.blockName(block)))).renderType("cutout"));
        }
    }

    private void blockWithItem(DeferredBlock<?> deferredBlock) {
        this.simpleBlockWithItem((Block)deferredBlock.get(), this.cubeAll((Block)deferredBlock.get()));
    }
}

