/*
 * Decompiled with CFR 0.152.
 */
package com.nurogt.mob_repellent;

import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final Config CONFIG;
    public static final ModConfigSpec CONFIG_SPEC;
    public final ModConfigSpec.ConfigValue<Integer> WoodenBrazierRange;
    public final ModConfigSpec.ConfigValue<Integer> WoodenBrazierExtinguishChance;
    public final ModConfigSpec.ConfigValue<Integer> StoneBrazierRange;
    public final ModConfigSpec.ConfigValue<Integer> StoneBrazierExtinguishChance;
    public final ModConfigSpec.ConfigValue<Integer> TerracottaBrazierRange;
    public final ModConfigSpec.ConfigValue<Boolean> PreventSpawners;

    private Config(ModConfigSpec.Builder builder) {
        this.WoodenBrazierRange = builder.comment("").comment(" Defines the spherical range of action in blocks of the Wooden Brazier.").defineInRange("wooden_brazier_range", 20, 0, Integer.MAX_VALUE);
        this.WoodenBrazierExtinguishChance = builder.comment("").comment(" Defines the chance that the Wooden Brazier will extinguish itself after successfully preventing a mob from spawning.").comment(" Disabled: 0").defineInRange("wooden_brazier_extinguish_chance", 256, 0, Integer.MAX_VALUE);
        this.StoneBrazierRange = builder.comment("").comment(" Defines the spherical range of action in blocks of the Stone Brazier.").defineInRange("stone_brazier_range", 40, 0, Integer.MAX_VALUE);
        this.StoneBrazierExtinguishChance = builder.comment("").comment(" Defines the chance that the Stone Brazier will extinguish itself after successfully preventing a mob from spawning.").comment(" Disabled: 0").defineInRange("stone_brazier_extinguish_chance", 1024, 0, Integer.MAX_VALUE);
        this.TerracottaBrazierRange = builder.comment("").comment(" Defines the spherical range of action in blocks of the Terracotta Brazier.").defineInRange("terracotta_brazier_range", 60, 0, Integer.MAX_VALUE);
        this.PreventSpawners = builder.comment("").comment(" Defines if the braziers should also prevent spawners from spawning mobs.").define("prevent_spawners", false);
    }

    static {
        Pair pair = new ModConfigSpec.Builder().configure(Config::new);
        CONFIG = (Config)pair.getLeft();
        CONFIG_SPEC = (ModConfigSpec)pair.getRight();
    }
}

