/*
 * Decompiled with CFR 0.152.
 */
package com.nurogt.mob_repellent;

import com.mojang.logging.LogUtils;
import com.nurogt.mob_repellent.Client;
import com.nurogt.mob_repellent.Config;
import com.nurogt.mob_repellent.ConfigSyncPacket;
import com.nurogt.mob_repellent.blocks.StoneBrazierBlock;
import com.nurogt.mob_repellent.blocks.TerracottaBrazierBlock;
import com.nurogt.mob_repellent.blocks.WoodenBrazierBlock;
import java.util.function.ToIntFunction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;

@Mod(value="mob_repellent")
public class Main {
    public static final String MODID = "mob_repellent";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"mob_repellent");
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"mob_repellent");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"mob_repellent");
    public static int TerracottaBrazierRadius = 0;
    public static int StoneBrazierRadius = 0;
    public static int StoneBrazierMaxRandomInt = 0;
    public static int WoodenBrazierRadius = 0;
    public static int WoodenBrazierMaxRandomInt = 0;
    public static boolean PreventSpawners = false;
    public static final DeferredBlock<Block> WOODEN_BRAZIER_BLOCK = BLOCKS.register("wooden_brazier", () -> new WoodenBrazierBlock(BlockBehaviour.Properties.of().destroyTime(2.0f).explosionResistance(10.0f).sound(SoundType.WOOD).dynamicShape().noOcclusion().lightLevel(Main.litBlockEmission("wooden")).forceSolidOn().pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> STONE_BRAZIER_BLOCK = BLOCKS.register("stone_brazier", () -> new StoneBrazierBlock(BlockBehaviour.Properties.of().destroyTime(2.0f).explosionResistance(10.0f).sound(SoundType.STONE).dynamicShape().noOcclusion().lightLevel(Main.litBlockEmission("stone")).forceSolidOn().pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> TERRACOTTA_BRAZIER_BLOCK = BLOCKS.register("terracotta_brazier", () -> new TerracottaBrazierBlock(BlockBehaviour.Properties.of().destroyTime(2.0f).explosionResistance(10.0f).sound(SoundType.DECORATED_POT).dynamicShape().noOcclusion().lightLevel(Main.litBlockEmission("terracotta")).forceSolidOn().pushReaction(PushReaction.DESTROY)));
    public static final DeferredItem<BlockItem> WOODEN_BRAZIER_ITEM = ITEMS.registerSimpleBlockItem("wooden_brazier", WOODEN_BRAZIER_BLOCK);
    public static final DeferredItem<BlockItem> STONE_BRAZIER_ITEM = ITEMS.registerSimpleBlockItem("stone_brazier", STONE_BRAZIER_BLOCK);
    public static final DeferredItem<BlockItem> TERRACOTTA_BRAZIER_ITEM = ITEMS.registerSimpleBlockItem("terracotta_brazier", TERRACOTTA_BRAZIER_BLOCK);
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> MOB_REPELLENT_TAB = CREATIVE_MODE_TABS.register("mob_repellent_tab", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.mob_repellent")).withTabsBefore(new ResourceKey[]{CreativeModeTabs.COMBAT}).icon(() -> ((BlockItem)TERRACOTTA_BRAZIER_ITEM.get()).getDefaultInstance()).displayItems((parameters, output) -> {
        output.accept((ItemLike)WOODEN_BRAZIER_ITEM.get());
        output.accept((ItemLike)STONE_BRAZIER_ITEM.get());
        output.accept((ItemLike)TERRACOTTA_BRAZIER_ITEM.get());
    }).build());

    private static ToIntFunction<BlockState> litBlockEmission(String block) {
        return switch (block) {
            case "wooden" -> state -> (Boolean)state.getValue((Property)WoodenBrazierBlock.LITWooden) != false ? 4 : 0;
            case "stone" -> state -> (Boolean)state.getValue((Property)StoneBrazierBlock.LITStone) != false ? 6 : 0;
            case "terracotta" -> state -> (Boolean)state.getValue((Property)TerracottaBrazierBlock.LIT) != false ? 8 : 0;
            default -> throw new IllegalStateException("Unexpected value: " + block);
        };
    }

    public Main(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::register);
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.CONFIG_SPEC);
        NeoForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        TerracottaBrazierRadius = (Integer)Config.CONFIG.TerracottaBrazierRange.get();
        StoneBrazierRadius = (Integer)Config.CONFIG.StoneBrazierRange.get();
        StoneBrazierMaxRandomInt = (Integer)Config.CONFIG.StoneBrazierExtinguishChance.get();
        WoodenBrazierRadius = (Integer)Config.CONFIG.WoodenBrazierRange.get();
        WoodenBrazierMaxRandomInt = (Integer)Config.CONFIG.WoodenBrazierExtinguishChance.get();
        PreventSpawners = (Boolean)Config.CONFIG.PreventSpawners.get();
    }

    public void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.commonToClient(ConfigSyncPacket.CONFIG_SYNC_PACKET_TYPE, ConfigSyncPacket.STREAM_CODEC, Client::receiveConfigSyncPacket);
    }

    @SubscribeEvent
    public void sendConfigToClient(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new ConfigSyncPacket(TerracottaBrazierRadius, StoneBrazierRadius, WoodenBrazierRadius), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

