/*
 * Decompiled with CFR 0.152.
 */
package com.nurogt.mob_repellent.blocks;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class SaveData
extends SavedData {
    private static SaveData clientInstance;
    private final Set<BlockPos> woodenBrazierLocations = new HashSet<BlockPos>();
    private final Set<BlockPos> stoneBrazierLocations = new HashSet<BlockPos>();
    private final Set<BlockPos> terracottaBrazierLocations = new HashSet<BlockPos>();

    public void addBrazierBlockPos(BlockPos pos, String type) {
        if (type.equals("wooden")) {
            this.woodenBrazierLocations.add(pos);
        }
        if (type.equals("stone")) {
            this.stoneBrazierLocations.add(pos);
        }
        if (type.equals("terracotta")) {
            this.terracottaBrazierLocations.add(pos);
        }
        this.setDirty();
    }

    public void removeBrazierBlockPos(BlockPos pos, String type) {
        if (type.equals("wooden")) {
            this.woodenBrazierLocations.remove(pos);
        }
        if (type.equals("stone")) {
            this.stoneBrazierLocations.remove(pos);
        }
        if (type.equals("terracotta")) {
            this.terracottaBrazierLocations.remove(pos);
        }
        this.setDirty();
    }

    public Set<BlockPos> getBrazierLocations(String type) {
        return switch (type) {
            case "wooden" -> this.woodenBrazierLocations;
            case "stone" -> this.stoneBrazierLocations;
            case "terracotta" -> this.terracottaBrazierLocations;
            default -> null;
        };
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider pRegistries) {
        CompoundTag posTag;
        CompoundTag BrazierLists = new CompoundTag();
        ListTag WoodenBrazierList = new ListTag();
        ListTag StoneBrazierList = new ListTag();
        ListTag TerracottaBrazierList = new ListTag();
        for (BlockPos pos : this.woodenBrazierLocations) {
            posTag = new CompoundTag();
            posTag.putInt("x", pos.getX());
            posTag.putInt("y", pos.getY());
            posTag.putInt("z", pos.getZ());
            WoodenBrazierList.add((Object)posTag);
        }
        for (BlockPos pos : this.stoneBrazierLocations) {
            posTag = new CompoundTag();
            posTag.putInt("x", pos.getX());
            posTag.putInt("y", pos.getY());
            posTag.putInt("z", pos.getZ());
            StoneBrazierList.add((Object)posTag);
        }
        for (BlockPos pos : this.terracottaBrazierLocations) {
            posTag = new CompoundTag();
            posTag.putInt("x", pos.getX());
            posTag.putInt("y", pos.getY());
            posTag.putInt("z", pos.getZ());
            TerracottaBrazierList.add((Object)posTag);
        }
        BrazierLists.put("Wooden_Brazier_Locations", (Tag)WoodenBrazierList);
        BrazierLists.put("Stone_Brazier_Locations", (Tag)StoneBrazierList);
        BrazierLists.put("Terracotta_Brazier_Locations", (Tag)TerracottaBrazierList);
        tag.put("Brazier_Locations", (Tag)BrazierLists);
        return tag;
    }

    public static SaveData get(Level level) {
        if (level.isClientSide()) {
            return clientInstance;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        return (SaveData)serverLevel.getDataStorage().computeIfAbsent(new SavedData.Factory(SaveData::new, SaveData::load, DataFixTypes.LEVEL), "Mob-Repellent");
    }

    private static SaveData load(CompoundTag tag, HolderLookup.Provider pRegistries) {
        int z;
        int y;
        int x;
        CompoundTag posTag;
        int i;
        SaveData locs = new SaveData();
        CompoundTag BrazierLists = tag.getCompound("Brazier_Locations");
        ListTag WoodenBrazierList = BrazierLists.getList("Wooden_Brazier_Locations", 10);
        ListTag StoneBrazierList = BrazierLists.getList("Stone_Brazier_Locations", 10);
        ListTag TerracottaBrazierList = BrazierLists.getList("Terracotta_Brazier_Locations", 10);
        for (i = 0; i < WoodenBrazierList.size(); ++i) {
            posTag = WoodenBrazierList.getCompound(i);
            x = posTag.getInt("x");
            y = posTag.getInt("y");
            z = posTag.getInt("z");
            locs.woodenBrazierLocations.add(new BlockPos(x, y, z));
        }
        for (i = 0; i < StoneBrazierList.size(); ++i) {
            posTag = StoneBrazierList.getCompound(i);
            x = posTag.getInt("x");
            y = posTag.getInt("y");
            z = posTag.getInt("z");
            locs.stoneBrazierLocations.add(new BlockPos(x, y, z));
        }
        for (i = 0; i < TerracottaBrazierList.size(); ++i) {
            posTag = TerracottaBrazierList.getCompound(i);
            x = posTag.getInt("x");
            y = posTag.getInt("y");
            z = posTag.getInt("z");
            locs.terracottaBrazierLocations.add(new BlockPos(x, y, z));
        }
        return locs;
    }
}

