/*
 * Decompiled with CFR 0.152.
 */
package com.nurogt.mob_repellent.blocks;

import com.nurogt.mob_repellent.Main;
import com.nurogt.mob_repellent.blocks.SaveData;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class WoodenBrazierBlock
extends Block {
    public static final BooleanProperty LITWooden = BooleanProperty.create((String)"lit");
    private static final VoxelShape SHAPE = WoodenBrazierBlock.makeShape();

    public WoodenBrazierBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LITWooden, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext ctx) {
        return SHAPE;
    }

    public static VoxelShape makeShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.3125, (double)0.0625, (double)0.3125, (double)0.375, (double)0.375, (double)0.625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.3125, (double)0.0625, (double)0.625, (double)0.625, (double)0.375, (double)0.6875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.0625, (double)0.3125, (double)0.6875, (double)0.375, (double)0.375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.0625, (double)0.75), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.625, (double)0.0625, (double)0.375, (double)0.6875, (double)0.375, (double)0.6875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.0625, (double)0.375, (double)0.625, (double)0.3125, (double)0.625), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{LITWooden});
    }

    public void appendHoverText(@NotNull ItemStack pStack, @NotNull Item.TooltipContext pContext, List<Component> pTooltipComponents, @NotNull TooltipFlag pTooltipFlag) {
        pTooltipComponents.add((Component)Component.translatable((String)"tooltip.mob_repellent.wooden_brazier.line1"));
        String line2 = Component.translatable((String)"tooltip.mob_repellent.wooden_brazier.line2").getString().replace("%RADIUS%", String.valueOf(Main.WoodenBrazierRadius));
        pTooltipComponents.add((Component)Component.literal((String)line2));
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack pStack, BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHitResult) {
        Item pItem = pPlayer.getItemInHand(pHand).getItem();
        if (!((Boolean)pState.getValue((Property)LITWooden)).booleanValue() && pHand == InteractionHand.MAIN_HAND && (pItem.equals(Items.FLINT_AND_STEEL) || pItem.equals(Items.FIRE_CHARGE))) {
            SaveData locs;
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)LITWooden, (Comparable)Boolean.TRUE), 3);
            if (pItem.equals(Items.FLINT_AND_STEEL)) {
                pPlayer.getItemInHand(pHand).hurtAndBreak(1, (LivingEntity)pPlayer, EquipmentSlot.MAINHAND);
            } else {
                pPlayer.getItemInHand(pHand).consume(1, (LivingEntity)pPlayer);
            }
            pLevel.playSound(pPlayer, pPos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS);
            if (!pLevel.isClientSide() && pLevel instanceof ServerLevel && (locs = SaveData.get(pLevel)) != null) {
                locs.addBrazierBlockPos(pPos, "wooden");
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (((Boolean)pState.getValue((Property)LITWooden)).booleanValue() && pHand == InteractionHand.MAIN_HAND && pPlayer.getItemInHand(pHand).getItem().equals(Items.WATER_BUCKET)) {
            SaveData locs;
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)LITWooden, (Comparable)Boolean.FALSE), 3);
            if (!pPlayer.isCreative()) {
                pPlayer.setItemInHand(pHand, new ItemStack((ItemLike)Items.BUCKET));
            }
            pLevel.playSound(pPlayer, pPos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS);
            if (!pLevel.isClientSide() && pLevel instanceof ServerLevel && (locs = SaveData.get(pLevel)) != null) {
                locs.removeBrazierBlockPos(pPos, "wooden");
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(pStack, pState, pLevel, pPos, pPlayer, pHand, pHitResult);
    }

    protected void onRemove(@NotNull BlockState pState, Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pNewState, boolean pMovedByPiston) {
        SaveData locs;
        if (!pLevel.isClientSide() && pLevel instanceof ServerLevel && (locs = SaveData.get(pLevel)) != null) {
            locs.removeBrazierBlockPos(pPos, "wooden");
        }
        super.onRemove(pState, pLevel, pPos, pNewState, pMovedByPiston);
    }

    public void animateTick(BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull RandomSource pRandom) {
        if (((Boolean)pState.getValue((Property)LITWooden)).booleanValue()) {
            if (pRandom.nextInt(10) == 0) {
                pLevel.playLocalSound((double)pPos.getX() + 0.5, (double)pPos.getY() + 0.5, (double)pPos.getZ() + 0.5, SoundEvents.CAMPFIRE_CRACKLE, SoundSource.BLOCKS, 0.5f + pRandom.nextFloat(), pRandom.nextFloat() * 0.7f + 0.6f, false);
            }
            if (pRandom.nextInt(12) == 0) {
                for (int i = 0; i < pRandom.nextInt(1) + 1; ++i) {
                    pLevel.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)pPos.getX() + 0.5 + (double)pRandom.nextIntBetweenInclusive(0, 5) / 100.0, (double)pPos.getY() + 0.4, (double)pPos.getZ() + 0.5 + (double)pRandom.nextIntBetweenInclusive(0, 5) / 100.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public void stepOn(@NotNull Level pLevel, @NotNull BlockPos pPos, BlockState pState, @NotNull Entity pEntity) {
        if (((Boolean)pState.getValue((Property)LITWooden)).booleanValue() && !pEntity.isSteppingCarefully() && pEntity instanceof LivingEntity) {
            pEntity.hurt(pLevel.damageSources().hotFloor(), 1.0f);
        }
        super.stepOn(pLevel, pPos, pState, pEntity);
    }
}

