/*
 * Decompiled with CFR 0.152.
 */
package com.nurogt.mob_repellent;

import com.mojang.logging.LogUtils;
import com.nurogt.mob_repellent.Main;
import com.nurogt.mob_repellent.blocks.SaveData;
import com.nurogt.mob_repellent.blocks.StoneBrazierBlock;
import com.nurogt.mob_repellent.blocks.WoodenBrazierBlock;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.MobSpawnEvent;
import org.slf4j.Logger;

@Mod(value="mob_repellent")
public class MobSpawn {
    private static final Logger LOGGER = LogUtils.getLogger();

    public MobSpawn(IEventBus modBus) {
        NeoForge.EVENT_BUS.addListener(MobSpawn::onMobSpawn);
    }

    @SubscribeEvent
    public static void onMobSpawn(MobSpawnEvent.SpawnPlacementCheck event) {
        MobCategory eType = event.getEntityType().getCategory();
        ServerLevel level = event.getLevel().getLevel();
        if (eType == MobCategory.MONSTER) {
            BlockPos spawnPos = new BlockPos(event.getPos().getX(), event.getPos().getY(), event.getPos().getZ());
            SaveData locs = SaveData.get((Level)event.getLevel().getLevel());
            if (locs != null) {
                String CheckSpawnResult;
                BlockState state;
                for (BlockPos pos : locs.getBrazierLocations("terracotta")) {
                    String CheckSpawnResult2 = MobSpawn.CheckSpawn(Main.TerracottaBrazierRadius, pos, spawnPos);
                    if (!Objects.equals(CheckSpawnResult2, "fail")) continue;
                    event.setResult(MobSpawnEvent.SpawnPlacementCheck.Result.FAIL);
                    return;
                }
                for (BlockPos pos : locs.getBrazierLocations("stone")) {
                    state = level.getBlockState(pos);
                    CheckSpawnResult = MobSpawn.CheckSpawn(Main.StoneBrazierRadius, pos, spawnPos);
                    if (!Objects.equals(CheckSpawnResult, "fail")) continue;
                    event.setResult(MobSpawnEvent.SpawnPlacementCheck.Result.FAIL);
                    if (Main.StoneBrazierMaxRandomInt == 0) {
                        return;
                    }
                    int RandomInt = level.getRandom().nextIntBetweenInclusive(1, Main.StoneBrazierMaxRandomInt);
                    if (RandomInt == 1) {
                        MobSpawn.ExtinguishBrazier((Level)level, pos, state, "stone");
                    }
                    return;
                }
                for (BlockPos pos : locs.getBrazierLocations("wooden")) {
                    state = level.getBlockState(pos);
                    CheckSpawnResult = MobSpawn.CheckSpawn(Main.WoodenBrazierRadius, pos, spawnPos);
                    if (!Objects.equals(CheckSpawnResult, "fail")) continue;
                    event.setResult(MobSpawnEvent.SpawnPlacementCheck.Result.FAIL);
                    if (Main.WoodenBrazierMaxRandomInt == 0) {
                        return;
                    }
                    int RandomInt = level.getRandom().nextIntBetweenInclusive(1, Main.WoodenBrazierMaxRandomInt);
                    if (RandomInt == 1) {
                        MobSpawn.ExtinguishBrazier((Level)level, pos, state, "wooden");
                    }
                    return;
                }
            }
        }
    }

    public static String CheckSpawn(int currentRadius, BlockPos pos, BlockPos spawnPos) {
        int radiusSquared = currentRadius * currentRadius;
        int distX = pos.getX() - spawnPos.getX();
        int distY = pos.getY() - spawnPos.getY();
        int distZ = pos.getZ() - spawnPos.getZ();
        if (Math.abs(distX) > currentRadius || Math.abs(distY) > currentRadius || Math.abs(distZ) > currentRadius) {
            return "continue";
        }
        int totalDistSquared = distX * distX + distY * distY + distZ * distZ;
        if (totalDistSquared <= radiusSquared) {
            return "fail";
        }
        return null;
    }

    public static void ExtinguishBrazier(Level level, BlockPos pos, BlockState state, String type) {
        SaveData locs;
        if (!level.isClientSide() && level instanceof ServerLevel && (locs = SaveData.get(level)) != null) {
            if (type.equals("wooden")) {
                locs.removeBrazierBlockPos(pos, "wooden");
            }
            if (type.equals("stone")) {
                locs.removeBrazierBlockPos(pos, "stone");
            }
        }
        if (type.equals("wooden")) {
            level.setBlock(pos, (BlockState)state.setValue((Property)WoodenBrazierBlock.LITWooden, (Comparable)Boolean.FALSE), 3);
        }
        if (type.equals("stone")) {
            level.setBlock(pos, (BlockState)state.setValue((Property)StoneBrazierBlock.LITStone, (Comparable)Boolean.FALSE), 3);
        }
        AABB area = new AABB((double)(pos.getX() - 20), (double)(pos.getY() - 20), (double)(pos.getZ() - 20), (double)(pos.getX() + 20), (double)(pos.getY() + 20), (double)(pos.getZ() + 20));
        List entities = level.getEntitiesOfClass(ServerPlayer.class, area, p -> true);
        for (ServerPlayer player : entities) {
            level.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 2.0f, 1.0f);
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles(player, (ParticleOptions)ParticleTypes.LARGE_SMOKE, false, (double)pos.getX() + (double)level.getRandom().nextIntBetweenInclusive(42, 58) / 100.0, (double)pos.getY() + 0.5, (double)pos.getZ() + (double)level.getRandom().nextIntBetweenInclusive(42, 58) / 100.0, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

