/*
 * Decompiled with CFR 0.152.
 */
package com.nurogt.mob_repellent;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class Config {
    private static final String FILE_NAME = "mob-repellent-server.toml";
    public static CommentedFileConfig config;

    public Config(Path worldDir) {
        Path serverConfigDir = worldDir.resolve("serverconfig");
        try {
            Files.createDirectories(serverConfigDir, new FileAttribute[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create folder 'serverconfig'", e);
        }
        Path configPath = serverConfigDir.resolve(FILE_NAME);
        File configFile = new File(String.valueOf(configPath));
        if (configFile.exists()) {
            config = CommentedFileConfig.of((File)configFile);
            config.load();
        } else {
            config = (CommentedFileConfig)CommentedFileConfig.builder((Path)configPath).autosave().sync().preserveInsertionOrder().build();
            String wooden_brazier_range_comments = "\n Defines the spherical range of action in blocks of the Wooden Brazier.\n Default: 20\n Range: > 0";
            config.add("wooden_brazier_range", (Object)20);
            config.setComment("wooden_brazier_range", wooden_brazier_range_comments);
            String wooden_brazier_extinguish_chance_comments = "\n Defines the chance that the Wooden Brazier will extinguish itself after successfully preventing a mob from spawning.\n Disabled: 0\n Default: 256\n Range: > 0";
            config.add("wooden_brazier_extinguish_chance", (Object)256);
            config.setComment("wooden_brazier_extinguish_chance", wooden_brazier_extinguish_chance_comments);
            String stone_brazier_range_comments = "\n Defines the spherical range of action in blocks of the Stone Brazier.\n Default: 40\n Range: > 0";
            config.add("stone_brazier_range", (Object)40);
            config.setComment("stone_brazier_range", stone_brazier_range_comments);
            String stone_brazier_extinguish_chance_comments = "\n Defines the chance that the Stone Brazier will extinguish itself after successfully preventing a mob from spawning.\n Disabled: 0\n Default: 1024\n Range: > 0";
            config.add("stone_brazier_extinguish_chance", (Object)1024);
            config.setComment("stone_brazier_extinguish_chance", stone_brazier_extinguish_chance_comments);
            String terracotta_brazier_range_comments = "\n Defines the spherical range of action in blocks of the Terracotta Brazier.\n Default: 60\n Range: > 0";
            config.add("terracotta_brazier_range", (Object)60);
            config.setComment("terracotta_brazier_range", terracotta_brazier_range_comments);
            config.load();
        }
    }

    public void close() {
        config.close();
    }
}

