/*
 * Decompiled with CFR 0.152.
 */
package com.nurogt.mob_repellent;

import com.nurogt.mob_repellent.Blocks;
import com.nurogt.mob_repellent.Config;
import com.nurogt.mob_repellent.ConfigSyncPacket;
import com.nurogt.mob_repellent.MobSpawn;
import java.nio.file.Path;
import java.util.List;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main
implements ModInitializer {
    public static final String MOD_ID = "mob_repellent";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"mob_repellent");
    public static final class_5321<class_1761> MOB_REPELLENT_TAB_KEY = class_5321.method_29179((class_5321)class_7923.field_44687.method_30517(), (class_2960)class_2960.method_60655((String)"mob_repellent", (String)"item_group"));
    public static int TerracottaBrazierRadius = 0;
    public static int StoneBrazierRadius = 0;
    public static int StoneBrazierMaxRandomInt = 0;
    public static int WoodenBrazierRadius = 0;
    public static int WoodenBrazierMaxRandomInt = 0;
    public static final class_1761 MOB_REPELLENT_TAB = FabricItemGroup.builder().method_47320(() -> new class_1799((class_1935)Blocks.TERRACOTTA_BRAZIER_BLOCK.method_8389())).method_47321((class_2561)class_2561.method_43471((String)"itemGroup.mob_repellent")).method_47324();

    public void onInitialize() {
        this.onServerStarted();
        Blocks.initialize();
        class_2378.method_39197((class_2378)class_7923.field_44687, MOB_REPELLENT_TAB_KEY, (Object)MOB_REPELLENT_TAB);
        ItemGroupEvents.modifyEntriesEvent(MOB_REPELLENT_TAB_KEY).register(itemGroup -> {
            itemGroup.method_45421((class_1935)Blocks.WOODEN_BRAZIER_BLOCK.method_8389());
            itemGroup.method_45421((class_1935)Blocks.STONE_BRAZIER_BLOCK.method_8389());
            itemGroup.method_45421((class_1935)Blocks.TERRACOTTA_BRAZIER_BLOCK.method_8389());
        });
        MobSpawn.onMobSpawn();
        PayloadTypeRegistry.playS2C().register(ConfigSyncPacket.ID, ConfigSyncPacket.CODEC);
    }

    public void onServerStarted() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            for (class_3218 world : server.method_3738()) {
                if (world.method_27983() != class_1937.field_25179) continue;
                Path worldDir = server.method_27050(class_5218.field_24188);
                Config config = new Config(worldDir);
                TerracottaBrazierRadius = (Integer)Config.config.get("terracotta_brazier_range");
                StoneBrazierRadius = (Integer)Config.config.get("stone_brazier_range");
                StoneBrazierMaxRandomInt = (Integer)Config.config.get("stone_brazier_extinguish_chance");
                WoodenBrazierRadius = (Integer)Config.config.get("wooden_brazier_range");
                WoodenBrazierMaxRandomInt = (Integer)Config.config.get("wooden_brazier_extinguish_chance");
                if (TerracottaBrazierRadius < 0 || StoneBrazierRadius < 0 || StoneBrazierMaxRandomInt < 0 || WoodenBrazierRadius < 0 || WoodenBrazierMaxRandomInt < 0) {
                    throw new RuntimeException("mob-repellent-server.toml Config values cannot be less than 0.");
                }
                config.close();
            }
            Main.sendConfigToClient();
        });
    }

    public static void sendConfigToClient() {
        List<Integer> braziersRadius = List.of(Integer.valueOf(TerracottaBrazierRadius), Integer.valueOf(StoneBrazierRadius), Integer.valueOf(WoodenBrazierRadius));
        ConfigSyncPacket payload = new ConfigSyncPacket(braziersRadius);
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> ServerPlayNetworking.send((class_3222)handler.field_14140, (class_8710)payload));
    }
}

