/*
 * Decompiled with CFR 0.152.
 */
package com.nurogt.mob_repellent;

import com.nurogt.mob_repellent.Events;
import com.nurogt.mob_repellent.Main;
import com.nurogt.mob_repellent.block.SaveData;
import com.nurogt.mob_repellent.block.StoneBrazierBlock;
import com.nurogt.mob_repellent.block.WoodenBrazierBlock;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1311;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class MobSpawn {
    public static void onMobSpawn() {
        Events.MOB_SPAWN_PLACEMENT.register((type, world, pos, random) -> {
            SaveData locs;
            class_1311 mobCategory = type.method_5891();
            if (mobCategory == class_1311.field_6302 && (locs = SaveData.get((class_1937)world)) != null) {
                String CheckSpawnResult;
                class_2680 state;
                for (class_2338 bPos : locs.getBrazierLocations("terracotta")) {
                    String CheckSpawnResult2 = MobSpawn.CheckSpawn(Main.TerracottaBrazierRadius, bPos, pos);
                    if (!Objects.equals(CheckSpawnResult2, "fail")) continue;
                    return false;
                }
                for (class_2338 bPos : locs.getBrazierLocations("stone")) {
                    state = world.method_8320(bPos);
                    CheckSpawnResult = MobSpawn.CheckSpawn(Main.StoneBrazierRadius, bPos, pos);
                    if (!Objects.equals(CheckSpawnResult, "fail")) continue;
                    if (Main.StoneBrazierMaxRandomInt == 0) {
                        return false;
                    }
                    int RandomInt = random.method_39332(1, Main.StoneBrazierMaxRandomInt);
                    if (RandomInt == 1) {
                        MobSpawn.ExtinguishBrazier(world, bPos, state, "stone");
                    }
                    return false;
                }
                for (class_2338 bPos : locs.getBrazierLocations("wooden")) {
                    state = world.method_8320(bPos);
                    CheckSpawnResult = MobSpawn.CheckSpawn(Main.WoodenBrazierRadius, bPos, pos);
                    if (!Objects.equals(CheckSpawnResult, "fail")) continue;
                    if (Main.WoodenBrazierMaxRandomInt == 0) {
                        return false;
                    }
                    int RandomInt = random.method_39332(1, Main.WoodenBrazierMaxRandomInt);
                    if (RandomInt == 1) {
                        MobSpawn.ExtinguishBrazier(world, bPos, state, "wooden");
                    }
                    return false;
                }
            }
            return null;
        });
    }

    public static String CheckSpawn(int currentRadius, class_2338 pos, class_2338 spawnPos) {
        int radiusSquared = currentRadius * currentRadius;
        int distX = pos.method_10263() - spawnPos.method_10263();
        int distY = pos.method_10264() - spawnPos.method_10264();
        int distZ = pos.method_10260() - spawnPos.method_10260();
        if (Math.abs(distX) > currentRadius || Math.abs(distY) > currentRadius || Math.abs(distZ) > currentRadius) {
            return "continue";
        }
        int totalDistSquared = distX * distX + distY * distY + distZ * distZ;
        if (totalDistSquared <= radiusSquared) {
            return "fail";
        }
        return null;
    }

    public static void ExtinguishBrazier(class_3218 world, class_2338 pos, class_2680 state, String type) {
        SaveData locs = SaveData.get((class_1937)world);
        if (locs != null) {
            if (type.equals("wooden")) {
                locs.removeBrazierBlockPos(pos, "wooden");
            }
            if (type.equals("stone")) {
                locs.removeBrazierBlockPos(pos, "stone");
            }
        }
        if (type.equals("wooden")) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)WoodenBrazierBlock.LITWooden, (Comparable)Boolean.FALSE), 3);
        }
        if (type.equals("stone")) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)StoneBrazierBlock.LITStone, (Comparable)Boolean.FALSE), 3);
        }
        class_238 area = new class_238((double)(pos.method_10263() - 20), (double)(pos.method_10264() - 20), (double)(pos.method_10260() - 20), (double)(pos.method_10263() + 20), (double)(pos.method_10264() + 20), (double)(pos.method_10260() + 20));
        List entities = world.method_8390(class_3222.class, area, p -> true);
        for (class_3222 player : entities) {
            world.method_43128(null, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, class_3417.field_15102, class_3419.field_15245, 2.0f, 1.0f);
            if (!(world instanceof class_3218)) continue;
            class_3218 serverWorld = world;
            serverWorld.method_14166(player, (class_2394)class_2398.field_11237, false, (double)pos.method_10263() + (double)world.method_8409().method_39332(42, 58) / 100.0, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + (double)world.method_8409().method_39332(42, 58) / 100.0, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

