/*
 * Decompiled with CFR 0.152.
 */
package eclipse.euphoriacompanion;

import eclipse.euphoriacompanion.analyzer.ShaderpackAnalysisInitiator;
import eclipse.euphoriacompanion.config.ModConfig;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EuphoriaCompanion
implements ModInitializer {
    public static final String MODID = "EuphoriaCompanion";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"EuphoriaCompanion");
    public static class_304 ANALYZE_KEY;
    private static long lastAnalysisTime;
    private static final long COOLDOWN_MS = 2000L;

    public static void processShaderPacks() {
        long currentTime = System.currentTimeMillis();
        long timeSinceLastAnalysis = currentTime - lastAnalysisTime;
        if (timeSinceLastAnalysis < 2000L) {
            long remainingCooldown = (2000L - timeSinceLastAnalysis) / 1000L;
            LOGGER.info("Analysis on cooldown, please wait {} seconds", (Object)(remainingCooldown + 1L));
            return;
        }
        lastAnalysisTime = currentTime;
        Thread analysisThread = new Thread(() -> {
            try {
                ShaderpackAnalysisInitiator.processAllShaderpacks();
            }
            catch (Exception e) {
                LOGGER.error("Error in shader analysis thread", (Throwable)e);
            }
        }, "EuphoriaCompanion-Analysis");
        analysisThread.setDaemon(true);
        analysisThread.start();
    }

    public void onInitialize() {
        LOGGER.info("Initializing Euphoria Companion");
        ModConfig config = ModConfig.getInstance();
        LOGGER.info("Tag support: {}", (Object)(config.isTagSupportEnabled() ? "enabled" : "disabled"));
        try {
            ANALYZE_KEY = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.euphoriacompanion.analyze", class_3675.class_307.field_1668, 295, class_304.class_11900.method_74698((class_2960)class_2960.method_60655((String)"euphoriacompanion", (String)"keys"))));
        }
        catch (Exception e) {
            LOGGER.error("Failed to register keybinding", (Throwable)e);
        }
    }

    static {
        lastAnalysisTime = 0L;
    }
}

