/*
 * Decompiled with CFR 0.152.
 */
package eclipse.euphoriacompanion.analyzer;

import eclipse.euphoriacompanion.EuphoriaCompanion;
import eclipse.euphoriacompanion.analyzer.BlockStateValidator;
import eclipse.euphoriacompanion.config.ModConfig;
import eclipse.euphoriacompanion.parser.BlockPropertiesParser;
import eclipse.euphoriacompanion.report.AnalysisReport;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.class_11515;
import net.minecraft.class_2248;
import net.minecraft.class_2343;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4696;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;

public record ShaderAnalyzer(ModConfig config, int currentMCVersion) {
    public AnalysisReport analyze(Path shaderpackPath) throws IOException {
        String shaderpackName = shaderpackPath.getFileName().toString();
        EuphoriaCompanion.LOGGER.info("Processing: {}", (Object)shaderpackName);
        BlockPropertiesParser parser = this.parseBlockProperties(shaderpackPath);
        if (parser == null) {
            EuphoriaCompanion.LOGGER.warn("No block.properties found in {}", (Object)shaderpackName);
            return new AnalysisReport(shaderpackName);
        }
        Map<String, Set<String>> tagToBlocks = this.resolveTagsToBlocks(parser);
        Map<String, Map<String, List<String>>> missingBlocksByMod = this.categorizeMissingBlocks(parser, tagToBlocks);
        Map<String, Map<String, List<String>>> incompleteBlockStates = BlockStateValidator.validateBlockStates(parser.getBlockToProperty());
        Map<String, RenderLayerMismatch> renderLayerMismatches = this.validateRenderLayers(parser);
        Map<String, List<Integer>> duplicateDefinitions = parser.getDuplicateBlocks();
        int totalBlocksInGame = this.calculateTotalBlocksInGame();
        int totalBlocksInShader = this.calculateTotalBlocksInShader(parser.getBlockToProperty(), tagToBlocks, parser.getTagToProperty());
        AnalysisReport report = new AnalysisReport(shaderpackName);
        report.setMissingBlocksByMod(missingBlocksByMod);
        report.setTagCoverage(tagToBlocks);
        report.setTagDefinitions(parser.getTagDefinitions());
        report.setTagToProperty(parser.getTagToProperty());
        report.setRenderLayerMismatches(renderLayerMismatches);
        report.setIncompleteBlockStates(incompleteBlockStates);
        report.setDuplicateDefinitions(duplicateDefinitions);
        report.setTotalBlocksInGame(totalBlocksInGame);
        report.setTotalBlocksInShader(totalBlocksInShader);
        report.setTagSupportEnabled(this.config.isTagSupportEnabled());
        EuphoriaCompanion.LOGGER.info("Analysis complete for {}", (Object)shaderpackName);
        return report;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BlockPropertiesParser parseBlockProperties(Path shaderpackPath) throws IOException {
        Path propertiesFile = null;
        Path tempFile = null;
        if (Files.isDirectory(shaderpackPath, new LinkOption[0])) {
            propertiesFile = shaderpackPath.resolve("shaders/block.properties");
            if (!Files.exists(propertiesFile, new LinkOption[0])) {
                return null;
            }
        } else if (shaderpackPath.toString().toLowerCase().endsWith(".zip")) {
            if (!this.isValidZipFile(shaderpackPath)) {
                EuphoriaCompanion.LOGGER.warn("File is not a valid ZIP: {}", (Object)shaderpackPath.getFileName());
                return null;
            }
            try (FileSystem zipFs = FileSystems.newFileSystem(shaderpackPath, (ClassLoader)null);){
                Path zipPropertiesFile = zipFs.getPath("/shaders/block.properties", new String[0]);
                if (!Files.exists(zipPropertiesFile, new LinkOption[0])) {
                    BlockPropertiesParser blockPropertiesParser = null;
                    return blockPropertiesParser;
                }
                tempFile = Files.createTempFile("block", ".properties", new FileAttribute[0]);
                try {
                    Files.copy(zipPropertiesFile, tempFile, StandardCopyOption.REPLACE_EXISTING);
                    propertiesFile = tempFile;
                }
                catch (IOException e) {
                    Files.deleteIfExists(tempFile);
                    throw e;
                }
            }
            catch (Exception e) {
                if (tempFile == null) throw e;
                try {
                    Files.deleteIfExists(tempFile);
                    throw e;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw e;
            }
        }
        if (propertiesFile == null) {
            return null;
        }
        try {
            BlockPropertiesParser parser = new BlockPropertiesParser(this.config, this.currentMCVersion);
            parser.parse(propertiesFile);
            if (tempFile == null) return parser;
            Files.deleteIfExists(propertiesFile);
            return parser;
        }
        catch (Exception e) {
            if (tempFile == null) throw e;
            try {
                Files.deleteIfExists(tempFile);
                throw e;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    private Map<String, Set<String>> resolveTagsToBlocks(BlockPropertiesParser parser) {
        LinkedHashMap<String, Set<String>> tagToBlocks = new LinkedHashMap<String, Set<String>>();
        if (!this.config.isTagSupportEnabled()) {
            return tagToBlocks;
        }
        Map<String, String> tagDefinitions = parser.getTagDefinitions();
        Map<String, Integer> blockToProperty = parser.getBlockToProperty();
        Map<String, Integer> tagToProperty = parser.getTagToProperty();
        HashSet<String> directlyDefinedBlocks = new HashSet<String>();
        for (String fullId : blockToProperty.keySet()) {
            BlockStateValidator.BlockStateSpec spec = BlockStateValidator.parseBlockState(fullId);
            if (spec != null) {
                directlyDefinedBlocks.add(spec.blockId());
                continue;
            }
            directlyDefinedBlocks.add(fullId);
        }
        HashSet<String> alreadyClaimedBlocks = new HashSet<String>(directlyDefinedBlocks);
        for (Map.Entry<String, Integer> entry : tagToProperty.entrySet()) {
            String identifier = entry.getKey();
            String value = tagDefinitions.get(identifier);
            if (value == null) {
                EuphoriaCompanion.LOGGER.warn("Tag {} assigned to property but not defined", (Object)identifier);
                continue;
            }
            Set<String> blocks = this.resolveTagReferences(value);
            blocks.removeAll(alreadyClaimedBlocks);
            if (!blocks.isEmpty()) {
                tagToBlocks.put(identifier, blocks);
                alreadyClaimedBlocks.addAll(blocks);
                EuphoriaCompanion.LOGGER.debug("Resolved tag {} ({}) to {} blocks (after filtering already claimed)", new Object[]{identifier, value, blocks.size()});
                continue;
            }
            EuphoriaCompanion.LOGGER.debug("Tag {} ({}) fully covered by earlier definitions, skipping", (Object)identifier, (Object)value);
        }
        return tagToBlocks;
    }

    private Set<String> resolveTagReferences(String tagReferences) {
        String[] refs;
        HashSet<String> allBlocks = new HashSet<String>();
        for (String ref : refs = tagReferences.trim().split("\\s+")) {
            if ((ref = ref.trim()).isEmpty()) continue;
            if (!ref.startsWith("%")) {
                EuphoriaCompanion.LOGGER.warn("Tag reference doesn't start with %: {}", (Object)ref);
                continue;
            }
            Object tagName = ref.substring(1);
            if (!((String)tagName).contains(":")) {
                tagName = "minecraft:" + (String)tagName;
            }
            Set<String> blocks = this.resolveSingleTag((String)tagName);
            allBlocks.addAll(blocks);
        }
        return allBlocks;
    }

    private Set<String> resolveSingleTag(String tagName) {
        HashSet<String> blocks = new HashSet<String>();
        try {
            String[] parts = tagName.split(":", 2);
            if (parts.length != 2) {
                EuphoriaCompanion.LOGGER.warn("Invalid tag name format: {}", (Object)tagName);
                return blocks;
            }
            class_2960 tagId = class_2960.method_60655((String)parts[0], (String)parts[1]);
            class_6862 tagKey = class_6862.method_40092((class_5321)class_7923.field_41175.method_46765(), (class_2960)tagId);
            class_7923.field_41175.method_40286(tagKey).forEach(entry -> {
                class_2248 block = (class_2248)entry.comp_349();
                class_2960 blockId = class_7923.field_41175.method_10221((Object)block);
                blocks.add(blockId.toString());
            });
        }
        catch (Exception e) {
            EuphoriaCompanion.LOGGER.error("Failed to resolve tag: {}", (Object)tagName, (Object)e);
        }
        return blocks;
    }

    private Map<String, Map<String, List<String>>> categorizeMissingBlocks(BlockPropertiesParser parser, Map<String, Set<String>> tagToBlocks) {
        EuphoriaCompanion.LOGGER.info("Categorizing blocks using {} scan mode", (Object)(this.config.scanMode == ModConfig.ScanMode.DEEP ? "DEEP" : "QUICK"));
        Map<String, Integer> blockToProperty = parser.getBlockToProperty();
        Map<String, Integer> tagToProperty = parser.getTagToProperty();
        HashSet<String> coveredBlocks = new HashSet<String>();
        for (String string : blockToProperty.keySet()) {
            BlockStateValidator.BlockStateSpec spec = BlockStateValidator.parseBlockState(string);
            if (spec != null) {
                coveredBlocks.add(spec.blockId());
                continue;
            }
            coveredBlocks.add(string);
        }
        for (Map.Entry entry : tagToProperty.entrySet()) {
            String tagIdentifier = (String)entry.getKey();
            if (!tagToBlocks.containsKey(tagIdentifier)) continue;
            coveredBlocks.addAll((Collection)tagToBlocks.get(tagIdentifier));
        }
        TreeMap<String, Map<String, List<String>>> missingByMod = new TreeMap<String, Map<String, List<String>>>();
        for (class_2248 block : class_7923.field_41175) {
            String category;
            class_2960 blockId = class_7923.field_41175.method_10221((Object)block);
            String blockIdStr = blockId.toString();
            if (coveredBlocks.contains(blockIdStr) || (category = this.categorizeBlock(block)) == null) continue;
            String namespace = blockId.method_12836();
            missingByMod.computeIfAbsent(namespace, k -> new TreeMap()).computeIfAbsent(category, k -> new ArrayList()).add(blockIdStr);
        }
        return missingByMod;
    }

    private String categorizeBlock(class_2248 block) {
        if (this.config.scanMode == ModConfig.ScanMode.DEEP) {
            return this.categorizeBlockDeep(block);
        }
        return this.categorizeBlockQuick(block);
    }

    private String categorizeBlockQuick(class_2248 block) {
        class_2680 defaultState = block.method_9564();
        if (this.config.checkBlockEntity && block instanceof class_2343) {
            return "Block Entity";
        }
        if (this.config.checkLightEmitting && defaultState.method_26213() > 0) {
            return "Light Emitting";
        }
        if (this.config.checkTranslucent && this.isTranslucent(defaultState)) {
            return "Translucent";
        }
        if (this.config.checkNonFull && this.isNonFull(defaultState)) {
            return "Non-Full";
        }
        if (this.config.checkFull) {
            return "Full";
        }
        return null;
    }

    private String categorizeBlockDeep(class_2248 block) {
        if (this.config.checkBlockEntity && block instanceof class_2343) {
            return "Block Entity";
        }
        boolean anyLightEmitting = false;
        boolean anyTranslucent = false;
        boolean anyNonFull = false;
        boolean allFull = true;
        for (class_2680 state : block.method_9595().method_11662()) {
            if (this.config.checkLightEmitting && state.method_26213() > 0) {
                anyLightEmitting = true;
            }
            if (this.config.checkTranslucent && this.isTranslucent(state)) {
                anyTranslucent = true;
            }
            if (this.config.checkNonFull && this.isNonFull(state)) {
                anyNonFull = true;
            }
            if (state.method_26216()) continue;
            allFull = false;
        }
        if (this.config.checkLightEmitting && anyLightEmitting) {
            return "Light Emitting";
        }
        if (this.config.checkTranslucent && anyTranslucent) {
            return "Translucent";
        }
        if (this.config.checkNonFull && anyNonFull) {
            return "Non-Full";
        }
        if (this.config.checkFull && allFull) {
            return "Full";
        }
        return null;
    }

    private boolean isTranslucent(class_2680 state) {
        try {
            class_11515 renderLayer = class_4696.method_23679((class_2680)state);
            return renderLayer == class_11515.field_60926 || renderLayer == class_11515.field_60927;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isNonFull(class_2680 state) {
        try {
            return !state.method_26216();
        }
        catch (Exception e) {
            return false;
        }
    }

    private Map<String, RenderLayerMismatch> validateRenderLayers(BlockPropertiesParser parser) {
        HashMap<String, RenderLayerMismatch> mismatches = new HashMap<String, RenderLayerMismatch>();
        if (!this.config.validateRenderLayers) {
            return mismatches;
        }
        Map<String, String> blockToRenderLayer = parser.getBlockToRenderLayer();
        for (Map.Entry<String, String> entry : blockToRenderLayer.entrySet()) {
            String blockId = entry.getKey();
            String expectedLayer = entry.getValue();
            String actualLayer = this.getActualRenderLayer(blockId);
            if (actualLayer == null || expectedLayer.equalsIgnoreCase(actualLayer)) continue;
            mismatches.put(blockId, new RenderLayerMismatch(expectedLayer, actualLayer));
        }
        return mismatches;
    }

    private String getActualRenderLayer(String blockId) {
        try {
            class_2960 id = class_2960.method_12829((String)blockId);
            if (id == null) {
                return null;
            }
            if (!class_7923.field_41175.method_10250(id)) {
                return null;
            }
            class_2248 block = (class_2248)class_7923.field_41175.method_63535(id);
            class_2680 state = block.method_9564();
            if (state == null) {
                EuphoriaCompanion.LOGGER.warn("Block has no default state: {}", (Object)id);
                return null;
            }
            class_11515 renderLayer = class_4696.method_23679((class_2680)state);
            return switch (renderLayer) {
                default -> throw new MatchException(null, null);
                case class_11515.field_60923 -> "solid";
                case class_11515.field_60925 -> "cutout";
                case class_11515.field_60926 -> "translucent";
                case class_11515.field_60927 -> "translucent";
            };
        }
        catch (Exception e) {
            EuphoriaCompanion.LOGGER.error("Failed to get render layer for: {}", (Object)blockId, (Object)e);
            return null;
        }
    }

    private int calculateTotalBlocksInGame() {
        return class_7923.field_41175.method_10204();
    }

    private int calculateTotalBlocksInShader(Map<String, Integer> blockToProperty, Map<String, Set<String>> tagToBlocks, Map<String, Integer> tagToProperty) {
        HashSet<String> coveredBlocks = new HashSet<String>();
        for (String string : blockToProperty.keySet()) {
            BlockStateValidator.BlockStateSpec spec = BlockStateValidator.parseBlockState(string);
            if (spec != null) {
                coveredBlocks.add(spec.blockId());
                continue;
            }
            coveredBlocks.add(string);
        }
        for (Map.Entry entry : tagToProperty.entrySet()) {
            String tagIdentifier = (String)entry.getKey();
            if (!tagToBlocks.containsKey(tagIdentifier)) continue;
            coveredBlocks.addAll((Collection)tagToBlocks.get(tagIdentifier));
        }
        return coveredBlocks.size();
    }

    private boolean isValidZipFile(Path path) {
        boolean bl;
        block8: {
            FileSystem ignored = FileSystems.newFileSystem(path, (ClassLoader)null);
            try {
                bl = true;
                if (ignored == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return false;
                }
            }
            ignored.close();
        }
        return bl;
    }

    public record RenderLayerMismatch(String expected, String actual) {
    }
}

