/*
 * Decompiled with CFR 0.152.
 */
package eclipse.euphoriacompanion.config;

import eclipse.euphoriacompanion.EuphoriaCompanion;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import net.fabricmc.loader.api.FabricLoader;

public class ModConfig {
    private static final String CONFIG_FILE_NAME = "euphoriacompanion.properties";
    private static ModConfig instance;
    public ScanMode scanMode = ScanMode.DEEP;
    public TagSupportMode tagSupport = TagSupportMode.DETECT;
    public boolean validateRenderLayers = true;
    public boolean checkLightEmitting = true;
    public boolean checkTranslucent = true;
    public boolean checkNonFull = true;
    public boolean checkFull = true;
    public boolean checkBlockEntity = true;
    public boolean generateEntityList = true;
    private Boolean cachedIrisSupport = null;
    private Boolean cachedEuphoriaPatchesSupport = null;

    public static ModConfig getInstance() {
        if (instance == null) {
            instance = ModConfig.load();
        }
        return instance;
    }

    private static Path getConfigPath() {
        return FabricLoader.getInstance().getConfigDir().resolve(CONFIG_FILE_NAME);
    }

    private static ModConfig load() {
        Path configPath = ModConfig.getConfigPath();
        if (Files.exists(configPath, new LinkOption[0])) {
            ModConfig modConfig;
            block11: {
                BufferedReader reader = Files.newBufferedReader(configPath);
                try {
                    Properties props = new Properties();
                    props.load(reader);
                    ModConfig config = new ModConfig();
                    config.loadFromProperties(props);
                    if (!config.validate()) {
                        EuphoriaCompanion.LOGGER.warn("Invalid or corrupted config file, resetting to defaults");
                        config = ModConfig.createDefaultConfig(configPath);
                    } else {
                        EuphoriaCompanion.LOGGER.info("Loaded configuration from {}", (Object)configPath);
                    }
                    modConfig = config;
                    if (reader == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        EuphoriaCompanion.LOGGER.error("Failed to load config, resetting to defaults", (Throwable)e);
                        return ModConfig.createDefaultConfig(configPath);
                    }
                }
                ((Reader)reader).close();
            }
            return modConfig;
        }
        return ModConfig.createDefaultConfig(configPath);
    }

    private static ModConfig createDefaultConfig(Path configPath) {
        ModConfig config = new ModConfig();
        config.save();
        EuphoriaCompanion.LOGGER.info("Created default configuration at {}", (Object)configPath);
        return config;
    }

    private boolean validate() {
        if (this.scanMode == null) {
            EuphoriaCompanion.LOGGER.error("Invalid config: scanMode is null (valid values: QUICK, DEEP)");
            return false;
        }
        if (this.tagSupport == null) {
            EuphoriaCompanion.LOGGER.error("Invalid config: tagSupport is null (valid values: DETECT, TRUE, FALSE)");
            return false;
        }
        return true;
    }

    private void loadFromProperties(Properties props) {
        try {
            String scanModeStr = props.getProperty("scanMode");
            if (scanModeStr != null) {
                this.scanMode = ScanMode.valueOf(scanModeStr);
            }
        }
        catch (IllegalArgumentException e) {
            EuphoriaCompanion.LOGGER.warn("Invalid scanMode value, using default: {}", (Object)this.scanMode);
        }
        try {
            String tagSupportStr = props.getProperty("tagSupport");
            if (tagSupportStr != null) {
                this.tagSupport = TagSupportMode.valueOf(tagSupportStr);
            }
        }
        catch (IllegalArgumentException e) {
            EuphoriaCompanion.LOGGER.warn("Invalid tagSupport value, using default: {}", (Object)this.tagSupport);
        }
        this.validateRenderLayers = Boolean.parseBoolean(props.getProperty("validateRenderLayers", "true"));
        this.checkLightEmitting = Boolean.parseBoolean(props.getProperty("checkLightEmitting", "true"));
        this.checkTranslucent = Boolean.parseBoolean(props.getProperty("checkTranslucent", "true"));
        this.checkNonFull = Boolean.parseBoolean(props.getProperty("checkNonFull", "true"));
        this.checkFull = Boolean.parseBoolean(props.getProperty("checkFull", "true"));
        this.checkBlockEntity = Boolean.parseBoolean(props.getProperty("checkBlockEntity", "true"));
        this.generateEntityList = Boolean.parseBoolean(props.getProperty("generateEntityList", "false"));
    }

    public void save() {
        Path configPath = ModConfig.getConfigPath();
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);){
                Properties props = new Properties();
                writer.write("# Euphoria Companion Configuration\n");
                writer.write("# Scan mode for block state analysis\n");
                writer.write("# Valid values: QUICK (fast, default state only), DEEP (slow but thorough, all block states)\n");
                props.setProperty("scanMode", this.scanMode.name());
                writer.write("\n# Tag support mode\n");
                writer.write("# Valid values: DETECT (auto-enable if Iris 1.8+), TRUE (force enable), FALSE (force disable)\n");
                props.setProperty("tagSupport", this.tagSupport.name());
                writer.write("\n# Validation and categorization options\n");
                writer.write("# Note: Block entities may not all use entity rendering (gbuffers_entities)\n");
                props.setProperty("checkLightEmitting", String.valueOf(this.checkLightEmitting));
                props.setProperty("checkTranslucent", String.valueOf(this.checkTranslucent));
                props.setProperty("checkNonFull", String.valueOf(this.checkNonFull));
                props.setProperty("checkFull", String.valueOf(this.checkFull));
                props.setProperty("checkBlockEntity", String.valueOf(this.checkBlockEntity));
                props.setProperty("validateRenderLayers", String.valueOf(this.validateRenderLayers));
                writer.write("\n# Generate entity list file\n");
                writer.write("# When enabled, generates a separate entity_list.txt file with all entities sorted by mod\n");
                props.setProperty("generateEntityList", String.valueOf(this.generateEntityList));
                props.store(writer, null);
                EuphoriaCompanion.LOGGER.info("Saved configuration to {}", (Object)configPath);
            }
        }
        catch (IOException e) {
            EuphoriaCompanion.LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    public boolean isTagSupportEnabled() {
        return switch (this.tagSupport.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> true;
            case 2 -> false;
            case 0 -> {
                if (this.cachedIrisSupport == null) {
                    this.cachedIrisSupport = this.detectIrisSupport();
                }
                yield this.cachedIrisSupport;
            }
        };
    }

    private boolean detectIrisSupport() {
        return FabricLoader.getInstance().getModContainer("iris").map(modContainer -> {
            String version = modContainer.getMetadata().getVersion().getFriendlyString();
            EuphoriaCompanion.LOGGER.info("Detected Iris version: {}", (Object)version);
            try {
                String[] parts = version.split("[.+]");
                if (parts.length >= 2) {
                    boolean supported;
                    int major = Integer.parseInt(parts[0]);
                    int minor = Integer.parseInt(parts[1]);
                    boolean bl = supported = major > 1 || major == 1 && minor >= 8;
                    if (supported) {
                        EuphoriaCompanion.LOGGER.info("Iris 1.8+ detected, enabling tag support");
                    } else {
                        EuphoriaCompanion.LOGGER.info("Iris version < 1.8, tag support disabled");
                    }
                    return supported;
                }
            }
            catch (NumberFormatException e) {
                EuphoriaCompanion.LOGGER.warn("Failed to parse Iris version: {}", (Object)version);
            }
            return false;
        }).orElseGet(() -> {
            EuphoriaCompanion.LOGGER.info("Iris not detected, tag support disabled");
            return false;
        });
    }

    public boolean detectEuphoriaPatchesSupport() {
        if (this.cachedEuphoriaPatchesSupport != null) {
            return this.cachedEuphoriaPatchesSupport;
        }
        this.cachedEuphoriaPatchesSupport = this.detectEuphoriaPatchesSupportInternal();
        return this.cachedEuphoriaPatchesSupport;
    }

    private boolean detectEuphoriaPatchesSupportInternal() {
        return FabricLoader.getInstance().getModContainer("euphoria_patcher").map(modContainer -> {
            String version = modContainer.getMetadata().getVersion().getFriendlyString();
            EuphoriaCompanion.LOGGER.info("Detected Euphoria Patches version: {}", (Object)version);
            try {
                String versionCore = version.split("-")[0].split("\\+")[0];
                String[] parts = versionCore.split("\\.");
                if (parts.length >= 3) {
                    boolean supported;
                    int major = Integer.parseInt(parts[0]);
                    int minor = Integer.parseInt(parts[1]);
                    int patch = Integer.parseInt(parts[2]);
                    boolean bl = supported = major > 1 || major == 1 && minor > 7 || major == 1 && minor == 7 && patch >= 8;
                    if (supported) {
                        EuphoriaCompanion.LOGGER.info("Euphoria Patches 1.7.8+ detected, enabling Euphoria Companion defines");
                    } else {
                        EuphoriaCompanion.LOGGER.info("Euphoria Patches version < 1.7.8, defines disabled");
                    }
                    return supported;
                }
            }
            catch (NumberFormatException e) {
                EuphoriaCompanion.LOGGER.warn("Failed to parse Euphoria Patches version: {}", (Object)version);
            }
            return false;
        }).orElse(false);
    }

    public static enum ScanMode {
        QUICK,
        DEEP;

    }

    public static enum TagSupportMode {
        DETECT,
        TRUE,
        FALSE;

    }
}

