/*
 * Decompiled with CFR 0.152.
 */
package eclipse.euphoriacompanion.report;

import eclipse.euphoriacompanion.EuphoriaCompanion;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.class_1299;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class EntityListGenerator {
    public static void generateEntityList(Path outputPath) throws IOException {
        EuphoriaCompanion.LOGGER.info("Starting entity list generation...");
        if (outputPath.getParent() == null) {
            throw new IOException("Output path has no parent directory: " + String.valueOf(outputPath));
        }
        Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
        TreeMap<String, List> entitiesByMod = new TreeMap<String, List>();
        for (class_1299 entityType : class_7923.field_41177) {
            class_2960 id = class_7923.field_41177.method_10221((Object)entityType);
            String namespace = id.method_12836();
            String entityName = id.toString();
            entitiesByMod.computeIfAbsent(namespace, k -> new ArrayList()).add(entityName);
        }
        EuphoriaCompanion.LOGGER.info("Found {} mods with entities", (Object)entitiesByMod.size());
        Path tempPath = outputPath.getParent().resolve(String.valueOf(outputPath.getFileName()) + ".tmp");
        try (BufferedWriter writer = Files.newBufferedWriter(tempPath, new OpenOption[0]);){
            writer.write("=== ENTITY LIST ===\n");
            writer.write("All entities registered in the game, sorted by mod.\n\n");
            int totalEntities = 0;
            for (Map.Entry entry : entitiesByMod.entrySet()) {
                String modName = (String)entry.getKey();
                List entities = (List)entry.getValue();
                Collections.sort(entities);
                totalEntities += entities.size();
                writer.write("----------------------------------------\n");
                writer.write(modName + " (" + entities.size() + " entities):\n\n");
                for (String entity : entities) {
                    writer.write(" " + entity + "\n");
                }
                writer.write("\n");
            }
            writer.write("========================================\n");
            writer.write("TOTAL ENTITIES: " + totalEntities + "\n");
        }
        Files.move(tempPath, outputPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        EuphoriaCompanion.LOGGER.info("Generated entity list with {} total entities at {}", (Object)entitiesByMod.values().stream().mapToInt(List::size).sum(), (Object)outputPath);
    }
}

