/*
 * Decompiled with CFR 0.152.
 */
package eclipse.euphoriacompanion.analyzer;

import eclipse.euphoriacompanion.EuphoriaCompanion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class BlockStateValidator {
    public static BlockStateSpec parseBlockState(String fullBlockId) {
        String blockName;
        String namespace;
        String[] segments = fullBlockId.split(":");
        if (segments.length < 2) {
            return null;
        }
        if (segments[1].contains("=")) {
            namespace = "minecraft";
            blockName = segments[0];
            propertyStartIndex = 1;
        } else {
            namespace = segments[0];
            blockName = segments[1];
            propertyStartIndex = 2;
        }
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        for (int i = propertyStartIndex; i < segments.length; ++i) {
            String propertyDef = segments[i];
            String[] propParts = propertyDef.split("=", 2);
            if (propParts.length != 2) continue;
            properties.put(propParts[0], propParts[1]);
        }
        if (properties.isEmpty()) {
            return null;
        }
        String blockId = namespace + ":" + blockName;
        return new BlockStateSpec(blockId, properties);
    }

    public static Map<String, Map<String, List<String>>> validateBlockStates(Map<String, Integer> blockToProperty) {
        String blockId;
        HashMap<String, Map> definedValuesByBlock = new HashMap<String, Map>();
        for (String fullId : blockToProperty.keySet()) {
            BlockStateSpec spec = BlockStateValidator.parseBlockState(fullId);
            if (spec == null) continue;
            blockId = spec.blockId();
            Map propertyValues = definedValuesByBlock.computeIfAbsent(blockId, k -> new HashMap());
            for (Map.Entry<String, String> prop : spec.properties().entrySet()) {
                propertyValues.computeIfAbsent(prop.getKey(), k -> new HashSet()).add(prop.getValue());
            }
        }
        TreeMap<String, Map<String, List<String>>> incompleteBlockStates = new TreeMap<String, Map<String, List<String>>>();
        for (Map.Entry entry : definedValuesByBlock.entrySet()) {
            Map<String, Set<String>> possibleValues;
            blockId = (String)entry.getKey();
            Map definedValues = (Map)entry.getValue();
            class_2960 id = class_2960.method_12829((String)blockId);
            if (id == null || !class_7923.field_41175.method_10250(id) || (possibleValues = BlockStateValidator.getPossiblePropertyValues(blockId, definedValues.keySet())).isEmpty()) continue;
            TreeMap missingByProperty = new TreeMap();
            for (Map.Entry<String, Set<String>> propEntry : possibleValues.entrySet()) {
                String propertyName = propEntry.getKey();
                Set<String> allValues = propEntry.getValue();
                Set defined = definedValues.getOrDefault(propertyName, Collections.emptySet());
                HashSet<String> definedLowercase = new HashSet<String>();
                for (String val : defined) {
                    definedLowercase.add(val.toLowerCase());
                }
                ArrayList<String> missing = new ArrayList<String>();
                for (String value : allValues) {
                    if (definedLowercase.contains(value.toLowerCase())) continue;
                    missing.add(value);
                }
                if (missing.isEmpty()) continue;
                Collections.sort(missing);
                missingByProperty.put(propertyName, missing);
            }
            if (missingByProperty.isEmpty()) continue;
            incompleteBlockStates.put(blockId, missingByProperty);
        }
        return incompleteBlockStates;
    }

    private static Map<String, Set<String>> getPossiblePropertyValues(String blockId, Set<String> propertyNames) {
        HashMap<String, Set<String>> possibleValues = new HashMap<String, Set<String>>();
        try {
            class_2960 id = class_2960.method_12829((String)blockId);
            if (id == null) {
                return possibleValues;
            }
            if (!class_7923.field_41175.method_10250(id)) {
                return possibleValues;
            }
            class_2248 block = (class_2248)class_7923.field_41175.method_10223(id);
            class_2680 defaultState = block.method_9564();
            if (defaultState == null) {
                return possibleValues;
            }
            for (class_2769 property : defaultState.method_28501()) {
                String propertyName = property.method_11899();
                if (!propertyNames.contains(propertyName)) continue;
                LinkedHashSet<String> values = new LinkedHashSet<String>();
                for (Object value : property.method_11898()) {
                    values.add(value.toString());
                }
                possibleValues.put(propertyName, values);
            }
        }
        catch (Exception e) {
            EuphoriaCompanion.LOGGER.error("Failed to get property values for: {}", (Object)blockId, (Object)e);
        }
        return possibleValues;
    }

    public record BlockStateSpec(String blockId, Map<String, String> properties) {
    }
}

