/*
 * Decompiled with CFR 0.152.
 */
package eclipse.euphoriacompanion.analyzer;

import eclipse.euphoriacompanion.EuphoriaCompanion;
import eclipse.euphoriacompanion.analyzer.ShaderAnalyzer;
import eclipse.euphoriacompanion.config.ModConfig;
import eclipse.euphoriacompanion.report.AnalysisReport;
import eclipse.euphoriacompanion.report.EntityListGenerator;
import eclipse.euphoriacompanion.report.ReportGenerator;
import eclipse.euphoriacompanion.util.MinecraftVersionUtil;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.loader.api.FabricLoader;

public class ShaderpackAnalysisInitiator {
    private static final AtomicBoolean isProcessing = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processAllShaderpacks() {
        if (!isProcessing.compareAndSet(false, true)) {
            EuphoriaCompanion.LOGGER.info("Analysis already in progress, skipping request");
            return;
        }
        try {
            EuphoriaCompanion.LOGGER.info("Starting shader analysis...");
            ModConfig config = ModConfig.getInstance();
            int mcVersion = MinecraftVersionUtil.getCurrentMCVersionAsInt();
            EuphoriaCompanion.LOGGER.info("Current Minecraft version: {}", (Object)mcVersion);
            Path gameDir = FabricLoader.getInstance().getGameDir();
            Path shaderpacksDir = gameDir.resolve("shaderpacks");
            try {
                Files.createDirectories(shaderpacksDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                EuphoriaCompanion.LOGGER.error("Failed to create shaderpacks directory at {}", (Object)shaderpacksDir, (Object)e);
                isProcessing.set(false);
                return;
            }
            List<Path> shaderpackPaths = ShaderpackAnalysisInitiator.findShaderpacks(shaderpacksDir);
            if (shaderpackPaths.isEmpty()) {
                EuphoriaCompanion.LOGGER.error("No shaderpacks found in shaderpacks/ directory");
                return;
            }
            EuphoriaCompanion.LOGGER.info("Found {} shaderpacks: {}", (Object)shaderpackPaths.size(), (Object)ShaderpackAnalysisInitiator.getShaderpackNames(shaderpackPaths));
            ShaderAnalyzer analyzer = new ShaderAnalyzer(config, mcVersion);
            Path logsDir = gameDir.resolve("logs/euphoriacompanion");
            try {
                Files.createDirectories(logsDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                EuphoriaCompanion.LOGGER.error("Failed to create logs directory at {}", (Object)logsDir, (Object)e);
                isProcessing.set(false);
                return;
            }
            for (Path shaderpackPath : shaderpackPaths) {
                try {
                    String shaderpackName = shaderpackPath.getFileName().toString();
                    AnalysisReport report = analyzer.analyze(shaderpackPath);
                    String reportFileName = shaderpackName.replace(".zip", "").replaceAll("[^a-zA-Z0-9._-]", "_") + "_analysis.txt";
                    Path reportPath = logsDir.resolve(reportFileName);
                    ReportGenerator.generateReport(report, reportPath);
                    EuphoriaCompanion.LOGGER.info("Analysis complete. Report saved to logs/euphoriacompanion/{}", (Object)reportFileName);
                }
                catch (IOException e) {
                    EuphoriaCompanion.LOGGER.error("Failed to analyze shaderpack: {}", (Object)shaderpackPath.getFileName(), (Object)e);
                }
            }
            if (config.generateEntityList) {
                try {
                    Path entityListPath = logsDir.resolve("entity_list.txt");
                    EntityListGenerator.generateEntityList(entityListPath);
                    EuphoriaCompanion.LOGGER.info("Entity list saved to logs/euphoriacompanion/entity_list.txt");
                }
                catch (IOException e) {
                    EuphoriaCompanion.LOGGER.error("Failed to generate entity list", (Throwable)e);
                }
            }
            EuphoriaCompanion.LOGGER.info("All shader analysis complete");
        }
        catch (Exception e) {
            EuphoriaCompanion.LOGGER.error("Error during shader analysis", (Throwable)e);
        }
        finally {
            isProcessing.set(false);
        }
    }

    private static List<Path> findShaderpacks(Path shaderpacksDir) throws IOException {
        ArrayList<Path> shaderpacks = new ArrayList<Path>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(shaderpacksDir);){
            for (Path path : stream) {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    if (!Files.exists(path.resolve("shaders/block.properties"), new LinkOption[0])) continue;
                    shaderpacks.add(path);
                    continue;
                }
                if (!Files.isRegularFile(path, new LinkOption[0]) || !path.toString().toLowerCase().endsWith(".zip")) continue;
                shaderpacks.add(path);
            }
        }
        return shaderpacks;
    }

    private static String getShaderpackNames(List<Path> shaderpackPaths) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < shaderpackPaths.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(shaderpackPaths.get(i).getFileName().toString());
        }
        return sb.toString();
    }
}

