/*
 * Decompiled with CFR 0.152.
 */
package eclipse.euphoriacompanion.parser;

import eclipse.euphoriacompanion.EuphoriaCompanion;
import eclipse.euphoriacompanion.config.ModConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.loader.api.FabricLoader;

public class BlockPropertiesParser {
    private static final Pattern IF_PATTERN = Pattern.compile("#if\\s+(\\w+)\\s*([!=<>]+)\\s*(\\d+)");
    private static final Pattern DEFINE_PATTERN = Pattern.compile("#define\\s+(\\w+)\\s+(.+)");
    private final Map<String, Integer> blockToProperty = new HashMap<String, Integer>();
    private final Map<String, String> blockToRenderLayer = new HashMap<String, String>();
    private final Map<String, String> tagDefinitions = new LinkedHashMap<String, String>();
    private final Map<String, Integer> tagToProperty = new LinkedHashMap<String, Integer>();
    private final Map<String, List<Integer>> duplicateBlocks = new HashMap<String, List<Integer>>();
    private final ModConfig config;
    private final int currentMCVersion;
    private boolean irisLoaded = false;
    private final boolean oculusLoaded;
    private final int oculusVersion;
    private final int irisTagSupport;

    public BlockPropertiesParser(ModConfig config, int currentMCVersion) {
        this.config = config;
        this.currentMCVersion = currentMCVersion;
        boolean euphoriaPatchesEnabled = config.detectEuphoriaPatchesSupport();
        int n = this.irisTagSupport = config.isTagSupportEnabled() ? 2 : 0;
        if (euphoriaPatchesEnabled) {
            this.oculusLoaded = FabricLoader.getInstance().isModLoaded("oculus");
            if (!this.oculusLoaded) {
                this.irisLoaded = FabricLoader.getInstance().isModLoaded("iris");
            }
            this.oculusVersion = this.getOculusVersionInt();
            EuphoriaCompanion.LOGGER.info("Euphoria Companion defines: EUPHORIA_PATCHES_IRIS={}, EUPHORIA_PATCHES_OCULUS={}, EUPHORIA_PATCHES_OCULUS_VERSION={}", new Object[]{this.irisLoaded, this.oculusLoaded, this.oculusVersion});
        } else {
            this.irisLoaded = false;
            this.oculusLoaded = false;
            this.oculusVersion = 0;
            EuphoriaCompanion.LOGGER.info("Euphoria Patches not detected, Euphoria Companion defines disabled");
        }
        EuphoriaCompanion.LOGGER.info("IRIS_TAG_SUPPORT = {}", (Object)this.irisTagSupport);
    }

    private int getOculusVersionInt() {
        return FabricLoader.getInstance().getModContainer("oculus").map(modContainer -> {
            String version = modContainer.getMetadata().getVersion().getFriendlyString();
            try {
                String[] parts = version.split("[.+]");
                if (parts.length >= 3) {
                    int major = Integer.parseInt(parts[0]);
                    int minor = Integer.parseInt(parts[1]);
                    int patch = Integer.parseInt(parts[2]);
                    return major * 10000 + minor * 100 + patch;
                }
            }
            catch (NumberFormatException e) {
                EuphoriaCompanion.LOGGER.warn("Failed to parse Oculus version: {}", (Object)version);
            }
            return 0;
        }).orElse(0);
    }

    public void parse(Path propertiesFile) throws IOException {
        ArrayDeque<ConditionalContext> conditionalStack = new ArrayDeque<ConditionalContext>();
        try (BufferedReader reader = Files.newBufferedReader(propertiesFile);){
            int lineNumber = 0;
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    ++lineNumber;
                    if ((line = line.trim()).endsWith("\\")) {
                        StringBuilder continuedLine = new StringBuilder();
                        while (line.endsWith("\\")) {
                            String withoutBackslash = line.substring(0, line.length() - 1).trim();
                            if (!withoutBackslash.isEmpty()) {
                                if (!continuedLine.isEmpty()) {
                                    continuedLine.append(" ");
                                }
                                continuedLine.append(withoutBackslash);
                            }
                            if ((line = reader.readLine()) == null) break;
                            ++lineNumber;
                            line = line.trim();
                        }
                        if (line != null && !line.isEmpty()) {
                            if (!continuedLine.isEmpty()) {
                                continuedLine.append(" ");
                            }
                            continuedLine.append(line);
                        }
                        line = continuedLine.toString();
                    }
                    if (line.startsWith("#ifdef ") || line.startsWith("#ifndef ")) {
                        this.handleIfdefDirective(line, conditionalStack, lineNumber);
                        continue;
                    }
                    if (line.startsWith("#if ")) {
                        this.handleIfDirective(line, conditionalStack, lineNumber);
                        continue;
                    }
                    if (line.startsWith("#else")) {
                        this.handleElseDirective(conditionalStack, lineNumber);
                        continue;
                    }
                    if (line.startsWith("#endif")) {
                        this.handleEndifDirective(conditionalStack, lineNumber);
                        continue;
                    }
                    if (!this.isActiveContext(conditionalStack) || line.isEmpty() || line.startsWith("#") && !line.startsWith("#define")) continue;
                    if (line.startsWith("#define") && this.config.isTagSupportEnabled()) {
                        this.handleDefineDirective(line, lineNumber);
                        continue;
                    }
                    if (!line.contains("=")) continue;
                    this.handlePropertyAssignment(line, lineNumber);
                }
            }
            catch (IOException e) {
                throw new IOException("Error reading block.properties at line " + lineNumber, e);
            }
        }
        if (!conditionalStack.isEmpty()) {
            EuphoriaCompanion.LOGGER.warn("Parsing ended with {} unmatched #if directive(s)", (Object)conditionalStack.size());
        }
        EuphoriaCompanion.LOGGER.info("Parsed {} direct block assignments and {} tag definitions", (Object)this.blockToProperty.size(), (Object)this.tagDefinitions.size());
    }

    private void handleIfDirective(String line, Deque<ConditionalContext> stack, int lineNumber) {
        EuphoriaCompanion.LOGGER.debug("Line {}: #if [{}] (stack depth before: {})", new Object[]{lineNumber, line, stack.size()});
        String expression = line.substring(4).trim();
        boolean parentActive = this.isActiveContext(stack);
        Boolean result = this.evaluateExpression(expression);
        if (result != null) {
            boolean active = parentActive && result != false;
            stack.push(new ConditionalContext(true, active));
            EuphoriaCompanion.LOGGER.debug("Line {}: #if evaluated to {} -> {} (stack depth after: {})", new Object[]{lineNumber, result, active, stack.size()});
        } else {
            EuphoriaCompanion.LOGGER.warn("Line {}: Unsupported #if expression: {} (stack depth: {})", new Object[]{lineNumber, expression, stack.size()});
            stack.push(new ConditionalContext(false, false));
        }
    }

    private Boolean evaluateExpression(String expression) {
        try {
            EuphoriaCompanion.LOGGER.debug("Evaluating expression: [{}]", (Object)expression);
            if (expression.contains("||")) {
                String[] orParts = expression.split("\\|\\|");
                EuphoriaCompanion.LOGGER.debug("Split on OR, {} parts", (Object)orParts.length);
                for (String part : orParts) {
                    EuphoriaCompanion.LOGGER.debug("Evaluating OR part: [{}]", (Object)part.trim());
                    Boolean result = this.evaluateExpression(part.trim());
                    EuphoriaCompanion.LOGGER.debug("OR part result: {}", (Object)result);
                    if (result == null) {
                        return null;
                    }
                    if (!result.booleanValue()) continue;
                    return true;
                }
                return false;
            }
            if (expression.contains("&&")) {
                String[] andParts = expression.split("&&");
                EuphoriaCompanion.LOGGER.debug("Split on AND, {} parts", (Object)andParts.length);
                for (String part : andParts) {
                    EuphoriaCompanion.LOGGER.debug("Evaluating AND part: [{}]", (Object)part.trim());
                    Boolean result = this.evaluateExpression(part.trim());
                    EuphoriaCompanion.LOGGER.debug("AND part result: {}", (Object)result);
                    if (result == null) {
                        return null;
                    }
                    if (result.booleanValue()) continue;
                    return false;
                }
                return true;
            }
            if (expression.startsWith("defined ")) {
                String symbol = expression.substring(8).trim();
                boolean defined = this.isSymbolDefined(symbol);
                EuphoriaCompanion.LOGGER.debug("Checking defined {}: {}", (Object)symbol, (Object)defined);
                return defined;
            }
            Matcher matcher = IF_PATTERN.matcher("#if " + expression);
            if (matcher.matches()) {
                String variable = matcher.group(1);
                String operator = matcher.group(2);
                int value = Integer.parseInt(matcher.group(3));
                switch (variable) {
                    case "MC_VERSION": {
                        boolean result = this.evaluateCondition(this.currentMCVersion, operator, value);
                        EuphoriaCompanion.LOGGER.debug("MC_VERSION {} {} -> {}", new Object[]{operator, value, result});
                        return result;
                    }
                    case "EUPHORIA_PATCHES_OCULUS_VERSION": {
                        boolean result = this.evaluateCondition(this.oculusVersion, operator, value);
                        EuphoriaCompanion.LOGGER.debug("EUPHORIA_PATCHES_OCULUS_VERSION {} {} -> {}", new Object[]{operator, value, result});
                        return result;
                    }
                    case "IRIS_TAG_SUPPORT": {
                        boolean result = this.evaluateCondition(this.irisTagSupport, operator, value);
                        EuphoriaCompanion.LOGGER.debug("IRIS_TAG_SUPPORT ({}) {} {} -> {}", new Object[]{this.irisTagSupport, operator, value, result});
                        return result;
                    }
                }
            }
            EuphoriaCompanion.LOGGER.debug("Could not parse expression: [{}]", (Object)expression);
            return null;
        }
        catch (Exception e) {
            EuphoriaCompanion.LOGGER.warn("Error evaluating expression: {}", (Object)expression, (Object)e);
            return null;
        }
    }

    private boolean isSymbolDefined(String symbol) {
        return switch (symbol) {
            case "EUPHORIA_PATCHES_IRIS" -> this.irisLoaded;
            case "EUPHORIA_PATCHES_OCULUS" -> this.oculusLoaded;
            default -> false;
        };
    }

    private void handleIfdefDirective(String line, Deque<ConditionalContext> stack, int lineNumber) {
        boolean isIfndef = line.startsWith("#ifndef");
        String directiveName = isIfndef ? "#ifndef" : "#ifdef";
        EuphoriaCompanion.LOGGER.debug("Line {}: {} [{}] (stack depth before: {})", new Object[]{lineNumber, directiveName, line, stack.size()});
        String symbol = line.substring(isIfndef ? 8 : 7).trim();
        boolean parentActive = this.isActiveContext(stack);
        boolean symbolDefined = false;
        boolean supported = false;
        if (symbol.equals("EUPHORIA_PATCHES_IRIS")) {
            symbolDefined = this.irisLoaded;
            supported = true;
            EuphoriaCompanion.LOGGER.debug("Line {}: Checking EUPHORIA_PATCHES_IRIS -> {}", (Object)lineNumber, (Object)symbolDefined);
        } else if (symbol.equals("EUPHORIA_PATCHES_OCULUS")) {
            symbolDefined = this.oculusLoaded;
            supported = true;
            EuphoriaCompanion.LOGGER.debug("Line {}: Checking EUPHORIA_PATCHES_OCULUS -> {}", (Object)lineNumber, (Object)symbolDefined);
        }
        boolean condition = isIfndef != symbolDefined;
        boolean active = parentActive && condition;
        stack.push(new ConditionalContext(supported, active));
        EuphoriaCompanion.LOGGER.debug("Line {}: {} {} -> {} (stack depth after: {})", new Object[]{lineNumber, directiveName, symbol, active, stack.size()});
    }

    private void handleElseDirective(Deque<ConditionalContext> stack, int lineNumber) {
        EuphoriaCompanion.LOGGER.debug("Line {}: #else (stack depth before: {})", (Object)lineNumber, (Object)stack.size());
        if (stack.isEmpty()) {
            EuphoriaCompanion.LOGGER.warn("Line {}: #else without matching #if (stack is empty)", (Object)lineNumber);
            return;
        }
        ConditionalContext current = stack.pop();
        boolean parentActive = this.isActiveContext(stack);
        boolean elseActive = current.supported() ? parentActive && !current.active() : parentActive;
        stack.push(new ConditionalContext(current.supported(), elseActive));
        EuphoriaCompanion.LOGGER.debug("Line {}: #else -> {} (supported: {}, stack depth after: {})", new Object[]{lineNumber, elseActive, current.supported(), stack.size()});
    }

    private void handleEndifDirective(Deque<ConditionalContext> stack, int lineNumber) {
        EuphoriaCompanion.LOGGER.debug("Line {}: #endif (stack depth before: {})", (Object)lineNumber, (Object)stack.size());
        if (!stack.isEmpty()) {
            stack.pop();
            EuphoriaCompanion.LOGGER.debug("Line {}: #endif processed (stack depth after: {})", (Object)lineNumber, (Object)stack.size());
        } else {
            EuphoriaCompanion.LOGGER.warn("Line {}: #endif without matching #if (stack is empty)", (Object)lineNumber);
        }
    }

    private void handleDefineDirective(String line, int lineNumber) {
        Matcher matcher = DEFINE_PATTERN.matcher(line);
        if (matcher.matches()) {
            String identifier = matcher.group(1);
            String tagName = matcher.group(2);
            this.tagDefinitions.put(identifier, tagName);
            EuphoriaCompanion.LOGGER.debug("Line {}: Defined tag {} = %{}", new Object[]{lineNumber, identifier, tagName});
        } else {
            EuphoriaCompanion.LOGGER.warn("Line {}: Invalid #define directive: {}", (Object)lineNumber, (Object)line);
        }
    }

    private void handlePropertyAssignment(String line, int lineNumber) {
        String[] parts = line.split("=", 2);
        if (parts.length != 2) {
            return;
        }
        String key = parts[0].trim();
        String value = parts[1].trim();
        if (key.startsWith("block.")) {
            this.handleBlockProperty(key, value, lineNumber);
        } else if (key.startsWith("layer.")) {
            this.handleRenderLayer(key, value);
        }
    }

    private void handleBlockProperty(String key, String value, int lineNumber) {
        String[] blockIds;
        int propertyId;
        String propertyIdStr = key.substring(6);
        try {
            propertyId = Integer.parseInt(propertyIdStr);
        }
        catch (NumberFormatException e) {
            EuphoriaCompanion.LOGGER.warn("Line {}: Invalid property ID: {}", (Object)lineNumber, (Object)propertyIdStr);
            return;
        }
        for (String blockId : blockIds = value.split("\\s+")) {
            if ((blockId = blockId.trim()).isEmpty()) continue;
            if (this.tagDefinitions.containsKey(blockId)) {
                this.tagToProperty.put(blockId, propertyId);
                EuphoriaCompanion.LOGGER.debug("Line {}: Tag {} -> property {}", new Object[]{lineNumber, blockId, propertyId});
                continue;
            }
            String normalizedId = this.normalizeBlockId(blockId);
            if (normalizedId == null) continue;
            if (this.blockToProperty.containsKey(normalizedId)) {
                int existingProperty = this.blockToProperty.get(normalizedId);
                this.duplicateBlocks.computeIfAbsent(normalizedId, k -> new ArrayList());
                List<Integer> properties = this.duplicateBlocks.get(normalizedId);
                if (!properties.contains(existingProperty)) {
                    properties.add(existingProperty);
                }
                if (!properties.contains(propertyId)) {
                    properties.add(propertyId);
                }
                EuphoriaCompanion.LOGGER.debug("Line {}: Duplicate block {} already mapped to block.{}, now also to block.{}", new Object[]{lineNumber, normalizedId, existingProperty, propertyId});
            }
            this.blockToProperty.put(normalizedId, propertyId);
        }
    }

    private void handleRenderLayer(String key, String value) {
        String[] blockIds;
        String layerName = key.substring(6);
        for (String blockId : blockIds = value.split("\\s+")) {
            String normalizedId;
            if ((blockId = blockId.trim()).isEmpty() || (normalizedId = this.normalizeBlockId(blockId)) == null) continue;
            this.blockToRenderLayer.put(normalizedId, layerName);
        }
    }

    private String normalizeBlockId(String blockId) {
        if (blockId == null || blockId.trim().isEmpty()) {
            EuphoriaCompanion.LOGGER.warn("Empty or null block ID provided");
            return null;
        }
        String trimmed = blockId.trim();
        if (trimmed.startsWith(":") || trimmed.endsWith(":")) {
            EuphoriaCompanion.LOGGER.warn("Invalid block ID format: {}", (Object)blockId);
            return null;
        }
        String[] parts = trimmed.split(":");
        if (parts.length == 1) {
            return "minecraft:" + trimmed;
        }
        if (parts[1].contains("=")) {
            return "minecraft:" + trimmed;
        }
        return trimmed;
    }

    private boolean isActiveContext(Deque<ConditionalContext> stack) {
        for (ConditionalContext context : stack) {
            if (context.active) continue;
            return false;
        }
        return true;
    }

    private boolean evaluateCondition(int left, String operator, int right) {
        return switch (operator) {
            case "==" -> {
                if (left == right) {
                    yield true;
                }
                yield false;
            }
            case "!=" -> {
                if (left != right) {
                    yield true;
                }
                yield false;
            }
            case "<" -> {
                if (left < right) {
                    yield true;
                }
                yield false;
            }
            case ">" -> {
                if (left > right) {
                    yield true;
                }
                yield false;
            }
            case "<=" -> {
                if (left <= right) {
                    yield true;
                }
                yield false;
            }
            case ">=" -> {
                if (left >= right) {
                    yield true;
                }
                yield false;
            }
            default -> {
                EuphoriaCompanion.LOGGER.warn("Unknown operator: {}", (Object)operator);
                yield false;
            }
        };
    }

    public Map<String, Integer> getBlockToProperty() {
        return Collections.unmodifiableMap(this.blockToProperty);
    }

    public Map<String, String> getBlockToRenderLayer() {
        return Collections.unmodifiableMap(this.blockToRenderLayer);
    }

    public Map<String, String> getTagDefinitions() {
        return Collections.unmodifiableMap(this.tagDefinitions);
    }

    public Map<String, Integer> getTagToProperty() {
        return Collections.unmodifiableMap(this.tagToProperty);
    }

    public Map<String, List<Integer>> getDuplicateBlocks() {
        return Collections.unmodifiableMap(this.duplicateBlocks);
    }

    private record ConditionalContext(boolean supported, boolean active) {
    }
}

