/*
 * Decompiled with CFR 0.152.
 */
package eclipse.euphoriacompanion.util;

import eclipse.euphoriacompanion.EuphoriaCompanion;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;

public class MinecraftVersionUtil {
    public static int getCurrentMCVersionAsInt() {
        try {
            String version = ((ModContainer)FabricLoader.getInstance().getModContainer("minecraft").orElseThrow(() -> new RuntimeException("Minecraft mod container not found"))).getMetadata().getVersion().getFriendlyString();
            return MinecraftVersionUtil.parseVersionToInt(version);
        }
        catch (Exception e) {
            EuphoriaCompanion.LOGGER.error("Failed to determine Minecraft version", (Throwable)e);
            throw new RuntimeException("Unable to determine Minecraft version", e);
        }
    }

    public static int parseVersionToInt(String version) {
        if (version.matches("\\d{2}w\\d{2}[a-z]")) {
            EuphoriaCompanion.LOGGER.info("Detected snapshot version: {}, treating as latest", (Object)version);
            return Integer.MAX_VALUE;
        }
        String[] mainParts = version.split("-")[0].split("\\+")[0].split("\\.");
        if (mainParts.length < 2) {
            throw new RuntimeException("Invalid Minecraft version format: " + version + " (expected format: X.Y or X.Y.Z), what happened!!");
        }
        try {
            int major = Integer.parseInt(mainParts[0]);
            int minor = Integer.parseInt(mainParts[1]);
            int patch = mainParts.length >= 3 ? Integer.parseInt(mainParts[2]) : 0;
            return major * 10000 + minor * 100 + patch;
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Failed to parse Minecraft version: " + version + " - version parts must be numeric", e);
        }
    }
}

