/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadencounters;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.oxcodsnet.roadarchitect.api.addon.AddonContext;
import net.oxcodsnet.roadarchitect.api.addon.RoadAddon;
import net.oxcodsnet.roadarchitect.util.CacheManager;
import net.oxcodsnet.roadencounters.config.REConfig;
import net.oxcodsnet.roadencounters.config.REConfigHolder;
import net.oxcodsnet.roadencounters.storage.TriggerStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AmbushAddon
implements RoadAddon {
    public static final String MOD_ID = "roadarchitect_roadencounters";
    public static final ResourceLocation ADDON_ID = ResourceLocation.fromNamespaceAndPath((String)"roadarchitect_roadencounters", (String)"ambush_addon");
    public static final ResourceLocation AMBUSH_TRIGGER = ResourceLocation.fromNamespaceAndPath((String)"roadarchitect_roadencounters", (String)"ambush");
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadarchitect_roadencounters/AmbushAddon");
    private TriggerStorage storage;
    private REConfig config;

    public ResourceLocation id() {
        return ADDON_ID;
    }

    public void onRegister() {
    }

    public void onRegister(AddonContext ctx) {
        this.storage = TriggerStorage.create(arg_0 -> ((AddonContext)ctx).persistent(arg_0), ctx.logger(), this.id());
        this.config = REConfigHolder.get();
        ctx.logger().info("[{}] Addon registered successfully", (Object)MOD_ID);
    }

    public void onPathReady(ServerLevel world, String pathKey, List<BlockPos> refinedPath) {
        if (this.storage == null) {
            return;
        }
        if (refinedPath.size() < 16) {
            return;
        }
        int maxMarkers = this.config.maxMarkers();
        int stride = this.config.strideBlocks();
        int placed = 0;
        int acc = 0;
        for (int i = 1; i < refinedPath.size(); ++i) {
            int dz;
            BlockPos a = refinedPath.get(i - 1);
            BlockPos b = refinedPath.get(i);
            int dx = Math.abs(b.getX() - a.getX());
            int seg = Math.max(dx, dz = Math.abs(b.getZ() - a.getZ()));
            if ((acc += seg) < stride) continue;
            BlockPos p = b;
            this.storage.addMarker(world, p, AMBUSH_TRIGGER, this.config.triggerRadius(), new CompoundTag());
            if (++placed >= maxMarkers) break;
            acc = 0;
        }
        if (placed > 0) {
            LOGGER.debug("Ambush markers placed: {} on {}", (Object)placed, (Object)pathKey);
        }
    }

    public void onServerTick(MinecraftServer server) {
        if (this.storage == null) {
            return;
        }
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            List<TriggerStorage.Marker> nearby;
            Level level = player.level();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel world = (ServerLevel)level;
            ChunkPos cp = new ChunkPos(player.blockPosition());
            if (!world.hasChunk(cp.x, cp.z) || (nearby = this.storage.findMarkersNear(world, player.blockPosition(), this.config.triggerRadius())).isEmpty()) continue;
            ArrayList<UUID> toRemove = new ArrayList<UUID>();
            for (TriggerStorage.Marker m : nearby) {
                if (!world.hasChunk(m.pos().getX() >> 4, m.pos().getZ() >> 4)) continue;
                this.handleAmbush(world, m.pos());
                toRemove.add(m.id());
            }
            if (toRemove.isEmpty()) continue;
            this.storage.markTriggered(world, toRemove, this.config.cooldownTicks());
        }
    }

    public void onChunkLoad(ServerLevel world, ChunkPos pos) {
    }

    private void handleAmbush(ServerLevel world, BlockPos pos) {
        if (world.getDifficulty() == Difficulty.PEACEFUL) {
            return;
        }
        RandomSource rnd = world.getRandom();
        REConfig.SpawnSpec picked = AmbushAddon.pickSpawn(this.config, rnd);
        int count = picked.countMin() + rnd.nextInt(Math.max(1, picked.countMax() - picked.countMin() + 1));
        ResourceLocation chosenId = ResourceLocation.tryParse((String)picked.entityId());
        for (int i = 0; i < count; ++i) {
            Entity e;
            int r = this.config.spawnOffset();
            int ox = rnd.nextInt(r * 2 + 1) - r;
            int oz = rnd.nextInt(r * 2 + 1) - r;
            BlockPos spawn = AmbushAddon.findGround(world, pos.offset(ox, 0, oz));
            EntityType type = AmbushAddon.resolveEntityType(chosenId);
            if (type == null) {
                type = EntityType.PILLAGER;
            }
            if ((e = type.create((Level)world)) == null) continue;
            if (e instanceof Mob) {
                Mob me = (Mob)e;
                me.finalizeSpawn((ServerLevelAccessor)world, world.getCurrentDifficultyAt(spawn), MobSpawnType.EVENT, null);
                me.moveTo(spawn, rnd.nextFloat() * 360.0f, 0.0f);
                world.addFreshEntity((Entity)me);
                if (i != 0 || !(me instanceof PatrollingMonster)) continue;
                PatrollingMonster pe = (PatrollingMonster)me;
                pe.setPatrolLeader(true);
                continue;
            }
            e.moveTo(spawn, rnd.nextFloat() * 360.0f, 0.0f);
            world.addFreshEntity(e);
        }
    }

    private static EntityType<?> resolveEntityType(ResourceLocation id) {
        if (id == null) {
            return null;
        }
        return BuiltInRegistries.ENTITY_TYPE.getOptional(id).orElse(null);
    }

    private static REConfig.SpawnSpec pickSpawn(REConfig cfg, RandomSource rnd) {
        List<REConfig.SpawnSpec> list = cfg.spawnSpecs();
        if (list == null || list.isEmpty()) {
            return new REConfig.SpawnSpec("minecraft:pillager", 100, 4, 5);
        }
        int total = 0;
        for (REConfig.SpawnSpec s : list) {
            if (s.weight() <= 0) continue;
            total += s.weight();
        }
        if (total <= 0) {
            return list.get(0);
        }
        int r = rnd.nextInt(total);
        int acc = 0;
        for (REConfig.SpawnSpec s : list) {
            if (s.weight() <= 0 || r >= (acc += s.weight())) continue;
            return s;
        }
        return list.get(0);
    }

    private static BlockPos findGround(ServerLevel world, BlockPos near) {
        int x = near.getX();
        int z = near.getZ();
        int y = CacheManager.getHeight((ServerLevel)world, (int)x, (int)z);
        return new BlockPos(x, y, z);
    }
}

