/*
 * Decompiled with CFR 0.152.
 */
package org.mrbonnieg.namebasedwhitelist;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.mrbonnieg.namebasedwhitelist.Main;

public class Commands
implements CommandExecutor,
TabCompleter {
    private final Main plugin;

    public Commands(Main plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String cmd;
        String noPermissions = ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("messages.no-permissions"));
        String playerAdd = ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("messages.player-add"));
        String playerRemove = ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("messages.player-remove"));
        String playerAlreadyExists = ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("messages.player-already-exists"));
        String playerNotFound = ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("messages.player-not-found"));
        String pluginReload = ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("messages.plugin-reload"));
        String pluginEnable = ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("messages.plugin-enable"));
        String pluginDisable = ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("messages.plugin-disable"));
        String pluginUsage = ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("messages.plugin-usage"));
        if (args.length == 0) {
            sender.sendMessage(pluginUsage);
            return true;
        }
        switch (cmd = args[0].toLowerCase()) {
            case "reload": {
                if (!sender.hasPermission("namebasedwhitelist.manage") || !sender.hasPermission("namebasedwhitelist.*")) {
                    sender.sendMessage(noPermissions);
                    return true;
                }
                this.plugin.reloadConfig();
                sender.sendMessage(pluginReload);
                return true;
            }
            case "add": {
                if (!sender.hasPermission("namebasedwhitelist.modify") || !sender.hasPermission("namebasedwhitelist.*")) {
                    sender.sendMessage(noPermissions);
                    return true;
                }
                String playerName = args[1].toLowerCase();
                if (this.plugin.getStorage().getPlayers().contains(playerName)) {
                    sender.sendMessage(playerAlreadyExists.replace("%player%", playerName));
                    return true;
                }
                this.plugin.getStorage().addPlayer(playerName);
                sender.sendMessage(playerAdd.replace("%player%", playerName));
                return true;
            }
            case "remove": {
                if (!sender.hasPermission("namebasedwhitelist.modify") || !sender.hasPermission("namebasedwhitelist.*")) {
                    sender.sendMessage(noPermissions);
                    return true;
                }
                String playerName = args[1].toLowerCase();
                if (!this.plugin.getStorage().getPlayers().contains(playerName)) {
                    sender.sendMessage(playerNotFound.replace("%player%", playerName));
                    return true;
                }
                this.plugin.getStorage().removePlayer(playerName);
                sender.sendMessage(playerRemove.replace("%player%", playerName));
                return true;
            }
            case "enable": {
                if (!sender.hasPermission("namebasedwhitelist.manage") || !sender.hasPermission("namebasedwhitelist.*")) {
                    sender.sendMessage(noPermissions);
                    return true;
                }
                this.plugin.config().set("settings.enable", (Object)true);
                this.plugin.saveConfig();
                sender.sendMessage(pluginEnable);
                return true;
            }
            case "disable": {
                if (!sender.hasPermission("namebasedwhitelist.manage") || !sender.hasPermission("namebasedwhitelist.*")) {
                    sender.sendMessage(noPermissions);
                    return true;
                }
                this.plugin.config().set("settings.enable", (Object)false);
                this.plugin.saveConfig();
                sender.sendMessage(pluginDisable);
                return true;
            }
        }
        sender.sendMessage(pluginUsage);
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            return Lists.newArrayList((Object[])new String[]{"add", "remove", "enable", "disable", "reload"});
        }
        if (args.length == 2 && (args[0].equalsIgnoreCase("add") || args[0].equalsIgnoreCase("remove"))) {
            ArrayList<String> playerNames = new ArrayList<String>();
            for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                playerNames.add(player.getName());
            }
            return playerNames;
        }
        return Lists.newArrayList();
    }
}

