/*
 * Decompiled with CFR 0.152.
 */
package org.mrbonnieg.namebasedwhitelist;

import java.io.File;
import java.util.logging.Level;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.mrbonnieg.namebasedwhitelist.Commands;
import org.mrbonnieg.namebasedwhitelist.Events;
import org.mrbonnieg.namebasedwhitelist.MySqlStorage;
import org.mrbonnieg.namebasedwhitelist.Storage;
import org.mrbonnieg.namebasedwhitelist.YamlStorage;

public final class Main
extends JavaPlugin {
    private FileConfiguration config;
    private Storage storage;

    public FileConfiguration config() {
        return this.config;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public void onEnable() {
        String storageType;
        this.saveResource("config.yml", false);
        this.config = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), "config.yml"));
        this.saveResource("whitelist.yml", false);
        this.getLogger().log(Level.INFO, "Plugin enabled");
        switch (storageType = this.config.getString("settings.storage-type", "yml")) {
            case "mysql": {
                this.storage = new MySqlStorage(this);
                this.getLogger().log(Level.INFO, "Storage type: MySql");
                break;
            }
            default: {
                this.storage = new YamlStorage(this);
                this.getLogger().log(Level.INFO, "Storage type: Yaml");
            }
        }
        this.getServer().getPluginManager().registerEvents((Listener)new Events(this), (Plugin)this);
        Commands commands = new Commands(this);
        this.getServer().getPluginCommand("nbwl").setExecutor((CommandExecutor)commands);
        this.getServer().getPluginCommand("nbwl").setTabCompleter((TabCompleter)commands);
    }

    public void onDisable() {
        this.getLogger().log(Level.INFO, "Plugin disabled");
    }
}

