/*
 * Decompiled with CFR 0.152.
 */
package org.mrbonnieg.namebasedwhitelist;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.mrbonnieg.namebasedwhitelist.Main;
import org.mrbonnieg.namebasedwhitelist.Storage;

public class MySqlStorage
implements Storage {
    private final Main plugin;
    private final String host;
    private final String database;
    private final String username;
    private final String password;
    private Connection connection;

    public MySqlStorage(Main plugin) {
        this.plugin = plugin;
        FileConfiguration config = plugin.getConfig();
        this.host = config.getString("database.host", "localhost:3306");
        this.database = config.getString("database.name", "database");
        this.username = config.getString("database.username", "root");
        this.password = config.getString("database.password", "");
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, this::initConnection);
    }

    private synchronized void initConnection() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                return;
            }
            Class.forName("com.mysql.cj.jdbc.Driver");
            String url = "jdbc:mysql://" + this.host + "/" + this.database + "?useSSL=false&allowPublicKeyRetrieval=true";
            this.connection = DriverManager.getConnection(url, this.username, this.password);
            this.createTableIfNotExists();
            this.plugin.getLogger().log(Level.INFO, "MySQL connection established.");
        }
        catch (SQLException exception) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not connect to MySQL database!", exception);
        }
        catch (ClassNotFoundException exception) {
            this.plugin.getLogger().log(Level.SEVERE, "MySQL JDBC driver not found!", exception);
        }
    }

    private void createTableIfNotExists() {
        try (Statement statement = this.getConnection().createStatement();){
            String sql = "CREATE TABLE IF NOT EXISTS whitelist (username VARCHAR(255) PRIMARY KEY);";
            statement.executeUpdate(sql);
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to create whitelist table!", e);
        }
    }

    private Connection getConnection() throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            this.initConnection();
        }
        return this.connection;
    }

    @Override
    public List<String> getPlayers() {
        ArrayList<String> whitelist = new ArrayList<String>();
        try (Connection conn = this.getConnection();
             Statement statement = conn.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT username FROM whitelist;");){
            while (resultSet.next()) {
                whitelist.add(resultSet.getString("username").toLowerCase());
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to load whitelist from MySQL!", e);
        }
        return whitelist;
    }

    @Override
    public boolean addPlayer(String username) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try (Connection conn = this.getConnection();
                 PreparedStatement statement = conn.prepareStatement("INSERT INTO whitelist (username) VALUES (?) ON DUPLICATE KEY UPDATE username = username;");){
                statement.setString(1, username.toLowerCase());
                statement.executeUpdate();
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to add player '" + username.toLowerCase() + "' to MySQL!", e);
            }
        });
        return true;
    }

    @Override
    public boolean removePlayer(String username) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try (Connection conn = this.getConnection();
                 PreparedStatement statement = conn.prepareStatement("DELETE FROM whitelist WHERE username = ?;");){
                statement.setString(1, username.toLowerCase());
                statement.executeUpdate();
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to remove player '" + username.toLowerCase() + "' from MySQL!", e);
            }
        });
        return true;
    }

    @Override
    public void saveWhitelist() {
    }
}

