/*
 * Decompiled with CFR 0.152.
 */
package org.mrbonnieg.namebasedwhitelist;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.mrbonnieg.namebasedwhitelist.Main;
import org.mrbonnieg.namebasedwhitelist.Storage;

public class YamlStorage
implements Storage {
    private final Main plugin;
    private final FileConfiguration whitelist;

    public YamlStorage(Main plugin) {
        this.plugin = plugin;
        this.whitelist = YamlConfiguration.loadConfiguration((File)new File(plugin.getDataFolder(), "whitelist.yml"));
    }

    @Override
    public List<String> getPlayers() {
        return this.whitelist.getStringList("players").stream().map(String::toLowerCase).toList();
    }

    @Override
    public boolean addPlayer(String username) {
        List<String> whitelistedPlayers = this.getPlayers();
        if (whitelistedPlayers.contains(username.toLowerCase())) {
            return false;
        }
        whitelistedPlayers.add(username.toLowerCase());
        this.whitelist.set("players", whitelistedPlayers);
        this.saveWhitelist();
        return true;
    }

    @Override
    public boolean removePlayer(String username) {
        List<String> whitelistedPlayers = this.getPlayers();
        if (!whitelistedPlayers.contains(username.toLowerCase())) {
            return false;
        }
        whitelistedPlayers.remove(username.toLowerCase());
        this.whitelist.set("players", whitelistedPlayers);
        this.saveWhitelist();
        return true;
    }

    @Override
    public void saveWhitelist() {
        try {
            this.whitelist.save(new File(this.plugin.getDataFolder(), "whitelist.yml"));
        }
        catch (IOException exception) {
            this.plugin.getLogger().severe("Failed to save whitelist.yml");
        }
    }
}

