/*
 * Decompiled with CFR 0.152.
 */
package com.nuclyon.technicallycoded.inventoryrollback.commands.inventoryrollback;

import com.nuclyon.technicallycoded.inventoryrollback.InventoryRollbackPlus;
import com.nuclyon.technicallycoded.inventoryrollback.commands.IRPCommand;
import com.nuclyon.technicallycoded.inventoryrollback.util.LegacyBackupConversionUtil;
import java.util.concurrent.atomic.AtomicBoolean;
import me.danjono.inventoryrollback.config.MessageData;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class ImportSubCmd
extends IRPCommand {
    private static final AtomicBoolean suggestConfirm = new AtomicBoolean(false);

    public ImportSubCmd(InventoryRollbackPlus mainIn) {
        super(mainIn);
    }

    @Override
    public void onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (sender.hasPermission("inventoryrollbackplus.import")) {
            if (args.length < 2 || !args[1].equalsIgnoreCase("confirm")) {
                sender.sendMessage(ChatColor.RED + "/" + label.toLowerCase() + " import " + ChatColor.BOLD + "confirm");
                suggestConfirm.set(true);
                this.main.getServer().getScheduler().runTaskLaterAsynchronously((Plugin)this.main, () -> suggestConfirm.set(false), 200L);
                return;
            }
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.main, LegacyBackupConversionUtil::convertOldBackupData);
            suggestConfirm.set(false);
            sender.sendMessage(MessageData.getPluginPrefix() + MessageData.getImportSuccess());
        } else {
            sender.sendMessage(MessageData.getPluginPrefix() + MessageData.getNoPermission());
        }
    }

    public static boolean shouldShowConfirmOption() {
        return suggestConfirm.get();
    }
}

