/*
 * Decompiled with CFR 0.152.
 */
package com.nuclyon.technicallycoded.inventoryrollback.customdata;

import com.nuclyon.technicallycoded.inventoryrollback.InventoryRollbackPlus;
import com.nuclyon.technicallycoded.inventoryrollback.customdata.CustomDataItemEditor;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class ModernPdcItemEditor
implements CustomDataItemEditor {
    private final ItemStack item;

    public ModernPdcItemEditor(ItemStack item) {
        this.item = item;
    }

    @Override
    public boolean hasUUID() {
        String uuid = this.getString("uuid");
        return uuid != null && !uuid.isEmpty();
    }

    @Override
    public ItemStack setString(String key, String data) {
        this.setData(key, PersistentDataType.STRING, data);
        return this.item;
    }

    @Override
    public ItemStack setInt(String key, Integer data) {
        this.setData(key, PersistentDataType.INTEGER, data);
        return this.item;
    }

    @Override
    public ItemStack setLong(String key, Long data) {
        this.setData(key, PersistentDataType.LONG, data);
        return this.item;
    }

    @Override
    public ItemStack setDouble(String key, Double data) {
        this.setData(key, PersistentDataType.DOUBLE, data);
        return this.item;
    }

    @Override
    public ItemStack setFloat(String key, Float data) {
        this.setData(key, PersistentDataType.FLOAT, data);
        return this.item;
    }

    @Override
    public String getString(String key) {
        return (String)this.getData(key, PersistentDataType.STRING);
    }

    @Override
    public int getInt(String key) {
        return (Integer)this.getData(key, PersistentDataType.INTEGER);
    }

    @Override
    public Long getLong(String key) {
        return (Long)this.getData(key, PersistentDataType.LONG);
    }

    @Override
    public double getDouble(String key) {
        return (Double)this.getData(key, PersistentDataType.DOUBLE);
    }

    @Override
    public Float getFloat(String key) {
        return (Float)this.getData(key, PersistentDataType.FLOAT);
    }

    @Override
    public ItemStack setItemData() {
        return this.item;
    }

    private <T> T getData(String key, PersistentDataType<T, T> type) {
        NamespacedKey namedKey;
        if (this.item == null) {
            return null;
        }
        ItemMeta itemMeta = this.item.getItemMeta();
        PersistentDataContainer pdc = itemMeta.getPersistentDataContainer();
        if (!pdc.has(namedKey = ModernPdcItemEditor.getNamespacedKey(key), type)) {
            return null;
        }
        return (T)pdc.get(namedKey, type);
    }

    private <T> void setData(String key, PersistentDataType<T, T> type, T data) {
        if (this.item == null) {
            return;
        }
        ItemMeta itemMeta = this.item.getItemMeta();
        PersistentDataContainer pdc = itemMeta.getPersistentDataContainer();
        pdc.set(ModernPdcItemEditor.getNamespacedKey(key), type, data);
        this.item.setItemMeta(itemMeta);
    }

    @NotNull
    private static NamespacedKey getNamespacedKey(String key) {
        return new NamespacedKey((Plugin)InventoryRollbackPlus.getInstance(), key);
    }
}

