/*
 * Decompiled with CFR 0.152.
 */
package com.nuclyon.technicallycoded.inventoryrollback.util;

import com.nuclyon.technicallycoded.inventoryrollback.util.LogTimestamps;
import java.util.HashMap;
import me.danjono.inventoryrollback.data.LogType;

public class UserLogRateLimiter {
    private static final long TICK_DURATION = 50L;
    private static final long BUFFER = Math.round(10.0);
    private static final long MIN_INTERVAL_FROM_START_OF_LOG = (50L - BUFFER) * 5L;
    HashMap<LogType, LogTimestamps> saveLogs = new HashMap();

    public void log(LogType logType, Long timestamp) {
        LogTimestamps logTimestamps = this.saveLogs.get((Object)logType);
        if (logTimestamps == null) {
            logTimestamps = new LogTimestamps();
            this.saveLogs.put(logType, logTimestamps);
        }
        logTimestamps.log(timestamp);
    }

    public boolean isRateLimitExceeded(LogType logType) {
        LogTimestamps logTimestamps = this.saveLogs.get((Object)logType);
        if (logTimestamps == null) {
            return false;
        }
        if (!logTimestamps.isFull()) {
            return false;
        }
        Long first = logTimestamps.getFirst();
        if (first == null) {
            return false;
        }
        return System.currentTimeMillis() - first < MIN_INTERVAL_FROM_START_OF_LOG;
    }
}

