/*
 * Decompiled with CFR 0.152.
 */
package com.nuclyon.technicallycoded.inventoryrollback.util.serialization;

import com.nuclyon.technicallycoded.inventoryrollback.util.serialization.DeserializationResult;
import com.nuclyon.technicallycoded.inventoryrollback.util.serialization.Version1Serialization;
import com.nuclyon.technicallycoded.inventoryrollback.util.serialization.Version2Serialization;
import com.nuclyon.technicallycoded.inventoryrollback.util.serialization.Version3Serialization;
import java.util.Base64;
import org.bukkit.inventory.ItemStack;

public class ItemStackSerialization {
    private static final String MODERN_SERIALIZATION_PREFIX = "IRP_VERSION:";

    public static String serialize(ItemStack[] items) {
        String serialized = Version3Serialization.serialize(items);
        String data = "IRP_VERSION:3:" + serialized;
        return Base64.getEncoder().encodeToString(data.getBytes());
    }

    public static DeserializationResult deserializeData(String packageVersion, String data) {
        if (data == null) {
            return new DeserializationResult(null, "Data is null");
        }
        String decodedString = null;
        try {
            byte[] decodedBytes = Base64.getDecoder().decode(data);
            decodedString = new String(decodedBytes);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String version = "1";
        String unprefixedData = data;
        if (decodedString != null && decodedString.startsWith(MODERN_SERIALIZATION_PREFIX)) {
            int prefixLen = MODERN_SERIALIZATION_PREFIX.length();
            version = decodedString.substring(prefixLen, prefixLen + 1);
            unprefixedData = decodedString.substring(prefixLen + 2);
        }
        switch (version) {
            case "1": {
                return new DeserializationResult(Version1Serialization.stacksFromBase64(packageVersion, unprefixedData), "");
            }
            case "2": {
                return Version2Serialization.deserialize(unprefixedData);
            }
            case "3": {
                return Version3Serialization.deserialize(unprefixedData);
            }
        }
        return new DeserializationResult(null, "Unsupported serialization version: " + version);
    }
}

