/*
 * Decompiled with CFR 0.152.
 */
package me.danjono.inventoryrollback;

import com.nuclyon.technicallycoded.inventoryrollback.InventoryRollbackPlus;
import java.sql.SQLException;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.danjono.inventoryrollback.UpdateChecker;
import me.danjono.inventoryrollback.commands.Commands;
import me.danjono.inventoryrollback.config.ConfigData;
import me.danjono.inventoryrollback.config.MessageData;
import me.danjono.inventoryrollback.config.SoundData;
import me.danjono.inventoryrollback.data.MySQL;
import me.danjono.inventoryrollback.data.YAML;
import me.danjono.inventoryrollback.listeners.ClickGUI;
import me.danjono.inventoryrollback.listeners.EventLogs;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class InventoryRollback
extends JavaPlugin {
    private static final Logger logger = Logger.getLogger("Minecraft");
    private static InventoryRollback instance;
    private static String packageVersion;

    public static Logger getPluginLogger() {
        return logger;
    }

    public static void setInstance(InventoryRollback plugin) {
        instance = plugin;
    }

    public static InventoryRollback getInstance() {
        return InventoryRollbackPlus.getInstance();
    }

    public static void setPackageVersion(String version) {
        packageVersion = version;
    }

    public static String getPackageVersion() {
        return packageVersion;
    }

    public static String getPluginVersion() {
        return instance.getDescription().getVersion();
    }

    public void onEnable() {
        InventoryRollback.setInstance(this);
        InventoryRollback.setPackageVersion(Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3]);
        this.startupTasks();
        if (ConfigData.isbStatsEnabled()) {
            this.bStats();
        }
        Objects.requireNonNull(this.getCommand("inventoryrollback")).setExecutor((CommandExecutor)new Commands());
        this.getServer().getPluginManager().registerEvents((Listener)new ClickGUI(), (Plugin)instance);
        this.getServer().getPluginManager().registerEvents((Listener)new EventLogs(), (Plugin)instance);
    }

    public void onDisable() {
        InventoryRollback.setInstance(null);
    }

    public void startupTasks() {
        if (ConfigData.getSaveType() == ConfigData.SaveType.YAML) {
            YAML.createStorageFolders();
        } else if (ConfigData.getSaveType() == ConfigData.SaveType.MYSQL) {
            try {
                new MySQL(null, null, 0L).createTables();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        new MessageData().setMessages();
        new SoundData().setSounds();
        InventoryRollbackPlus.getInstance().getConsoleSender().sendMessage(MessageData.getPluginPrefix() + "Inventory backup data is set to save to: " + ConfigData.getSaveType().getName());
        if (ConfigData.isUpdateCheckerEnabled()) {
            InventoryRollback.getInstance().checkUpdate();
        }
    }

    public abstract boolean isCompatibleCb(String var1);

    public void bStats() {
    }

    public void checkUpdate() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)InventoryRollback.getInstance(), () -> {
            logger.log(Level.INFO, MessageData.getPluginPrefix() + "Checking for updates...");
            UpdateChecker.UpdateResult result = new UpdateChecker(InventoryRollback.getInstance(), 85811).getResult();
            switch (result) {
                case FAIL_SPIGOT: {
                    logger.log(Level.INFO, MessageData.getPluginPrefix() + "Could not contact Spigot to check if an update is available.");
                    break;
                }
                case UPDATE_AVAILABLE: {
                    logger.log(Level.INFO, ChatColor.AQUA + "======================================================================================");
                    logger.log(Level.INFO, ChatColor.AQUA + "An update to InventoryRollbackPlus is available!");
                    logger.log(Level.INFO, ChatColor.AQUA + "Download at https://www.spigotmc.org/resources/inventoryrollback-plus-1-8-1-16-x.85811/");
                    logger.log(Level.INFO, ChatColor.AQUA + "======================================================================================");
                    break;
                }
                case NO_UPDATE: {
                    logger.log(Level.INFO, MessageData.getPluginPrefix() + ChatColor.AQUA + "You are running the latest version.");
                    break;
                }
            }
        });
    }
}

