/*
 * Decompiled with CFR 0.152.
 */
package me.danjono.inventoryrollback.config;

import com.nuclyon.technicallycoded.inventoryrollback.InventoryRollbackPlus;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.logging.Level;
import me.danjono.inventoryrollback.InventoryRollback;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigData {
    private File configurationFile;
    private FileConfiguration configuration;
    private static final String configurationFileName = "config.yml";
    private static boolean pluginEnabled;
    private static SaveType saveType;
    private static File folderLocation;
    private static boolean mysqlEnabled;
    private static String mysqlHost;
    private static int mysqlPort;
    private static String mysqlDatabase;
    private static String mysqlTablePrefix;
    private static String mysqlUsername;
    private static String mysqlPassword;
    private static boolean mysqlUseSSL;
    private static boolean mysqlVerifyCertificate;
    private static boolean mysqlPubKeyRetrieval;
    private static boolean allowOtherPluginEditDeathInventory;
    private static boolean restoreToPlayerButton;
    private static int backupLinesVisible;
    private static int maxSavesJoin;
    private static int maxSavesQuit;
    private static int maxSavesDeath;
    private static int maxSavesWorldChange;
    private static int maxSavesForce;
    private static long timeZoneOffsetMillis;
    private static TimeZone timeZone;
    private static String timeZoneName;
    private static SimpleDateFormat timeFormat;
    private static boolean updateChecker;
    private static boolean bStatsEnabled;
    private static boolean debugEnabled;
    private boolean saveChanges = false;

    public ConfigData() {
        this.generateConfigFile();
    }

    public void generateConfigFile() {
        this.getConfigurationFile();
        if (!this.configurationFile.exists()) {
            InventoryRollback.getInstance().saveResource(configurationFileName, false);
            this.getConfigurationFile();
        }
        this.getConfigData();
    }

    private void getConfigurationFile() {
        this.configurationFile = new File(InventoryRollback.getInstance().getDataFolder(), configurationFileName);
    }

    private void getConfigData() {
        this.configuration = YamlConfiguration.loadConfiguration((File)this.configurationFile);
    }

    public boolean saveConfig() {
        try {
            this.configuration.save(this.configurationFile);
        }
        catch (IOException e) {
            InventoryRollback.getInstance().getLogger().log(Level.SEVERE, "Could not save data to config file", e);
            return false;
        }
        this.saveChanges = false;
        return true;
    }

    public void setVariables() {
        ConfigData.setEnabled((Boolean)this.getDefaultValue("enabled", true));
        String folder = (String)this.getDefaultValue("folder-location", "DEFAULT");
        if (folder.equalsIgnoreCase("DEFAULT") || folder.isEmpty()) {
            ConfigData.setFolderLocation(InventoryRollback.getInstance().getDataFolder());
        } else {
            try {
                ConfigData.setFolderLocation(new File(folder));
            }
            catch (NullPointerException e) {
                InventoryRollback.getInstance().getLogger().log(Level.WARNING, "Could not save set data folder to \"" + folder + "\". Setting to default location in plugin folder.", e);
                ConfigData.setFolderLocation(InventoryRollback.getInstance().getDataFolder());
            }
        }
        ConfigData.setMySQLEnabled((Boolean)this.getDefaultValue("mysql.enabled", false));
        if (ConfigData.isMySQLEnabled()) {
            ConfigData.setSaveType(SaveType.MYSQL);
        } else {
            ConfigData.setSaveType(SaveType.YAML);
        }
        ConfigData.setMySQLHost((String)this.getDefaultValue("mysql.details.host", "127.0.0.1"));
        ConfigData.setMySQLPort((Integer)this.getDefaultValue("mysql.details.port", 3306));
        ConfigData.setMySQLDatabase((String)this.getDefaultValue("mysql.details.database", "inventory_rollback"));
        ConfigData.setMySQLTablePrefix((String)this.getDefaultValue("mysql.details.table-prefix", "backup_"));
        ConfigData.setMySQLUsername((String)this.getDefaultValue("mysql.details.username", "username"));
        ConfigData.setMySQLPassword((String)this.getDefaultValue("mysql.details.password", "password"));
        ConfigData.setMySQLUseSSL((Boolean)this.getDefaultValue("mysql.details.use-SSL", true));
        ConfigData.setMySQLVerifyCertificate((Boolean)this.getDefaultValue("mysql.details.verifyCertificate", true));
        ConfigData.setMysqlPubKeyRetrievalAllowed((Boolean)this.getDefaultValue("mysql.details.allowPubKeyRetrieval", false));
        ConfigData.setAllowOtherPluginEditDeathInventory((Boolean)this.getDefaultValue("allow-other-plugins-edit-death-inventory", false));
        ConfigData.setRestoreToPlayerButton((Boolean)this.getDefaultValue("restore-to-player-button", true));
        ConfigData.setBackupLinesVisible((Integer)this.getDefaultValue("backup-lines-visible", 1));
        ConfigData.setMaxSavesJoin((Integer)this.getDefaultValue("max-saves.join", 10));
        ConfigData.setMaxSavesQuit((Integer)this.getDefaultValue("max-saves.quit", 10));
        ConfigData.setMaxSavesDeath((Integer)this.getDefaultValue("max-saves.death", 50));
        ConfigData.setMaxSavesWorldChange((Integer)this.getDefaultValue("max-saves.world-change", 10));
        ConfigData.setMaxSavesForce((Integer)this.getDefaultValue("max-saves.force", 10));
        ConfigData.setTimeZone((String)this.getDefaultValue("time-zone", "GMT"));
        ConfigData.setTimeFormat((String)this.getDefaultValue("time-format", "dd/MM/yyyy HH:mm:ss a"));
        ConfigData.setUpdateChecker((Boolean)this.getDefaultValue("update-checker", true));
        ConfigData.setbStatsEnabled((Boolean)this.getDefaultValue("bStats", true));
        ConfigData.setDebugEnabled((Boolean)this.getDefaultValue("debug", false));
        if (this.saveChanges()) {
            this.saveConfig();
        }
    }

    public static void setEnabled(boolean enabled) {
        pluginEnabled = enabled;
    }

    public static void setSaveType(SaveType value) {
        saveType = value;
    }

    public static void setFolderLocation(File folder) {
        folderLocation = folder;
    }

    public static void setMySQLEnabled(boolean value) {
        mysqlEnabled = value;
    }

    public static void setMySQLHost(String value) {
        mysqlHost = value;
    }

    public static void setMySQLPort(int value) {
        mysqlPort = value;
    }

    public static void setMySQLDatabase(String value) {
        mysqlDatabase = value;
    }

    public static void setMySQLTablePrefix(String value) {
        mysqlTablePrefix = value;
    }

    public static void setMySQLUsername(String value) {
        mysqlUsername = value;
    }

    public static void setMySQLPassword(String value) {
        mysqlPassword = value;
    }

    public static void setMySQLUseSSL(boolean value) {
        mysqlUseSSL = value;
    }

    public static void setMySQLVerifyCertificate(boolean value) {
        mysqlVerifyCertificate = value;
    }

    public static void setMysqlPubKeyRetrievalAllowed(boolean value) {
        mysqlPubKeyRetrieval = value;
    }

    public static void setRestoreToPlayerButton(boolean value) {
        restoreToPlayerButton = value;
    }

    public static void setAllowOtherPluginEditDeathInventory(boolean value) {
        allowOtherPluginEditDeathInventory = value;
    }

    public static void setBackupLinesVisible(int value) {
        backupLinesVisible = value <= 0 ? 1 : (value > 5 ? 5 : value);
    }

    public static void setMaxSavesJoin(int value) {
        maxSavesJoin = value;
    }

    public static void setMaxSavesQuit(int value) {
        maxSavesQuit = value;
    }

    public static void setMaxSavesDeath(int value) {
        maxSavesDeath = value;
    }

    public static void setMaxSavesWorldChange(int value) {
        maxSavesWorldChange = value;
    }

    public static void setMaxSavesForce(int value) {
        maxSavesForce = value;
    }

    public static void setTimeZone(String zone) {
        try {
            if (zone.length() > 3 && zone.startsWith("UTC")) {
                zone = "GMT" + zone.substring(3);
            }
            timeZone = TimeZone.getTimeZone(zone);
            timeZoneName = zone;
            timeZoneOffsetMillis = InventoryRollbackPlus.getInstance().getTimeZoneUtil().getMillisOffsetAtTimeZone(zone);
        }
        catch (IllegalArgumentException | NullPointerException ex) {
            ex.printStackTrace();
            timeZoneOffsetMillis = 0L;
            InventoryRollback.getInstance().getLogger().log(Level.WARNING, "Time zone \"" + zone + "\" in config.yml is invalid. Defaulting to \"UTC\"");
        }
    }

    public static void setTimeFormat(String format) {
        try {
            timeFormat = new SimpleDateFormat(format);
        }
        catch (IllegalArgumentException e) {
            timeFormat = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss a z");
            InventoryRollback.getInstance().getLogger().log(Level.WARNING, "Time zone format \"" + format + "\" in config.yml is not valid. Defaulting to \"dd/MM/yyyy hh:mm:ss a z\"");
        }
    }

    public static void setUpdateChecker(boolean enabled) {
        updateChecker = enabled;
    }

    public static void setbStatsEnabled(boolean enabled) {
        bStatsEnabled = enabled;
    }

    public static void setDebugEnabled(boolean enabled) {
        debugEnabled = enabled;
    }

    public static boolean isEnabled() {
        return pluginEnabled;
    }

    public static SaveType getSaveType() {
        return saveType;
    }

    public static File getFolderLocation() {
        return folderLocation;
    }

    public static boolean isMySQLEnabled() {
        return mysqlEnabled;
    }

    public static String getMySQLHost() {
        return mysqlHost;
    }

    public static int getMySQLPort() {
        return mysqlPort;
    }

    public static String getMySQLDatabase() {
        return mysqlDatabase;
    }

    public static String getMySQLTablePrefix() {
        return mysqlTablePrefix;
    }

    public static String getMySQLUsername() {
        return mysqlUsername;
    }

    public static String getMySQLPassword() {
        return mysqlPassword;
    }

    public static boolean isMySQLUseSSL() {
        return mysqlUseSSL;
    }

    public static boolean isMySQLVerifyCertificate() {
        return mysqlVerifyCertificate;
    }

    public static boolean isMySQLPubKeyRetrievalAllowed() {
        return mysqlPubKeyRetrieval;
    }

    public static boolean isRestoreToPlayerButton() {
        return restoreToPlayerButton;
    }

    public static boolean isAllowOtherPluginEditDeathInventory() {
        return allowOtherPluginEditDeathInventory;
    }

    public static int getBackupLinesVisible() {
        return backupLinesVisible;
    }

    public static int getMaxSavesJoin() {
        return maxSavesJoin;
    }

    public static int getMaxSavesQuit() {
        return maxSavesQuit;
    }

    public static int getMaxSavesDeath() {
        return maxSavesDeath;
    }

    public static int getMaxSavesWorldChange() {
        return maxSavesWorldChange;
    }

    public static int getMaxSavesForce() {
        return maxSavesForce;
    }

    public static long getTimeZoneOffsetMillis() {
        return timeZoneOffsetMillis;
    }

    public static TimeZone getTimeZone() {
        return timeZone;
    }

    public static SimpleDateFormat getTimeFormat() {
        return timeFormat;
    }

    public static boolean isUpdateCheckerEnabled() {
        return updateChecker;
    }

    public static boolean isbStatsEnabled() {
        return bStatsEnabled;
    }

    public static boolean isDebugEnabled() {
        return debugEnabled;
    }

    public Object getDefaultValue(String path, Object defaultValue) {
        Object obj = this.configuration.get(path);
        if (obj == null) {
            obj = defaultValue;
            this.configuration.set(path, defaultValue);
            this.saveChanges = true;
        }
        return obj;
    }

    private boolean saveChanges() {
        return this.saveChanges;
    }

    static {
        saveType = SaveType.YAML;
        folderLocation = InventoryRollback.getInstance().getDataFolder();
    }

    public static enum SaveType {
        YAML("YAML"),
        MYSQL("MySQL");

        private final String name;

        private SaveType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

