/*
 * Decompiled with CFR 0.152.
 */
package me.danjono.inventoryrollback.data;

import com.nuclyon.technicallycoded.inventoryrollback.InventoryRollbackPlus;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.danjono.inventoryrollback.InventoryRollback;
import me.danjono.inventoryrollback.config.ConfigData;
import me.danjono.inventoryrollback.config.MessageData;
import me.danjono.inventoryrollback.data.LogType;
import me.danjono.inventoryrollback.data.YAML;
import me.danjono.inventoryrollback.gui.InventoryName;
import me.danjono.inventoryrollback.inventory.RestoreInventory;
import me.danjono.inventoryrollback.inventory.SaveInventory;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.inventory.ItemStack;

public class MySQL {
    private final UUID uuid;
    private final Long timestamp;
    private final BackupTable backupTable;
    private Connection connection;
    private String mainInventory;
    private String armour;
    private String enderChest;
    private float xp;
    private double health;
    private int hunger;
    private float saturation;
    private String world;
    private double x;
    private double y;
    private double z;
    private final LogType logType;
    private String packageVersion;
    private String deathReason;

    public MySQL(UUID uuid, LogType logType, Long timestamp) {
        this.uuid = uuid;
        this.logType = logType;
        this.timestamp = timestamp;
        this.backupTable = this.getBackupTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openConnection() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            return;
        }
        MySQL mySQL = this;
        synchronized (mySQL) {
            this.connection = DriverManager.getConnection("jdbc:mysql://" + ConfigData.getMySQLHost() + ":" + ConfigData.getMySQLPort() + "/" + ConfigData.getMySQLDatabase() + "?connectionTimeout=30000&socketTimeout=45000&useSSL=" + ConfigData.isMySQLUseSSL() + "&verifyServerCertificate=" + ConfigData.isMySQLVerifyCertificate() + "&allowPublicKeyRetrieval=" + ConfigData.isMySQLPubKeyRetrievalAllowed() + "&characterEncoding=UTF-8", ConfigData.getMySQLUsername(), ConfigData.getMySQLPassword());
        }
    }

    public void closeConnection() throws SQLException {
        this.connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTables() throws SQLException {
        this.openConnection();
        try {
            for (BackupTable table : BackupTable.values()) {
                String tableQuery = "CREATE TABLE IF NOT EXISTS " + table.getTableName() + " (`id` INT NOT NULL AUTO_INCREMENT,`uuid` VARCHAR(36) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,`timestamp` DOUBLE NOT NULL,`xp` FLOAT NOT NULL,`health` DOUBLE NOT NULL,`hunger` INT NOT NULL,`saturation` FLOAT NOT NULL,`location_world` TEXT CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,`location_x` DOUBLE NOT NULL,`location_y` DOUBLE NOT NULL,`location_z` DOUBLE NOT NULL,`version` TEXT CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,`death_reason` TEXT CHARACTER SET utf8 COLLATE utf8_general_ci,`main_inventory` LONGTEXT CHARACTER SET utf8 COLLATE utf8_general_ci,`armour` LONGTEXT CHARACTER SET utf8 COLLATE utf8_general_ci,`ender_chest` LONGTEXT CHARACTER SET utf8 COLLATE utf8_general_ci,PRIMARY KEY (`id`));";
                try (PreparedStatement statement = this.connection.prepareStatement(tableQuery);){
                    statement.executeUpdate();
                }
            }
        }
        finally {
            this.closeConnection();
        }
    }

    private BackupTable getBackupTable() {
        if (this.logType == LogType.JOIN) {
            return BackupTable.JOIN;
        }
        if (this.logType == LogType.QUIT) {
            return BackupTable.QUIT;
        }
        if (this.logType == LogType.DEATH) {
            return BackupTable.DEATH;
        }
        if (this.logType == LogType.WORLD_CHANGE) {
            return BackupTable.WORLD_CHANGE;
        }
        if (this.logType == LogType.FORCE) {
            return BackupTable.FORCE;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public boolean doesBackupTypeExist() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public int getAmountOfBackups() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getSelectedPageTimestamps(int pageNumber) throws SQLException {
        this.openConnection();
        ArrayList<Long> timeStamps = new ArrayList<Long>();
        int backups = InventoryName.ROLLBACK_LIST.getSize() - 9;
        try {
            int queryRange = (pageNumber - 1) * backups;
            if (queryRange < 0) {
                queryRange = 0;
            }
            String query = "SELECT timestamp FROM " + this.backupTable.getTableName() + " WHERE uuid = ? ORDER BY timestamp DESC LIMIT " + queryRange + ", " + backups + "";
            try (PreparedStatement statement = this.connection.prepareStatement(query);){
                statement.setString(1, this.uuid + "");
                try (ResultSet results = statement.executeQuery();){
                    while (results.next()) {
                        timeStamps.add(results.getLong(1));
                    }
                }
            }
            ArrayList<Long> arrayList = timeStamps;
            return arrayList;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeExcessSaves(int deleteAmount) throws SQLException {
        this.openConnection();
        try {
            String delete = "DELETE FROM " + this.backupTable.getTableName() + " WHERE uuid = ? ORDER BY timestamp ASC LIMIT " + deleteAmount;
            try (PreparedStatement statement = this.connection.prepareStatement(delete);){
                statement.setString(1, this.uuid.toString());
                statement.executeUpdate();
            }
        }
        finally {
            this.closeConnection();
        }
    }

    public void setMainInventory(ItemStack[] items) {
        this.mainInventory = SaveInventory.toBase64(items);
    }

    public void setArmour(ItemStack[] items) {
        this.armour = SaveInventory.toBase64(items);
    }

    public void setEnderChest(ItemStack[] items) {
        this.enderChest = SaveInventory.toBase64(items);
    }

    public void setXP(float xp) {
        this.xp = xp;
    }

    public void setHealth(double health) {
        this.health = health;
    }

    public void setFoodLevel(int foodLevel) {
        this.hunger = foodLevel;
    }

    public void setSaturation(float saturation) {
        this.saturation = saturation;
    }

    public void setWorld(String world) {
        this.world = world;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public void setVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    public void setDeathReason(String deathReason) {
        this.deathReason = deathReason;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRollbackMenuData() throws SQLException {
        this.openConnection();
        try {
            String query = "SELECT timestamp,death_reason,location_world,location_x,location_y,location_z FROM " + this.backupTable.getTableName() + " WHERE uuid = ? AND timestamp = ?";
            try (PreparedStatement statement = this.connection.prepareStatement(query);){
                statement.setString(1, this.uuid + "");
                statement.setLong(2, this.timestamp);
                try (ResultSet results = statement.executeQuery();){
                    results.next();
                    this.world = results.getString("location_world");
                    this.x = results.getDouble("location_x");
                    this.y = results.getDouble("location_y");
                    this.z = results.getDouble("location_z");
                    this.deathReason = results.getString("death_reason");
                }
            }
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAllBackupData() throws SQLException {
        this.openConnection();
        try {
            String query = "SELECT * FROM " + this.backupTable.getTableName() + " WHERE uuid = ? AND timestamp = ?";
            try (PreparedStatement statement = this.connection.prepareStatement(query);){
                statement.setString(1, this.uuid + "");
                statement.setLong(2, this.timestamp);
                try (ResultSet results = statement.executeQuery();){
                    results.next();
                    this.mainInventory = results.getString("main_inventory");
                    this.armour = results.getString("armour");
                    this.enderChest = results.getString("ender_chest");
                    this.xp = results.getFloat("xp");
                    this.health = results.getDouble("health");
                    this.hunger = results.getInt("hunger");
                    this.saturation = results.getFloat("saturation");
                    this.world = results.getString("location_world");
                    this.x = results.getDouble("location_x");
                    this.y = results.getDouble("location_y");
                    this.z = results.getDouble("location_z");
                    this.packageVersion = results.getString("version");
                    this.deathReason = results.getString("death_reason");
                }
            }
        }
        finally {
            this.closeConnection();
        }
    }

    public ItemStack[] getMainInventory() {
        return RestoreInventory.getInventoryItems(this.packageVersion, this.mainInventory);
    }

    public ItemStack[] getArmour() {
        return RestoreInventory.getInventoryItems(this.packageVersion, this.armour);
    }

    public ItemStack[] getEnderChest() {
        return RestoreInventory.getInventoryItems(this.packageVersion, this.enderChest);
    }

    public float getXP() {
        return this.xp;
    }

    public double getHealth() {
        return this.health;
    }

    public int getFoodLevel() {
        return this.hunger;
    }

    public float getSaturation() {
        return this.saturation;
    }

    public String getWorld() {
        return this.world;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public String getVersion() {
        return this.packageVersion;
    }

    public String getDeathReason() {
        return this.deathReason;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveData() throws SQLException {
        this.openConnection();
        try {
            String update = "INSERT INTO " + this.backupTable.getTableName() + " (uuid, timestamp, xp, health, hunger, saturation, location_world, location_x, location_y, location_z, version, death_reason, main_inventory, armour, ender_chest) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            try (PreparedStatement statement = this.connection.prepareStatement(update);){
                statement.setString(1, this.uuid + "");
                statement.setLong(2, this.timestamp);
                statement.setFloat(3, this.xp);
                statement.setDouble(4, this.health);
                statement.setInt(5, this.hunger);
                statement.setFloat(6, this.saturation);
                statement.setString(7, this.world);
                statement.setDouble(8, this.x);
                statement.setDouble(9, this.y);
                statement.setDouble(10, this.z);
                statement.setString(11, this.packageVersion);
                statement.setString(12, this.deathReason);
                statement.setString(13, this.mainInventory);
                statement.setString(14, this.armour);
                statement.setString(15, this.enderChest);
                statement.executeUpdate();
            }
        }
        finally {
            this.closeConnection();
        }
    }

    public static void convertYAMLToMySQL() {
        ArrayList<File> backupLocations = new ArrayList<File>();
        File backupArea = new File(ConfigData.getFolderLocation().getAbsoluteFile(), YAML.getBackupFolderName());
        backupLocations.add(new File(backupArea, "deaths"));
        backupLocations.add(new File(backupArea, "joins"));
        backupLocations.add(new File(backupArea, "quits"));
        backupLocations.add(new File(backupArea, "worldChanges"));
        backupLocations.add(new File(backupArea, "force"));
        ArrayList<LogType> logTypeFiles = new ArrayList<LogType>();
        int logTypeNumber = 0;
        logTypeFiles.add(LogType.DEATH);
        logTypeFiles.add(LogType.JOIN);
        logTypeFiles.add(LogType.QUIT);
        logTypeFiles.add(LogType.WORLD_CHANGE);
        logTypeFiles.add(LogType.FORCE);
        for (File backupType : backupLocations) {
            File[] uuidBackups;
            LogType logType = (LogType)((Object)logTypeFiles.get(logTypeNumber));
            InventoryRollbackPlus.getInstance().getConsoleSender().sendMessage(MessageData.getPluginPrefix() + "Converting the backup location " + logType.name());
            if (backupType == null || (uuidBackups = backupType.listFiles()) == null) continue;
            for (File UUIDBackup : uuidBackups) {
                UUID uuid = UUID.fromString(UUIDBackup.getName());
                File[] backups = UUIDBackup.listFiles();
                if (backups == null) continue;
                for (File backup : backups) {
                    int pos = backup.getName().lastIndexOf(".");
                    String fileName = backup.getName().substring(0, pos);
                    if (!StringUtils.isNumeric(fileName)) continue;
                    Long timestamp = Long.parseLong(fileName);
                    YAML yaml = new YAML(uuid, logType, timestamp);
                    MySQL mysql = new MySQL(uuid, logType, timestamp);
                    mysql.setMainInventory(yaml.getMainInventory());
                    mysql.setArmour(yaml.getArmour());
                    mysql.setEnderChest(yaml.getEnderChest());
                    mysql.setXP(yaml.getXP());
                    mysql.setHealth(yaml.getHealth());
                    mysql.setFoodLevel(yaml.getFoodLevel());
                    mysql.setSaturation(yaml.getSaturation());
                    mysql.setWorld(yaml.getWorld());
                    mysql.setX(yaml.getX());
                    mysql.setY(yaml.getY());
                    mysql.setZ(yaml.getZ());
                    mysql.setVersion(yaml.getVersion());
                    mysql.setDeathReason(yaml.getDeathReason());
                    try {
                        mysql.saveData();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
            ++logTypeNumber;
        }
        InventoryRollback.getPluginLogger().info(MessageData.getPluginPrefix() + "Conversion completed!");
    }

    public static enum BackupTable {
        DEATH(ConfigData.getMySQLTablePrefix() + "deaths"),
        JOIN(ConfigData.getMySQLTablePrefix() + "joins"),
        QUIT(ConfigData.getMySQLTablePrefix() + "quits"),
        WORLD_CHANGE(ConfigData.getMySQLTablePrefix() + "world_changes"),
        FORCE(ConfigData.getMySQLTablePrefix() + "force_backups");

        private final String tableName;

        private BackupTable(String tableName) {
            this.tableName = tableName;
        }

        public String getTableName() {
            return this.tableName;
        }
    }
}

