/*
 * Decompiled with CFR 0.152.
 */
package me.danjono.inventoryrollback.data;

import com.nuclyon.technicallycoded.inventoryrollback.InventoryRollbackPlus;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import me.danjono.inventoryrollback.config.ConfigData;
import me.danjono.inventoryrollback.config.MessageData;
import me.danjono.inventoryrollback.data.LogType;
import me.danjono.inventoryrollback.gui.InventoryName;
import me.danjono.inventoryrollback.inventory.RestoreInventory;
import me.danjono.inventoryrollback.inventory.SaveInventory;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;

public class YAML {
    private final UUID uuid;
    private final Long timestamp;
    private final File playerBackupFolder;
    private final File backupFile;
    private final YamlConfiguration data;
    private String mainInventory;
    private String armour;
    private String enderChest;
    private float xp;
    private double health;
    private int hunger;
    private float saturation;
    private String world;
    private double x;
    private double y;
    private double z;
    private LogType logType;
    private String packageVersion;
    private String deathReason;
    private static final String backupFolderName = "backups";

    public YAML(UUID uuid, LogType logType, Long timestampIn) {
        this.uuid = uuid;
        this.logType = logType;
        this.timestamp = timestampIn;
        this.playerBackupFolder = YAML.getPlayerBackupLocation(logType, uuid);
        this.backupFile = new File(this.playerBackupFolder, this.timestamp + ".yml");
        this.data = YamlConfiguration.loadConfiguration((File)this.backupFile);
    }

    public static void createStorageFolders() {
        File forceSavesFolder;
        File worldChangesFolder;
        File deathsFolder;
        File quitsFolder;
        File joinsFolder;
        File savesFolder = new File(ConfigData.getFolderLocation().getAbsoluteFile(), backupFolderName);
        if (!savesFolder.exists()) {
            savesFolder.mkdir();
        }
        if (!(joinsFolder = new File(savesFolder, "joins")).exists()) {
            joinsFolder.mkdir();
        }
        if (!(quitsFolder = new File(savesFolder, "quits")).exists()) {
            quitsFolder.mkdir();
        }
        if (!(deathsFolder = new File(savesFolder, "deaths")).exists()) {
            deathsFolder.mkdir();
        }
        if (!(worldChangesFolder = new File(savesFolder, "worldChanges")).exists()) {
            worldChangesFolder.mkdir();
        }
        if (!(forceSavesFolder = new File(savesFolder, "force")).exists()) {
            forceSavesFolder.mkdir();
        }
    }

    private static File getRootBackupsFolder() {
        return new File(ConfigData.getFolderLocation(), backupFolderName);
    }

    private static File getBackupFolderForLogType(LogType backupLogType) {
        File backupLocation = YAML.getRootBackupsFolder();
        if (backupLogType == LogType.JOIN) {
            backupLocation = new File(backupLocation, "joins");
        } else if (backupLogType == LogType.QUIT) {
            backupLocation = new File(backupLocation, "quits");
        } else if (backupLogType == LogType.DEATH) {
            backupLocation = new File(backupLocation, "deaths");
        } else if (backupLogType == LogType.WORLD_CHANGE) {
            backupLocation = new File(backupLocation, "worldChanges");
        } else if (backupLogType == LogType.FORCE) {
            backupLocation = new File(backupLocation, "force");
        }
        return backupLocation;
    }

    private static File getPlayerBackupLocation(LogType backupLogType, UUID playerUUID) {
        return new File(YAML.getBackupFolderForLogType(backupLogType), playerUUID.toString());
    }

    public boolean doesBackupTypeExist() {
        return this.getAmountOfBackups() > 0;
    }

    public int getAmountOfBackups() {
        if (!this.playerBackupFolder.exists()) {
            return 0;
        }
        String[] filesArr = this.playerBackupFolder.list();
        if (filesArr == null) {
            return 0;
        }
        return filesArr.length;
    }

    public List<Long> getSelectedPageTimestamps(int pageNumber) {
        ArrayList<Long> allTimeStamps = new ArrayList<Long>();
        if (!this.playerBackupFolder.exists()) {
            return allTimeStamps;
        }
        long currTime = System.currentTimeMillis();
        for (File file : this.playerBackupFolder.listFiles()) {
            long timestamp;
            if (file.isDirectory()) continue;
            int pos = file.getName().lastIndexOf(46);
            String fileName = file.getName().substring(0, pos);
            if (fileName.isEmpty() || !StringUtils.isNumeric(fileName) || currTime - (timestamp = Long.parseLong(fileName)) <= 1000L) continue;
            allTimeStamps.add(timestamp);
        }
        Collections.sort(allTimeStamps, Collections.reverseOrder());
        int backups = InventoryName.ROLLBACK_LIST.getSize() - 9;
        if (allTimeStamps.size() <= backups) {
            return allTimeStamps;
        }
        ArrayList<Long> requiredTimestamps = new ArrayList<Long>();
        for (int i = backups * (pageNumber - 1); i < backups * (pageNumber - 1) + backups && i < allTimeStamps.size(); ++i) {
            requiredTimestamps.add((Long)allTimeStamps.get(i));
        }
        return requiredTimestamps;
    }

    public void purgeExcessSaves(int deleteAmount) {
        ArrayList<Long> timeSaved = new ArrayList<Long>();
        File[] backupFiles = this.playerBackupFolder.listFiles();
        if (backupFiles == null) {
            return;
        }
        for (File file : backupFiles) {
            long saveTimeStamp;
            if (file.isDirectory()) continue;
            int pos = file.getName().lastIndexOf(46);
            String fileName = file.getName().substring(0, pos);
            if (!StringUtils.isNumeric(fileName)) continue;
            try {
                saveTimeStamp = Long.parseLong(fileName);
            }
            catch (NumberFormatException ex) {
                continue;
            }
            if (System.currentTimeMillis() - saveTimeStamp < 1000L) continue;
            timeSaved.add(saveTimeStamp);
        }
        for (int i = 0; i < deleteAmount && !timeSaved.isEmpty(); ++i) {
            Long deleteTimestamp = (Long)Collections.min(timeSaved);
            timeSaved.remove(deleteTimestamp);
            try {
                Files.deleteIfExists(new File(this.playerBackupFolder, deleteTimestamp + ".yml").toPath());
                continue;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void setMainInventory(ItemStack[] items) {
        this.mainInventory = SaveInventory.toBase64(items);
    }

    public void setArmour(ItemStack[] items) {
        this.armour = SaveInventory.toBase64(items);
    }

    public void setEnderChest(ItemStack[] items) {
        this.enderChest = SaveInventory.toBase64(items);
    }

    public void setXP(float xp) {
        this.xp = xp;
    }

    public void setHealth(double health) {
        this.health = health;
    }

    public void setFoodLevel(int foodLevel) {
        this.hunger = foodLevel;
    }

    public void setSaturation(float saturation) {
        this.saturation = saturation;
    }

    public void setWorld(String world) {
        this.world = world;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public void setLogType(LogType logType) {
        this.logType = logType;
    }

    public void setVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    public void setDeathReason(String deathReason) {
        this.deathReason = deathReason;
    }

    public ItemStack[] getMainInventory() {
        String base64 = this.data.getString("inventory");
        return RestoreInventory.getInventoryItems(this.getVersion(), base64);
    }

    public ItemStack[] getArmour() {
        String base64 = this.data.getString("armour");
        return RestoreInventory.getInventoryItems(this.getVersion(), base64);
    }

    public ItemStack[] getEnderChest() {
        String base64 = this.data.getString("enderchest");
        return RestoreInventory.getInventoryItems(this.getVersion(), base64);
    }

    public float getXP() {
        return Float.parseFloat(this.data.getString("xp"));
    }

    public double getHealth() {
        return this.data.getDouble("health");
    }

    public int getFoodLevel() {
        return this.data.getInt("hunger");
    }

    public float getSaturation() {
        return Float.parseFloat(this.data.getString("saturation"));
    }

    public String getWorld() {
        return this.data.getString("location.world");
    }

    public double getX() {
        return this.data.getDouble("location.x");
    }

    public double getY() {
        return this.data.getDouble("location.y");
    }

    public double getZ() {
        return this.data.getDouble("location.z");
    }

    public LogType getSaveType() {
        LogType logType = null;
        try {
            logType = LogType.valueOf(this.data.getString("logType").toUpperCase());
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        return logType;
    }

    public String getVersion() {
        return this.data.getString("version");
    }

    public String getDeathReason() {
        return this.data.getString("deathReason");
    }

    public void saveData() {
        this.data.set("inventory", (Object)this.mainInventory);
        this.data.set("armour", (Object)this.armour);
        this.data.set("enderchest", (Object)this.enderChest);
        this.data.set("xp", (Object)Float.valueOf(this.xp));
        this.data.set("health", (Object)this.health);
        this.data.set("hunger", (Object)this.hunger);
        this.data.set("saturation", (Object)Float.valueOf(this.saturation));
        this.data.set("location.world", (Object)this.world);
        this.data.set("location.x", (Object)this.x);
        this.data.set("location.y", (Object)this.y);
        this.data.set("location.z", (Object)this.z);
        this.data.set("logType", (Object)this.logType.name());
        this.data.set("version", (Object)this.packageVersion);
        this.data.set("deathReason", (Object)this.deathReason);
        try {
            this.data.save(this.backupFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getBackupFolderName() {
        return backupFolderName;
    }

    public static void convertOldBackupData() {
        ArrayList<File> backupLocations = new ArrayList<File>();
        backupLocations.add(new File(ConfigData.getFolderLocation(), "saves/deaths"));
        backupLocations.add(new File(ConfigData.getFolderLocation(), "saves/joins"));
        backupLocations.add(new File(ConfigData.getFolderLocation(), "saves/quits"));
        backupLocations.add(new File(ConfigData.getFolderLocation(), "saves/worldChanges"));
        backupLocations.add(new File(ConfigData.getFolderLocation(), "saves/force"));
        ArrayList<LogType> logTypeFiles = new ArrayList<LogType>();
        int logTypeNumber = 0;
        logTypeFiles.add(LogType.DEATH);
        logTypeFiles.add(LogType.JOIN);
        logTypeFiles.add(LogType.QUIT);
        logTypeFiles.add(LogType.WORLD_CHANGE);
        logTypeFiles.add(LogType.FORCE);
        for (File backupFolders : backupLocations) {
            if (!backupFolders.exists()) {
                InventoryRollbackPlus.getInstance().getConsoleSender().sendMessage(MessageData.getPluginPrefix() + ChatColor.RED + "Backup folder does not exist at " + backupFolders.getAbsolutePath());
                ++logTypeNumber;
                continue;
            }
            ArrayList<File> backupFiles = new ArrayList<File>();
            for (File file : backupFolders.listFiles()) {
                if (!file.isFile() || !file.getName().substring(file.getName().indexOf(46)).equals(".yml")) continue;
                backupFiles.add(file);
            }
            LogType log = (LogType)((Object)logTypeFiles.get(logTypeNumber));
            InventoryRollbackPlus.getInstance().getConsoleSender().sendMessage(MessageData.getPluginPrefix() + "Converting the backup location " + log.name());
            for (File backup : backupFiles) {
                YamlConfiguration data = new YamlConfiguration();
                try {
                    data.load(backup);
                }
                catch (IOException | InvalidConfigurationException e) {
                    InventoryRollbackPlus.getInstance().getConsoleSender().sendMessage(MessageData.getPluginPrefix() + ChatColor.RED + "Error converting backup file at " + backup.getAbsolutePath() + " - Invalid YAML format possibly from corruption.");
                    continue;
                }
                for (String time : data.getConfigurationSection("data").getKeys(false)) {
                    try {
                        Long timestamp = Long.parseLong(time);
                        UUID uuid = UUID.fromString(backup.getName().substring(0, backup.getName().length() - 4));
                        YAML yaml = new YAML(uuid, log, timestamp);
                        String packageVersion = data.getString("data." + timestamp + ".version");
                        yaml.setMainInventory(RestoreInventory.getInventoryItems(packageVersion, data.getString("data." + timestamp + ".inventory")));
                        yaml.setArmour(RestoreInventory.getInventoryItems(packageVersion, data.getString("data." + timestamp + ".armour")));
                        yaml.setEnderChest(RestoreInventory.getInventoryItems(packageVersion, data.getString("data." + timestamp + ".enderchest")));
                        yaml.setXP(Float.parseFloat(data.getString("data." + timestamp + ".xp")));
                        yaml.setHealth(data.getDouble("data." + timestamp + ".health"));
                        yaml.setFoodLevel(data.getInt("data." + timestamp + ".hunger"));
                        yaml.setSaturation(Float.parseFloat(data.getString("data." + timestamp + ".saturation")));
                        yaml.setWorld(data.getString("data." + timestamp + ".location.world"));
                        yaml.setX(data.getDouble("data." + timestamp + ".location.x"));
                        yaml.setY(data.getDouble("data." + timestamp + ".location.y"));
                        yaml.setZ(data.getDouble("data." + timestamp + ".location.z"));
                        String lt = data.getString("data." + timestamp + ".logType");
                        LogType logType = null;
                        logType = lt.equalsIgnoreCase("WORLDCHANGE") ? LogType.WORLD_CHANGE : LogType.valueOf(lt);
                        yaml.setLogType(logType);
                        yaml.setVersion(packageVersion);
                        yaml.setDeathReason(data.getString("data." + timestamp + ".deathReason"));
                        yaml.saveData();
                    }
                    catch (Exception e) {
                        InventoryRollbackPlus.getInstance().getConsoleSender().sendMessage(MessageData.getPluginPrefix() + ChatColor.RED + "Error converting backup file at " + backup.getAbsolutePath() + " on timestamp " + time);
                    }
                }
            }
            ++logTypeNumber;
        }
        InventoryRollbackPlus.getInstance().getConsoleSender().sendMessage(MessageData.getPluginPrefix() + ChatColor.GREEN + "Conversion completed!");
    }
}

