/*
 * Decompiled with CFR 0.152.
 */
package me.danjono.inventoryrollback.gui.menu;

import com.nuclyon.technicallycoded.inventoryrollback.InventoryRollbackPlus;
import java.util.ArrayList;
import java.util.UUID;
import me.danjono.inventoryrollback.config.ConfigData;
import me.danjono.inventoryrollback.config.MessageData;
import me.danjono.inventoryrollback.data.LogType;
import me.danjono.inventoryrollback.data.PlayerData;
import me.danjono.inventoryrollback.gui.Buttons;
import me.danjono.inventoryrollback.gui.InventoryName;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class EnderChestBackupMenu {
    private int pageNumber;
    private Player staff;
    private UUID playerUUID;
    private LogType logType;
    private Long timestamp;
    private ItemStack[] enderchest;
    private Buttons buttons;
    private Inventory inventory;

    public EnderChestBackupMenu(Player staff, PlayerData data, int pageNumberIn) {
        this.staff = staff;
        this.playerUUID = data.getOfflinePlayer().getUniqueId();
        this.logType = data.getLogType();
        this.timestamp = data.getTimestamp();
        this.enderchest = data.getEnderChest();
        this.pageNumber = pageNumberIn;
        this.buttons = new Buttons(this.playerUUID);
        this.createInventory();
    }

    public void createInventory() {
        this.inventory = Bukkit.createInventory((InventoryHolder)this.staff, (int)InventoryName.ENDER_CHEST_BACKUP.getSize(), (String)InventoryName.ENDER_CHEST_BACKUP.getName());
        ArrayList<String> lore = new ArrayList<String>();
        if (this.pageNumber == 1) {
            ItemStack mainInventoryMenu = this.buttons.inventoryMenuBackButton(MessageData.getBackButton(), this.logType, this.timestamp);
            this.inventory.setItem(InventoryName.ENDER_CHEST_BACKUP.getSize() - 8, mainInventoryMenu);
        }
        if (this.pageNumber > 1) {
            lore.add("Page " + (this.pageNumber - 1));
            ItemStack previousPage = this.buttons.enderChestBackButton(MessageData.getPreviousPageButton(), this.logType, this.pageNumber - 1, this.timestamp, lore);
            this.inventory.setItem(InventoryName.ENDER_CHEST_BACKUP.getSize() - 8, previousPage);
        }
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public void showEnderChestItems() {
        int spaceAvailable;
        int itemsToDisplay;
        int pagesRequired;
        if (this.enderchest == null) {
            this.enderchest = new ItemStack[0];
        }
        if (this.pageNumber > (pagesRequired = Math.max(1, (int)Math.ceil((double)(itemsToDisplay = this.enderchest.length) / (double)(spaceAvailable = InventoryName.ROLLBACK_LIST.getSize() - 9))))) {
            this.pageNumber = pagesRequired;
        } else if (this.pageNumber <= 0) {
            this.pageNumber = 1;
        }
        try {
            new BukkitRunnable(){
                int invPosition = 0;
                int itemPos = (EnderChestBackupMenu.access$000(EnderChestBackupMenu.this) - 1) * 27;
                final int max = Math.max(0, this.itemPos + Math.min(EnderChestBackupMenu.access$100(EnderChestBackupMenu.this).length - this.itemPos, 27));

                public void run() {
                    for (int i = 0; i < 6; ++i) {
                        if (this.itemPos >= this.max) {
                            this.cancel();
                            return;
                        }
                        ItemStack itemStack = EnderChestBackupMenu.this.enderchest[this.itemPos];
                        if (itemStack != null) {
                            EnderChestBackupMenu.this.inventory.setItem(this.invPosition, itemStack);
                            ++this.invPosition;
                        }
                        ++this.itemPos;
                    }
                }
            }.runTaskTimer((Plugin)InventoryRollbackPlus.getInstance(), 0L, 1L);
        }
        catch (NullPointerException e) {
            this.staff.sendMessage(MessageData.getPluginPrefix() + MessageData.getErrorInventory());
            return;
        }
        if (ConfigData.isRestoreToPlayerButton()) {
            this.inventory.setItem(InventoryName.ENDER_CHEST_BACKUP.getSize() - 5, this.buttons.restoreAllInventory(this.logType, this.timestamp));
        } else {
            this.inventory.setItem(InventoryName.ENDER_CHEST_BACKUP.getSize() - 5, this.buttons.restoreAllInventoryDisabled(this.logType, this.timestamp));
        }
        ArrayList<String> lore = new ArrayList<String>();
        if (this.pageNumber < pagesRequired) {
            lore.add("Page " + (this.pageNumber + 1));
            ItemStack nextPage = this.buttons.enderChestNextButton(MessageData.getNextPageButton(), this.logType, this.pageNumber + 1, this.timestamp, lore);
            this.inventory.setItem(InventoryName.ENDER_CHEST_BACKUP.getSize() - 2, nextPage);
            lore.clear();
        }
    }

    static /* synthetic */ int access$000(EnderChestBackupMenu x0) {
        return x0.pageNumber;
    }
}

