/*
 * Decompiled with CFR 0.152.
 */
package me.danjono.inventoryrollback.gui.menu;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.danjono.inventoryrollback.config.MessageData;
import me.danjono.inventoryrollback.data.LogType;
import me.danjono.inventoryrollback.data.PlayerData;
import me.danjono.inventoryrollback.gui.Buttons;
import me.danjono.inventoryrollback.gui.InventoryName;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class RollbackListMenu {
    private int pageNumber;
    private Player staff;
    private UUID playerUUID;
    private LogType logType;
    private Buttons buttons;
    private Inventory inventory;

    public RollbackListMenu(Player staff, OfflinePlayer player, LogType logType, int pageNumberIn) {
        this.staff = staff;
        this.playerUUID = player.getUniqueId();
        this.logType = logType;
        this.pageNumber = pageNumberIn;
        this.buttons = new Buttons(this.playerUUID);
        this.createInventory();
    }

    public void createInventory() {
        this.inventory = Bukkit.createInventory((InventoryHolder)this.staff, (int)InventoryName.ROLLBACK_LIST.getSize(), (String)InventoryName.ROLLBACK_LIST.getName());
        ArrayList<String> lore = new ArrayList<String>();
        if (this.pageNumber == 1) {
            ItemStack mainMenu = this.buttons.backButton(MessageData.getMainMenuButton(), this.logType, 0, null);
            this.inventory.setItem(InventoryName.ROLLBACK_LIST.getSize() - 8, mainMenu);
        }
        if (this.pageNumber > 1) {
            lore.add("Page " + (this.pageNumber - 1));
            ItemStack previousPage = this.buttons.backButton(MessageData.getPreviousPageButton(), this.logType, this.pageNumber - 1, lore);
            this.inventory.setItem(InventoryName.ROLLBACK_LIST.getSize() - 8, previousPage);
            lore.clear();
        }
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public void showBackups() {
        int spaceRequired;
        PlayerData playerData = new PlayerData(this.playerUUID, this.logType, null);
        int backups = playerData.getAmountOfBackups();
        int pagesRequired = (int)Math.ceil((double)backups / (double)(spaceRequired = InventoryName.ROLLBACK_LIST.getSize() - 9));
        if (this.pageNumber > pagesRequired) {
            this.pageNumber = pagesRequired;
        } else if (this.pageNumber <= 0) {
            this.pageNumber = 1;
        }
        int backupsAlreadyPassed = spaceRequired * (this.pageNumber - 1);
        int backupsOnCurrentPage = Math.min(backups, Math.min(spaceRequired, backups - backupsAlreadyPassed));
        List<Long> timeStamps = playerData.getSelectedPageTimestamps(this.pageNumber);
        int position = 0;
        for (int i = 0; i < backupsOnCurrentPage; ++i) {
            try {
                Long timestamp = timeStamps.get(i);
                playerData = new PlayerData(this.playerUUID, this.logType, timestamp);
                playerData.getRollbackMenuData();
                String displayName = MessageData.getDeathTime(PlayerData.getTime(timestamp));
                ArrayList<String> lore = new ArrayList<String>();
                String deathReason = playerData.getDeathReason();
                if (deathReason != null) {
                    lore.add(MessageData.getDeathReason(deathReason));
                }
                String world = playerData.getWorld();
                double x = playerData.getX();
                double y = playerData.getY();
                double z = playerData.getZ();
                String location = world + "," + x + "," + y + "," + z;
                lore.add(MessageData.getDeathLocationWorld(world));
                lore.add(MessageData.getDeathLocationX(x));
                lore.add(MessageData.getDeathLocationY(y));
                lore.add(MessageData.getDeathLocationZ(z));
                ItemStack item = this.buttons.createInventoryButton(new ItemStack(Material.CHEST), this.logType, location, timestamp, displayName, lore);
                this.inventory.setItem(position, item);
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
            }
            ++position;
        }
        ArrayList<String> lore = new ArrayList<String>();
        if (this.pageNumber < pagesRequired) {
            lore.add("Page " + (this.pageNumber + 1));
            ItemStack nextPage = this.buttons.nextButton(MessageData.getNextPageButton(), this.logType, this.pageNumber + 1, lore);
            this.inventory.setItem(position + 7, nextPage);
            lore.clear();
        }
    }
}

