/*
 * Decompiled with CFR 0.152.
 */
package me.danjono.inventoryrollback.inventory;

import com.nuclyon.technicallycoded.inventoryrollback.InventoryRollbackPlus;
import com.nuclyon.technicallycoded.inventoryrollback.bukkitversion.BukkitVersion;
import com.nuclyon.technicallycoded.inventoryrollback.util.UserLogRateLimiter;
import com.nuclyon.technicallycoded.inventoryrollback.util.serialization.ItemStackSerialization;
import java.util.Arrays;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.danjono.inventoryrollback.InventoryRollback;
import me.danjono.inventoryrollback.data.LogType;
import me.danjono.inventoryrollback.data.PlayerData;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class SaveInventory {
    private static final HashMap<UUID, UserLogRateLimiter> rateLimiters = new HashMap();
    private final InventoryRollbackPlus main = InventoryRollbackPlus.getInstance();
    private final long timestamp = System.currentTimeMillis();
    private final Player player;
    private final LogType logType;
    private final EntityDamageEvent.DamageCause deathCause;
    private final String causeAlias;

    public SaveInventory(Player player, LogType logType, EntityDamageEvent.DamageCause deathCause, String causeAliasIn) {
        this.player = player;
        this.logType = logType;
        this.deathCause = deathCause;
        this.causeAlias = causeAliasIn;
    }

    public void snapshotAndSave(PlayerInventory mainInventory, Inventory enderChestInventory, boolean saveAsync) {
        PlayerDataSnapshot snapshot = this.createSnapshot(mainInventory, enderChestInventory);
        if (snapshot == null) {
            return;
        }
        this.save(snapshot, saveAsync);
    }

    public void save(PlayerDataSnapshot snapshot, boolean async) {
        if (snapshot == null) {
            return;
        }
        UUID uuid = this.player.getUniqueId();
        UserLogRateLimiter userLogRateLimiter = rateLimiters.get(uuid);
        if (userLogRateLimiter == null) {
            userLogRateLimiter = new UserLogRateLimiter();
            rateLimiters.put(uuid, userLogRateLimiter);
        }
        userLogRateLimiter.log(this.logType, this.timestamp);
        if (userLogRateLimiter.isRateLimitExceeded(this.logType)) {
            this.main.getLogger().warning("Player " + this.player.getName() + " is being rate limited! This means that something is causing this log to be created FASTER than even once per tick! Log type: " + this.logType.name());
            new IllegalStateException("Rate limiting reached! This should never happen under normal operation!").printStackTrace();
            return;
        }
        boolean saveAsync = !InventoryRollbackPlus.getInstance().isShuttingDown() && async;
        Runnable saveTask = () -> {
            PlayerData data = new PlayerData((OfflinePlayer)this.player, this.logType, (Long)this.timestamp);
            if (snapshot.finalMainInvContents != null) {
                data.setMainInventory(snapshot.finalMainInvContents);
            }
            if (snapshot.finalMainInvArmor != null) {
                data.setArmour(snapshot.finalMainInvArmor);
            }
            if (snapshot.finalEnderInvContents != null) {
                data.setEnderChest(snapshot.finalEnderInvContents);
            }
            data.setXP(snapshot.totalXp);
            data.setHealth(snapshot.health);
            data.setFoodLevel(snapshot.foodLevel);
            data.setSaturation(snapshot.saturation);
            data.setWorld(snapshot.worldName);
            data.setX(snapshot.locX);
            data.setY(snapshot.locY);
            data.setZ(snapshot.locZ);
            data.setLogType(this.logType);
            data.setVersion(InventoryRollback.getPackageVersion());
            if (this.causeAlias != null) {
                data.setDeathReason(this.causeAlias);
            } else if (this.deathCause != null) {
                data.setDeathReason(this.deathCause.name());
            } else if (this.logType == LogType.DEATH) {
                data.setDeathReason("UNKNOWN");
            }
            CompletableFuture<Void> purgeTask = data.purgeExcessSaves(saveAsync);
            purgeTask.thenRun(() -> data.saveData(saveAsync));
        };
        if (saveAsync) {
            this.main.getServer().getScheduler().runTaskAsynchronously((Plugin)this.main, saveTask);
        } else {
            saveTask.run();
        }
    }

    @Nullable
    public PlayerDataSnapshot createSnapshot(PlayerInventory mainInventory, Inventory enderChestInventory) {
        ItemStack[] mainInvContents = null;
        ItemStack[] mainInvArmor = null;
        ItemStack[] enderInvContents = null;
        for (ItemStack item : mainInventory.getContents()) {
            if (item == null) continue;
            mainInvContents = this.copyItemArray(mainInventory.getContents());
            break;
        }
        if (this.main.getVersion().lessOrEqThan(BukkitVersion.v1_8_R3)) {
            for (ItemStack item : mainInventory.getArmorContents()) {
                if (item == null) continue;
                mainInvArmor = this.copyItemArray(mainInventory.getArmorContents());
                break;
            }
        }
        for (ItemStack item : enderChestInventory.getContents()) {
            if (item == null) continue;
            enderInvContents = this.copyItemArray(enderChestInventory.getContents());
            break;
        }
        float totalXp = this.getTotalExperience(this.player);
        double health = this.player.getHealth();
        int foodLevel = this.player.getFoodLevel();
        float saturation = this.player.getSaturation();
        String worldName = this.player.getWorld().getName();
        Location pLoc = this.player.getLocation();
        double locX = (double)((int)(pLoc.getX() * 10.0)) / 10.0;
        double locY = (double)((int)(pLoc.getY() * 10.0)) / 10.0;
        double locZ = (double)((int)(pLoc.getZ() * 10.0)) / 10.0;
        ItemStack[] finalMainInvContents = mainInvContents;
        ItemStack[] finalMainInvArmor = mainInvArmor;
        ItemStack[] finalEnderInvContents = enderInvContents;
        return new PlayerDataSnapshot(totalXp, health, foodLevel, saturation, worldName, locX, locY, locZ, finalMainInvContents, finalMainInvArmor, finalEnderInvContents);
    }

    private ItemStack[] copyItemArray(ItemStack[] contents) {
        ItemStack[] copy = new ItemStack[contents.length];
        for (int i = 0; i < contents.length; ++i) {
            if (contents[i] == null) continue;
            copy[i] = contents[i].clone();
        }
        return copy;
    }

    public static String toBase64(ItemStack[] contents) {
        return ItemStackSerialization.serialize(contents);
    }

    private float getTotalExperience(Player player) {
        int requiredExperience;
        int experience;
        int level = player.getLevel();
        float currentExp = player.getExp();
        if (level >= 0 && level <= 15) {
            experience = (int)Math.ceil(Math.pow(level, 2.0) + (double)(6 * level));
            requiredExperience = 2 * level + 7;
        } else if (level > 15 && level <= 30) {
            experience = (int)Math.ceil(2.5 * Math.pow(level, 2.0) - 40.5 * (double)level + 360.0);
            requiredExperience = 5 * level - 38;
        } else {
            experience = (int)Math.ceil(4.5 * Math.pow(level, 2.0) - 162.5 * (double)level + 2220.0);
            requiredExperience = 9 * level - 158;
        }
        experience = (int)((double)experience + Math.ceil(currentExp * (float)requiredExperience));
        return experience;
    }

    public static void cleanup(UUID uuid) {
        rateLimiters.remove(uuid);
    }

    public static class PlayerDataSnapshot {
        public final float totalXp;
        public final double health;
        public final int foodLevel;
        public final float saturation;
        public final String worldName;
        public final double locX;
        public final double locY;
        public final double locZ;
        public final ItemStack[] finalMainInvContents;
        public final ItemStack[] finalMainInvArmor;
        public final ItemStack[] finalEnderInvContents;

        public PlayerDataSnapshot(float totalXp, double health, int foodLevel, float saturation, String worldName, double locX, double locY, double locZ, ItemStack[] finalMainInvContents, ItemStack[] finalMainInvArmor, ItemStack[] finalEnderInvContents) {
            this.totalXp = totalXp;
            this.health = health;
            this.foodLevel = foodLevel;
            this.saturation = saturation;
            this.worldName = worldName;
            this.locX = locX;
            this.locY = locY;
            this.locZ = locZ;
            this.finalMainInvContents = finalMainInvContents;
            this.finalMainInvArmor = finalMainInvArmor;
            this.finalEnderInvContents = finalEnderInvContents;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PlayerDataSnapshot that = (PlayerDataSnapshot)obj;
            if (Double.compare(that.health, this.health) != 0) {
                return false;
            }
            if (this.foodLevel != that.foodLevel) {
                return false;
            }
            if (Float.compare(that.saturation, this.saturation) != 0) {
                return false;
            }
            if (Double.compare(that.locX, this.locX) != 0) {
                return false;
            }
            if (Double.compare(that.locY, this.locY) != 0) {
                return false;
            }
            if (Double.compare(that.locZ, this.locZ) != 0) {
                return false;
            }
            if (Float.compare(that.totalXp, this.totalXp) != 0) {
                return false;
            }
            if (!this.worldName.equals(that.worldName)) {
                return false;
            }
            if (!Arrays.equals(this.finalMainInvContents, that.finalMainInvContents)) {
                return false;
            }
            if (!Arrays.equals(this.finalMainInvArmor, that.finalMainInvArmor)) {
                return false;
            }
            return Arrays.equals(this.finalEnderInvContents, that.finalEnderInvContents);
        }

        public String toString() {
            return "PlayerDataSnapshot{totalXp=" + this.totalXp + ", health=" + this.health + ", foodLevel=" + this.foodLevel + ", saturation=" + this.saturation + ", worldName='" + this.worldName + '\'' + ", locX=" + this.locX + ", locY=" + this.locY + ", locZ=" + this.locZ + ", finalMainInvContents=" + Arrays.toString(this.finalMainInvContents) + ", finalMainInvArmor=" + Arrays.toString(this.finalMainInvArmor) + ", finalEnderInvContents=" + Arrays.toString(this.finalEnderInvContents) + '}';
        }
    }
}

